package JSci.maths.wavelet.splines;

import JSci.maths.wavelet.*;
/**************************************************
* This class is meant as an abstract encapsulation
* for spline objects.
***************************************************/
public abstract class Spline extends MultiscaleFunction  implements Cloneable  {

  public abstract int dimension(int j);

  public abstract int dimension();

	public  Object clone() {
    Spline s=(Spline) super.clone();
    return(s);
  }

  public abstract String toString();

  public abstract double[] evaluate(int parm1);

  public abstract int getFilterType();

  public abstract boolean equals(Object parm1);
  /**********************************************
  * The interpolate method should be return
  * the actual value of the spline on knots.
  * This value would differ in general from the
  * value generated by the Cascades algorithm
  * and got from the method evaluate.
  * This doesn't apply to splines of order -1,0 and 1.
  ************************************************/
  public abstract double[] interpolate (int j);
}
