/*
 * Decompiled with CFR 0.152.
 */
package adams.data.jai.transformer;

import adams.data.jai.BufferedImageContainer;
import adams.data.jai.transformer.AbstractJAITransformer;
import java.awt.image.BufferedImage;

public class Crop
extends AbstractJAITransformer {
    private static final long serialVersionUID = 2959486760492196174L;
    protected int m_X;
    protected int m_Y;
    protected int m_Width;
    protected int m_Height;
    protected Anchor m_Anchor;

    public String globalInfo() {
        return "Crops the image to specified width and height. Where the crop rectangle starts is defined by the X and Y position and the anchor.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("x", "X", (Object)1, (Number)1, null);
        this.m_OptionManager.add("y", "Y", (Object)1, (Number)1, null);
        this.m_OptionManager.add("width", "width", (Object)100, (Number)1, null);
        this.m_OptionManager.add("height", "height", (Object)75, (Number)1, null);
        this.m_OptionManager.add("anchor", "anchor", (Object)Anchor.TOP_LEFT);
    }

    public void setX(int value) {
        if (value > 0) {
            this.m_X = value;
            this.reset();
        } else {
            this.getSystemErr().println("X has to be >0, provided: " + value);
        }
    }

    public int getX() {
        return this.m_X;
    }

    public String XTipText() {
        return "The horizontal pixel position.";
    }

    public void setY(int value) {
        if (value > 0) {
            this.m_Y = value;
            this.reset();
        } else {
            this.getSystemErr().println("Y has to be >0, provided: " + value);
        }
    }

    public int getY() {
        return this.m_Y;
    }

    public String YTipText() {
        return "The vertical pixel position.";
    }

    public void setWidth(int value) {
        if (value > 0) {
            this.m_Width = value;
            this.reset();
        } else {
            this.getSystemErr().println("Width has to be >0, provided: " + value);
        }
    }

    public int getWidth() {
        return this.m_Width;
    }

    public String widthTipText() {
        return "The width of the crop rectangle.";
    }

    public void setHeight(int value) {
        if (value > 0) {
            this.m_Height = value;
            this.reset();
        } else {
            this.getSystemErr().println("Height has to be >0, provided: " + value);
        }
    }

    public int getHeight() {
        return this.m_Height;
    }

    public String heightTipText() {
        return "The height of the crop rectangle.";
    }

    public void setAnchor(Anchor value) {
        this.m_Anchor = value;
        this.reset();
    }

    public Anchor getAnchor() {
        return this.m_Anchor;
    }

    public String anchorTipText() {
        return "Defines where to anchor the position on the crop rectangle.";
    }

    protected BufferedImageContainer[] doTransform(BufferedImageContainer img) {
        int topOrig;
        int leftOrig;
        BufferedImageContainer[] result = new BufferedImageContainer[]{(BufferedImageContainer)img.getHeader()};
        BufferedImage image = new BufferedImage(this.m_Width, this.m_Height, 2);
        switch (this.m_Anchor) {
            case TOP_LEFT: {
                leftOrig = this.m_X - 1;
                topOrig = this.m_Y - 1;
                break;
            }
            case TOP_RIGHT: {
                leftOrig = this.m_X - 1 - this.m_Width;
                topOrig = this.m_Y - 1;
                break;
            }
            case BOTTOM_LEFT: {
                leftOrig = this.m_X - 1;
                topOrig = this.m_Y - 1 - this.m_Height;
                break;
            }
            case BOTTOM_RIGHT: {
                leftOrig = this.m_X - 1 - this.m_Width;
                topOrig = this.m_Y - 1 - this.m_Height;
                break;
            }
            case CENTER: {
                leftOrig = this.m_X - 1 - this.m_Width / 2;
                topOrig = this.m_Y - 1 - this.m_Height / 2;
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled anchor: " + (Object)((Object)this.m_Anchor));
            }
        }
        if (this.isDebugOn()) {
            this.debug("x=" + (this.m_X - 1) + ", y=" + (this.m_Y - 1) + ", width=" + this.m_Width + ", height=" + this.m_Height + ", anchor=" + (Object)((Object)this.m_Anchor));
            this.debug("  --> leftOrig=" + leftOrig + ", topOrig=" + topOrig);
        }
        int heightOrig = img.getHeight();
        int widthOrig = img.getWidth();
        for (int y = 0; y < this.m_Height; ++y) {
            int yOrig = topOrig + y;
            if (yOrig < 0 || yOrig >= heightOrig) continue;
            for (int x = 0; x < this.m_Width; ++x) {
                int xOrig = leftOrig + x;
                if (xOrig < 0 || xOrig >= widthOrig) continue;
                image.setRGB(x, y, ((BufferedImage)img.getImage()).getRGB(xOrig, yOrig));
            }
        }
        result[0].setImage(image);
        return result;
    }

    public static enum Anchor {
        TOP_LEFT,
        TOP_RIGHT,
        CENTER,
        BOTTOM_LEFT,
        BOTTOM_RIGHT;

    }
}

