/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.ujmp.core.Matrix;
import org.ujmp.core.MatrixFactory;
import org.ujmp.core.enums.ValueType;
import org.ujmp.core.exceptions.MatrixException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ImportMatrixATOM {
    public static final Matrix fromStream(InputStream stream, Object ... parameters) throws MatrixException, ParserConfigurationException, SAXException, IOException {
        Node n;
        int c;
        Matrix m = null;
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(stream);
        NodeList items = doc.getElementsByTagName("entry");
        m = MatrixFactory.dense(ValueType.OBJECT, items.getLength(), 5L);
        m.setColumnLabel(0L, "Id");
        m.setColumnLabel(1L, "Label");
        m.setColumnLabel(2L, "Link");
        m.setColumnLabel(3L, "Description");
        m.setColumnLabel(4L, "Date");
        int i = 0;
        while (i < items.getLength()) {
            Node item = items.item(i);
            c = 0;
            while (c < item.getChildNodes().getLength()) {
                n = item.getChildNodes().item(c);
                if (n.getNodeName().equalsIgnoreCase("id")) {
                    m.setAsObject(n.getTextContent(), i, 0L);
                } else if (n.getNodeName().equalsIgnoreCase("title")) {
                    m.setAsObject(n.getTextContent(), i, 1L);
                } else if (n.getNodeName().equalsIgnoreCase("link")) {
                    Node h = n.getAttributes().getNamedItem("href");
                    if (h != null) {
                        m.setAsObject(h.getTextContent(), i, 2L);
                    } else {
                        m.setAsObject(n.getTextContent(), i, 2L);
                    }
                } else if (n.getNodeName().equalsIgnoreCase("summary")) {
                    m.setAsObject(n.getTextContent(), i, 3L);
                } else if (n.getNodeName().equalsIgnoreCase("updated")) {
                    m.setAsObject(n.getTextContent(), i, 4L);
                }
                ++c;
            }
            ++i;
        }
        NodeList channels = doc.getElementsByTagName("feed");
        if (channels.getLength() > 0) {
            Node channel = channels.item(0);
            c = 0;
            while (c < channel.getChildNodes().getLength()) {
                n = channel.getChildNodes().item(c);
                if (n.getNodeName().equalsIgnoreCase("title")) {
                    m.setLabel(n.getTextContent());
                }
                ++c;
            }
        }
        return m;
    }

    public static final Matrix fromFile(File file, Object ... parameters) throws MatrixException, ParserConfigurationException, SAXException, IOException {
        FileInputStream lr = new FileInputStream(file);
        Matrix m = ImportMatrixATOM.fromStream(lr, parameters);
        lr.close();
        return m;
    }
}

