/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import adams.gui.application.Child;
import adams.gui.core.GUIHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;

public class BasePanel
extends JPanel {
    private static final long serialVersionUID = -6780889707840400801L;

    public BasePanel() {
        this(new BorderLayout());
    }

    public BasePanel(LayoutManager manager) {
        super(manager);
        this.initialize();
        this.initGUI();
        this.finishInit();
    }

    protected void initialize() {
    }

    protected void initGUI() {
    }

    protected void finishInit() {
    }

    public Frame getParentFrame() {
        return GUIHelper.getParentFrame(this);
    }

    public Dialog getParentDialog() {
        return GUIHelper.getParentDialog(this);
    }

    public Child getParentChild() {
        return GUIHelper.getParentChild(this);
    }

    public JInternalFrame getParentInternalFrame() {
        return GUIHelper.getParentInternalFrame(this);
    }

    public void closeParent() {
        if (this.getParentDialog() != null) {
            Dialog dialog = this.getParentDialog();
            dialog.setVisible(false);
        } else if (this.getParentFrame() != null) {
            JInternalFrame jintframe = this.getParentInternalFrame();
            if (jintframe != null) {
                jintframe.doDefaultCloseAction();
            } else {
                Frame frame = this.getParentFrame();
                if (frame instanceof JFrame) {
                    JFrame jframe = (JFrame)frame;
                    if (jframe.getDefaultCloseOperation() == 1) {
                        jframe.setVisible(false);
                    } else if (jframe.getDefaultCloseOperation() == 2) {
                        jframe.dispose();
                    } else if (jframe.getDefaultCloseOperation() == 3) {
                        System.exit(0);
                    }
                    WindowListener[] listeners = jframe.getWindowListeners();
                    WindowEvent event = new WindowEvent(jframe, 202);
                    for (int i = 0; i < listeners.length; ++i) {
                        listeners[i].windowClosed(event);
                    }
                } else {
                    frame.dispose();
                }
            }
        }
    }

    protected void beforeShow() {
    }

    protected void afterShow() {
    }

    protected void beforeHide() {
    }

    protected void afterHide() {
    }

    @Override
    public void setVisible(boolean value) {
        if (value) {
            this.beforeShow();
        } else {
            this.beforeHide();
        }
        super.setVisible(value);
        if (value) {
            this.afterShow();
        } else {
            this.afterHide();
        }
    }

    public String getParentTitle() {
        if (this.getParentDialog() != null) {
            return this.getParentDialog().getTitle();
        }
        if (this.getParentChild() != null) {
            return this.getParentChild().getTitle();
        }
        if (this.getParentFrame() != null) {
            return this.getParentFrame().getTitle();
        }
        return null;
    }

    public void setParentTitle(String value) {
        if (this.getParentDialog() != null) {
            this.getParentDialog().setTitle(value);
        } else if (this.getParentChild() != null) {
            this.getParentChild().setTitle(value);
        } else if (this.getParentFrame() != null) {
            this.getParentFrame().setTitle(value);
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.out.println("\nUsage: " + BasePanel.class.getName() + " <classname of BasePanel descendant>" + "\n");
            System.exit(1);
        }
        BasePanel panel = (BasePanel)Class.forName(args[0]).newInstance();
        JFrame jf = new JFrame(panel.getClass().getName());
        jf.getContentPane().setLayout(new BorderLayout());
        jf.getContentPane().add((Component)panel, "Center");
        jf.setDefaultCloseOperation(3);
        jf.pack();
        jf.setSize(800, 600);
        jf.setLocationRelativeTo(null);
        jf.setVisible(true);
    }
}

