/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.dialog;

import adams.gui.chooser.AbstractChooserPanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.ParameterPanel;
import adams.gui.dialog.AbstractApprovalDialog;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.util.Vector;

public abstract class AbstractPreferencesDialog
extends AbstractApprovalDialog {
    private static final long serialVersionUID = 7147933476003801800L;
    protected ParameterPanel m_PanelPreferences;
    protected Vector<String> m_Identifiers;

    public AbstractPreferencesDialog(Dialog owner) {
        super(owner, Dialog.ModalityType.DOCUMENT_MODAL);
    }

    public AbstractPreferencesDialog(Frame owner) {
        super(owner, true);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Identifiers = new Vector();
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.setTitle("Preferences");
        this.setDefaultCloseOperation(2);
        this.m_PanelPreferences = new ParameterPanel();
        this.getContentPane().add((Component)new BaseScrollPane(this.m_PanelPreferences), "Center");
    }

    protected void clearPreferences() {
        this.m_Identifiers.clear();
        this.m_PanelPreferences.clearParameters();
    }

    public void addPreference(String identifier, String label, Component comp) {
        if (this.m_Identifiers.contains(identifier)) {
            throw new IllegalArgumentException("Identifier '" + identifier + "' already present!");
        }
        this.m_Identifiers.add(identifier);
        this.m_PanelPreferences.addParameter(label, comp);
    }

    public void addPreference(String identifier, String label, AbstractChooserPanel chooser) {
        if (this.m_Identifiers.contains(identifier)) {
            throw new IllegalArgumentException("Identifier '" + identifier + "' already present!");
        }
        this.m_Identifiers.add(identifier);
        this.m_PanelPreferences.addParameter(label, (Component)chooser);
    }

    public Component getPreference(int index) {
        return this.m_PanelPreferences.getParameter(index);
    }

    public Component getPreference(String identifier) {
        int index = this.m_Identifiers.indexOf(identifier);
        if (index == -1) {
            return null;
        }
        return this.m_PanelPreferences.getParameter(index);
    }

    public int getPreferenceCount() {
        return this.m_PanelPreferences.getParameterCount();
    }
}

