/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.core;

import adams.gui.event.PaintEvent;
import adams.gui.event.PaintListener;
import adams.gui.event.PlotPanelPanningListener;
import adams.gui.event.PlotPanelZoomListener;
import adams.gui.print.PrintMouseListener;
import adams.gui.visualization.core.AxisPanel;
import adams.gui.visualization.core.MouseMovementTracker;
import adams.gui.visualization.core.PopupMenuCustomizer;
import adams.gui.visualization.core.axis.Direction;
import adams.gui.visualization.core.axis.Orientation;
import adams.gui.visualization.core.axis.Type;
import adams.gui.visualization.core.axis.Visibility;
import adams.gui.visualization.core.plot.AbstractHitDetector;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.core.plot.ContentPanel;
import adams.gui.visualization.core.plot.TipTextCustomizer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class PlotPanel
extends JPanel {
    private static final long serialVersionUID = -3406313912401195452L;
    protected AxisPanel m_AxisBottom;
    protected AxisPanel m_AxisTop;
    protected AxisPanel m_AxisLeft;
    protected AxisPanel m_AxisRight;
    protected ContentPanel m_PanelContent;
    protected int m_AxisWidth;
    protected JPanel m_CornerTopLeft;
    protected JPanel m_CornerTopRight;
    protected JPanel m_CornerBottomLeft;
    protected JPanel m_CornerBottomRight;
    protected HashSet<PaintListener> m_PaintListeners;
    protected Vector<Axis> m_ToolTipAxes;
    protected boolean m_Debug;
    protected Color m_GridColor;
    protected Color m_BackgroundColor;
    protected Color m_ForegroundColor;

    public PlotPanel() {
        this(false);
    }

    public PlotPanel(boolean debug) {
        this.m_Debug = debug;
        this.m_AxisWidth = 40;
        this.m_PaintListeners = new HashSet();
        this.m_ToolTipAxes = new Vector();
        this.m_GridColor = new Color(235, 235, 235);
        this.m_BackgroundColor = Color.WHITE;
        this.m_ForegroundColor = Color.BLACK;
        this.initGUI();
    }

    protected JPanel createCornerPanel() {
        JPanel result = new JPanel();
        result.setMinimumSize(new Dimension(this.m_AxisWidth, 0));
        result.setMaximumSize(new Dimension(this.m_AxisWidth, 0));
        result.setPreferredSize(new Dimension(this.m_AxisWidth, 0));
        return result;
    }

    protected void updateCornerPanel(JPanel panel, int width, int height) {
        Dimension size = new Dimension(width, height);
        panel.setPreferredSize(size);
        panel.setMinimumSize(size);
        panel.setMaximumSize(size);
    }

    protected void initGUI() {
        this.setLayout(new BorderLayout());
        this.m_PanelContent = new ContentPanel(this);
        this.add((Component)this.m_PanelContent, "Center");
        this.m_AxisLeft = new AxisPanel(Direction.VERTICAL, Orientation.LEFT_TO_RIGHT, Type.ABSOLUTE);
        this.m_AxisLeft.setAxisWidth(this.m_AxisWidth);
        this.m_AxisLeft.addChangeListener(this.m_PanelContent);
        this.m_AxisRight = new AxisPanel(Direction.VERTICAL, Orientation.RIGHT_TO_LEFT, Type.ABSOLUTE);
        this.m_AxisRight.setAxisWidth(this.m_AxisWidth);
        this.m_AxisRight.addChangeListener(this.m_PanelContent);
        this.m_AxisTop = new AxisPanel(Direction.HORIZONTAL, Orientation.RIGHT_TO_LEFT, Type.ABSOLUTE);
        this.m_AxisTop.setAxisWidth(this.m_AxisWidth);
        this.m_AxisTop.addChangeListener(this.m_PanelContent);
        this.m_AxisBottom = new AxisPanel(Direction.HORIZONTAL, Orientation.LEFT_TO_RIGHT, Type.ABSOLUTE);
        this.m_AxisBottom.setAxisWidth(this.m_AxisWidth);
        this.m_AxisBottom.addChangeListener(this.m_PanelContent);
        for (Axis axis : Axis.values()) {
            this.getAxis(axis).addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getButton() == 1 && e.getModifiers() == 16) {
                        PlotPanel.this.getContent().requestFocusInWindow();
                        e.consume();
                    } else {
                        super.mouseClicked(e);
                    }
                }
            });
        }
        this.m_CornerTopLeft = this.createCornerPanel();
        this.m_CornerTopRight = this.createCornerPanel();
        this.m_CornerBottomLeft = this.createCornerPanel();
        this.m_CornerBottomRight = this.createCornerPanel();
        this.add((Component)this.m_AxisLeft, "West");
        this.add((Component)this.m_AxisRight, "East");
        JPanel panelNorth = new JPanel(new BorderLayout());
        this.add((Component)panelNorth, "North");
        panelNorth.add((Component)this.m_CornerTopLeft, "West");
        panelNorth.add((Component)this.m_AxisTop, "Center");
        panelNorth.add((Component)this.m_CornerTopRight, "East");
        JPanel panelSouth = new JPanel(new BorderLayout());
        this.add((Component)panelSouth, "South");
        panelSouth.add((Component)this.m_CornerBottomLeft, "West");
        panelSouth.add((Component)this.m_AxisBottom, "Center");
        panelSouth.add((Component)this.m_CornerBottomRight, "East");
        this.setAxisWidth(Axis.LEFT, 80);
        this.setAxisWidth(Axis.RIGHT, 80);
        this.setAxisWidth(Axis.TOP, 40);
        this.setAxisWidth(Axis.BOTTOM, 40);
        this.setAxisVisibility(Axis.LEFT, Visibility.INVISIBLE);
        this.setAxisVisibility(Axis.RIGHT, Visibility.INVISIBLE);
        this.setAxisVisibility(Axis.TOP, Visibility.INVISIBLE);
        this.setAxisVisibility(Axis.BOTTOM, Visibility.INVISIBLE);
        if (this.m_Debug) {
            this.m_AxisLeft.setAxisName("Left");
            this.m_AxisRight.setAxisName("Right");
            this.m_AxisTop.setAxisName("Top");
            this.m_AxisBottom.setAxisName("Bottom");
            this.m_AxisLeft.setType(Type.PERCENTAGE);
            this.m_AxisLeft.setMinimum(1.0);
            this.m_AxisLeft.setMaximum(11.0);
            this.m_AxisRight.setType(Type.ABSOLUTE);
            this.m_AxisRight.setMinimum(-2.0);
            this.m_AxisRight.setMaximum(11.0);
            this.m_AxisTop.setType(Type.ABSOLUTE);
            this.m_AxisTop.setMinimum(0.0);
            this.m_AxisTop.setMaximum(1.0);
            this.m_AxisBottom.setType(Type.PERCENTAGE);
            this.m_AxisBottom.setMinimum(3.0);
            this.m_AxisBottom.setMaximum(27.0);
            this.m_AxisLeft.setBackground(Color.RED.brighter());
            this.m_AxisRight.setBackground(Color.RED.darker());
            this.m_AxisTop.setBackground(Color.GREEN.brighter());
            this.m_AxisBottom.setBackground(Color.GREEN.darker());
            this.m_PanelContent.setBackground(Color.BLUE.brighter());
            this.m_CornerTopLeft.setBackground(Color.YELLOW);
            this.m_CornerTopRight.setBackground(Color.YELLOW);
            this.m_CornerBottomLeft.setBackground(Color.YELLOW);
            this.m_CornerBottomRight.setBackground(Color.YELLOW);
            this.addToolTipAxis(Axis.LEFT);
            this.addToolTipAxis(Axis.RIGHT);
            this.addToolTipAxis(Axis.BOTTOM);
            this.addToolTipAxis(Axis.TOP);
            this.setAxisVisibility(Axis.LEFT, Visibility.VISIBLE);
            this.setAxisVisibility(Axis.RIGHT, Visibility.VISIBLE);
            this.setAxisVisibility(Axis.TOP, Visibility.VISIBLE);
            this.setAxisVisibility(Axis.BOTTOM, Visibility.VISIBLE);
            this.addPaintListener(new PaintListener(){

                @Override
                public void painted(PaintEvent e) {
                    Graphics g = e.getGraphics();
                    int y = PlotPanel.this.m_AxisLeft.valueToPos(1.0);
                    int x = PlotPanel.this.m_AxisBottom.valueToPos(5.0);
                    g.drawLine(x, y, x, y);
                }
            });
        }
        this.addPrintScreenListener(this);
        this.addPrintScreenListener(this.m_PanelContent);
        this.addPrintScreenListener(this.m_AxisTop);
        this.addPrintScreenListener(this.m_AxisBottom);
        this.addPrintScreenListener(this.m_AxisLeft);
        this.addPrintScreenListener(this.m_AxisRight);
    }

    protected void addPrintScreenListener(JComponent comp) {
        new PrintMouseListener(comp, this);
    }

    public void setForegroundColor(Color value) {
        this.m_ForegroundColor = value;
        this.repaint();
    }

    public Color getForegroundColor() {
        return this.m_ForegroundColor;
    }

    public void setBackgroundColor(Color value) {
        this.m_BackgroundColor = value;
        this.repaint();
    }

    public Color getBackgroundColor() {
        return this.m_BackgroundColor;
    }

    public void setAxisWidths(int value) {
        this.m_AxisWidth = value;
        this.m_AxisLeft.setAxisWidth(this.m_AxisWidth);
        this.m_AxisRight.setAxisWidth(this.m_AxisWidth);
        this.m_AxisTop.setAxisWidth(this.m_AxisWidth);
        this.m_AxisBottom.setAxisWidth(this.m_AxisWidth);
        this.m_CornerTopLeft.setSize(new Dimension(this.m_AxisWidth, this.m_AxisWidth));
        this.m_CornerTopRight.setSize(new Dimension(this.m_AxisWidth, this.m_AxisWidth));
        this.m_CornerBottomLeft.setSize(new Dimension(this.m_AxisWidth, this.m_AxisWidth));
        this.m_CornerBottomRight.setSize(new Dimension(this.m_AxisWidth, this.m_AxisWidth));
    }

    public void setAxisWidth(Axis axis, int width) {
        this.getAxis(axis).setAxisWidth(width);
        this.updateCorner(axis);
    }

    protected void updateCorner(Axis axis) {
        switch (axis) {
            case LEFT: {
                this.updateCornerPanel(this.m_CornerTopLeft, this.getActualAxisWidth(axis), this.m_CornerTopLeft.getPreferredSize().height);
                this.updateCornerPanel(this.m_CornerBottomLeft, this.getActualAxisWidth(axis), this.m_CornerBottomLeft.getPreferredSize().height);
                break;
            }
            case RIGHT: {
                this.updateCornerPanel(this.m_CornerTopRight, this.getActualAxisWidth(axis), this.m_CornerTopRight.getPreferredSize().height);
                this.updateCornerPanel(this.m_CornerBottomRight, this.getActualAxisWidth(axis), this.m_CornerBottomRight.getPreferredSize().height);
                break;
            }
            case TOP: {
                this.updateCornerPanel(this.m_CornerTopLeft, this.m_CornerTopLeft.getPreferredSize().width, this.getActualAxisWidth(axis));
                this.updateCornerPanel(this.m_CornerTopRight, this.m_CornerTopRight.getPreferredSize().width, this.getActualAxisWidth(axis));
                break;
            }
            case BOTTOM: {
                this.updateCornerPanel(this.m_CornerBottomLeft, this.m_CornerBottomLeft.getPreferredSize().width, this.getActualAxisWidth(axis));
                this.updateCornerPanel(this.m_CornerBottomRight, this.m_CornerBottomRight.getPreferredSize().width, this.getActualAxisWidth(axis));
            }
        }
    }

    public void updateCorners() {
        for (Axis axis : Axis.values()) {
            this.updateCorner(axis);
        }
    }

    public int getAxisWidth(Axis axis) {
        return this.getAxis(axis).getAxisWidth();
    }

    public int getActualAxisWidth(Axis axis) {
        return this.getAxis(axis).getActualAxisWidth();
    }

    public AxisPanel getAxis(Axis axis) {
        if (axis == Axis.LEFT) {
            return this.m_AxisLeft;
        }
        if (axis == Axis.RIGHT) {
            return this.m_AxisRight;
        }
        if (axis == Axis.TOP) {
            return this.m_AxisTop;
        }
        if (axis == Axis.BOTTOM) {
            return this.m_AxisBottom;
        }
        throw new IllegalStateException("Unhandled axis '" + (Object)((Object)axis) + "'!");
    }

    public void setAxisVisibility(Axis axis, Visibility visible) {
        this.getAxis(axis).setVisibility(visible);
        this.updateCorner(axis);
    }

    public Visibility getAxisVisibility(Axis axis) {
        return this.getAxis(axis).getVisibility();
    }

    public void setZoomingEnabled(boolean value) {
        this.m_PanelContent.setZoomingEnabled(value);
    }

    public boolean isZoomingEnabled() {
        return this.m_PanelContent.isZoomingEnabled();
    }

    public boolean isZoomed() {
        if (!this.isZoomingEnabled()) {
            return false;
        }
        return this.m_AxisLeft.isZoomed() || this.m_AxisRight.isZoomed() || this.m_AxisTop.isZoomed() || this.m_AxisBottom.isZoomed();
    }

    public void clearZoom() {
        this.m_PanelContent.clearZoom();
    }

    public void setPanningEnabled(boolean value) {
        this.m_PanelContent.setPanningEnabled(value);
    }

    public boolean isPanningEnabled() {
        return this.m_PanelContent.isPanningEnabled();
    }

    public boolean isPanned() {
        if (!this.isPanningEnabled()) {
            return false;
        }
        return this.m_AxisLeft.getPixelOffset() != 0 || this.m_AxisRight.getPixelOffset() != 0 || this.m_AxisTop.getPixelOffset() != 0 || this.m_AxisBottom.getPixelOffset() != 0;
    }

    public void clearPanning() {
        this.m_PanelContent.clearPanning();
    }

    public ContentPanel getContent() {
        return this.m_PanelContent;
    }

    public void addPaintListener(PaintListener l) {
        this.m_PaintListeners.add(l);
    }

    public void removePaintListener(PaintListener l) {
        this.m_PaintListeners.remove(l);
    }

    public void notifyPaintListeners(Graphics g, PaintEvent.PaintMoment moment) {
        PaintEvent e = new PaintEvent(this, g, moment);
        Iterator<PaintListener> iter = this.m_PaintListeners.iterator();
        while (iter.hasNext()) {
            iter.next().painted(e);
        }
    }

    public void addZoomListener(PlotPanelZoomListener l) {
        this.m_PanelContent.addZoomListener(l);
    }

    public void removeZoomListener(PlotPanelZoomListener l) {
        this.m_PanelContent.removeZoomListener(l);
    }

    public void addPanningListener(PlotPanelPanningListener l) {
        this.m_PanelContent.addPanningListener(l);
    }

    public void removePanningListener(PlotPanelPanningListener l) {
        this.m_PanelContent.removePanningListener(l);
    }

    public void addMouseMovementTracker(MouseMovementTracker l) {
        this.m_PanelContent.addMouseMovementTracker(l);
    }

    public void removeMouseMovementTracker(MouseMovementTracker l) {
        this.m_PanelContent.removeMouseMovementTracker(l);
    }

    public void clearToolTipAxes() {
        this.m_ToolTipAxes.clear();
    }

    public void addToolTipAxis(Axis axis) {
        this.removeToolTipAxis(axis);
        this.m_ToolTipAxes.add(axis);
    }

    public void removeToolTipAxis(Axis axis) {
        if (this.m_ToolTipAxes.contains((Object)axis)) {
            this.m_ToolTipAxes.remove((Object)axis);
        }
    }

    public boolean hasToolTipAxis(Axis axis) {
        return this.m_ToolTipAxes.contains((Object)axis);
    }

    public void setGridColor(Color value) {
        this.m_GridColor = value;
    }

    public Color getGridColor() {
        return this.m_GridColor;
    }

    public void setPopupMenuCustomizer(PopupMenuCustomizer value) {
        this.m_PanelContent.setPopupMenuCustomizer(value);
    }

    public PopupMenuCustomizer getPopupMenuCustomizer() {
        return this.m_PanelContent.getPopupMenuCustomizer();
    }

    public void setAxisPopupMenuCustomizer(Axis axis, PopupMenuCustomizer value) {
        this.getAxis(axis).setPopupMenuCustomizer(value);
    }

    public PopupMenuCustomizer getAxisPopupMenuCustomizer(Axis axis) {
        return this.getAxis(axis).getPopupMenuCustomizer();
    }

    public void setTipTextCustomizer(TipTextCustomizer value) {
        this.m_PanelContent.setTipTextCustomizer(value);
    }

    public TipTextCustomizer getTipTextCustomizer() {
        return this.m_PanelContent.getTipTextCustomizer();
    }

    public void clearHitDetectors() {
        this.m_PanelContent.clearHitDetectors();
    }

    public void addHitDetector(AbstractHitDetector detector) {
        this.m_PanelContent.addHitDetector(detector);
    }

    public void removeHitDetector(AbstractHitDetector detector) {
        this.m_PanelContent.removeHitDetector(detector);
    }

    public void addZoom(double top, double left, double bottom, double right) {
        this.m_PanelContent.addZoom(top, left, bottom, right);
    }

    public void addZoom(int top, int left, int bottom, int right) {
        this.m_PanelContent.addZoom(top, left, bottom, right);
    }

    @Override
    public String toString() {
        return "left: " + this.m_AxisLeft + ", top: " + this.m_AxisTop + ", right: " + this.m_AxisRight + ", bottom: " + this.m_AxisBottom;
    }
}

