/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.platform.cwt.image.swt;

import de.intarsys.cwt.image.ImageException;
import de.intarsys.cwt.image.ImageTools;
import de.intarsys.cwt.swt.image.ImageConverterAwt2Swt;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.filter.Filter;
import de.intarsys.pdf.pd.PDImage;
import de.intarsys.pdf.platform.cwt.color.swt.SwtColorSpace;
import de.intarsys.pdf.platform.cwt.color.swt.SwtColorSpaceFactory;
import de.intarsys.pdf.platform.cwt.image.awt.ImageConverterPdf2Awt;
import de.intarsys.pdf.platform.cwt.image.awt.PlatformImageTools;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.PaletteData;

public class ImageConverterPdf2Swt {
    private final PDImage pdImage;
    private ImageData imageData;

    public ImageConverterPdf2Swt(PDImage pPdImage) {
        this.pdImage = pPdImage;
    }

    protected ImageData createImageData() {
        if (!this.pdImage.hasTransparency()) {
            try {
                ImageData result = this.createPrimaryImageData();
                return result;
            }
            catch (ImageException result) {
            }
            catch (Exception result) {
                // empty catch block
            }
        }
        ImageConverterPdf2Awt converter1 = new ImageConverterPdf2Awt(this.getPDImage());
        BufferedImage bufferedImage = converter1.getBufferedImage();
        ImageConverterAwt2Swt converter2 = new ImageConverterAwt2Swt(bufferedImage);
        return converter2.getImageData();
    }

    protected ImageData createImageDataFromJPEG(COSStream cosStream) throws IOException {
        ImageData[] images;
        String colorSpaceType;
        ByteArrayInputStream stream = new ByteArrayInputStream(cosStream.getEncodedBytes());
        try {
            colorSpaceType = ImageTools.extractJPEGColorSpaceType((InputStream)stream);
        }
        catch (ImageException ex) {
            colorSpaceType = "YCbCr";
        }
        if (!("GRAY".equals(colorSpaceType) || "RGB".equals(colorSpaceType) || "YCbCr".equals(colorSpaceType))) {
            throw new ImageException("SWT non-RGB/GRAY JPEG not supported");
        }
        if (!PlatformImageTools.matchColorSpace(this.pdImage, colorSpaceType)) {
            throw new ImageException("PD color space does not match JPEG metadata");
        }
        ((InputStream)stream).reset();
        try {
            images = new ImageLoader().load((InputStream)stream);
        }
        catch (SWTException ex) {
            throw new ImageException("SWT JPEG decoding error");
        }
        if (images[0].data.length == 0) {
            throw new ImageException("SWT JPEG decoding error");
        }
        return images[0];
    }

    protected ImageData createPrimaryImageData() {
        if (this.pdImage.cosGetStream().hasFilter(Filter.CN_Filter_JPXDecode)) {
            throw new ImageException("SWT JPX stream not supported");
        }
        if (this.pdImage.cosGetStream().hasFilter(Filter.CN_Filter_DCTDecode) || this.pdImage.cosGetStream().hasFilter(Filter.CN_Filter_DCT)) {
            try {
                return this.createImageDataFromJPEG(this.pdImage.cosExtractJPEGStream());
            }
            catch (IOException ex) {
                throw new ImageException("SWT JPEG decoding error");
            }
        }
        try {
            SwtColorSpace pfColorSpace = SwtColorSpaceFactory.get().createPlatformColorSpace(this.pdImage.getColorSpace());
            PaletteData palette = pfColorSpace.getPalette(this.pdImage);
            int numComponents = pfColorSpace.getNumComponents();
            ImageData imageData = new ImageData(this.pdImage.getWidth(), this.pdImage.getHeight(), this.pdImage.getBitsPerComponent() * numComponents, palette, (this.pdImage.getBitsPerComponent() * numComponents + 7) / 8, this.pdImage.getAdjustedBytes(numComponents));
            return imageData;
        }
        catch (UnsupportedOperationException ex) {
            throw new ImageException("SWT color space not supported", (Throwable)ex);
        }
    }

    public ImageData getImageData() throws ImageException {
        if (this.imageData == null) {
            this.imageData = this.createImageData();
        }
        return this.imageData;
    }

    public PDImage getPDImage() {
        return this.pdImage;
    }
}

