/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.stats.paintlet;

import JSci.maths.statistics.NormalDistribution;
import adams.data.statistics.StatUtils;
import adams.gui.visualization.core.axis.Type;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.stats.paintlet.AbstractProbabilityPaintlet;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.Arrays;

public class Lognormal
extends AbstractProbabilityPaintlet {
    private static final long serialVersionUID = -6946745344353347610L;

    @Override
    public void setAxis() {
        this.m_AxisBottom = this.getPanel().getPlot().getAxis(Axis.BOTTOM);
        this.m_AxisLeft = this.getPanel().getPlot().getAxis(Axis.LEFT);
        this.m_AxisBottom.setType(Type.LOG_ABSOLUTE);
        this.m_AxisLeft.setType(Type.ABSOLUTE);
        this.m_AxisLeft.setNumberFormat("#.##");
    }

    public void performPaint(Graphics g) {
        if (this.m_Instances != null) {
            int i;
            if (this.m_AntiAliasingEnabled) {
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            } else {
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
            int mean = 100;
            int var = 100;
            NormalDistribution normal = new NormalDistribution((double)mean, (double)var);
            double[] data = this.m_Instances.attributeToDoubleArray(this.m_Index);
            this.m_TransformedY = new double[data.length];
            Arrays.sort(data);
            for (i = 0; i < data.length; ++i) {
                double median = ((double)(i + 1) - 0.3) / ((double)data.length + 0.4);
                this.m_TransformedY[i] = (normal.inverse(median) - (double)mean) / Math.sqrt(var);
            }
            if (this.m_AxisBottom.getType().canHandle(data[0], data[data.length - 1])) {
                this.m_AxisBottom.setMinimum(data[0]);
                this.m_AxisBottom.setMaximum(data[data.length - 1]);
            } else {
                System.err.println("errors in plotting");
            }
            if (this.m_AxisLeft.getType().canHandle(this.m_TransformedY[0], this.m_TransformedY[this.m_TransformedY.length - 1])) {
                this.m_AxisLeft.setMinimum(this.m_TransformedY[0]);
                this.m_AxisLeft.setMaximum(this.m_TransformedY[this.m_TransformedY.length - 1]);
            } else {
                System.err.println("errors in plotting");
            }
            this.m_AxisLeft.setAxisName("Inverse Normal");
            this.m_AxisBottom.setAxisName(this.m_Instances.attribute(this.m_Index).name());
            for (i = 0; i < data.length; ++i) {
                Graphics2D g2d = (Graphics2D)g;
                if (this.m_Fill) {
                    g2d.setColor(this.m_FillColor);
                    g2d.setStroke(new BasicStroke(0.0f));
                    g2d.fillOval(this.m_AxisBottom.valueToPos(data[i]) - this.m_Size / 2, this.m_AxisLeft.valueToPos(this.m_TransformedY[i]) - this.m_Size / 2, this.m_Size, this.m_Size);
                }
                g2d.setStroke(new BasicStroke(this.m_StrokeThickness));
                g2d.setColor(this.m_Color);
                g2d.drawOval(this.m_AxisBottom.valueToPos(data[i]) - this.m_Size / 2, this.m_AxisLeft.valueToPos(this.m_TransformedY[i]) - this.m_Size / 2, this.m_Size, this.m_Size);
            }
            if (this.m_RegressionLine) {
                g.setColor(Color.BLACK);
                double[] newData = new double[data.length];
                for (int i2 = 0; i2 < data.length; ++i2) {
                    newData[i2] = Math.log(data[i2]);
                }
                double mn = StatUtils.mean((double[])newData);
                double std = StatUtils.stddev((double[])newData, (boolean)false);
                for (int i3 = 0; i3 < data.length - 1; ++i3) {
                    double p1 = (newData[i3] - mn) / std;
                    double p2 = (newData[i3 + 1] - mn) / std;
                    g.drawLine(this.m_AxisBottom.valueToPos(data[i3]), this.m_AxisLeft.valueToPos(p1), this.m_AxisBottom.valueToPos(data[i3 + 1]), this.m_AxisLeft.valueToPos(p2));
                }
            }
        }
    }

    public String globalInfo() {
        return "paints the transformed lognormal distribution";
    }

    @Override
    public boolean hasFitLine() {
        return true;
    }
}

