/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.enumeration;

import de.intarsys.tools.enumeration.EnumMeta;
import de.intarsys.tools.message.Message;
import java.util.HashMap;
import java.util.Map;

public abstract class EnumItem
implements Comparable {
    private static final Map META = new HashMap();
    private static int WEIGHT = 0;
    private String iconName;
    private final String id;
    private String label;
    private Message message;
    private final int weight;

    protected static EnumMeta getMeta(Class clazz) {
        EnumMeta result = (EnumMeta)META.get(clazz);
        if (result == null) {
            result = new EnumMeta(clazz);
            META.put(clazz, result);
        }
        return result;
    }

    protected EnumItem(String id) {
        this.id = id;
        this.message = new Message(this, id);
        this.weight = WEIGHT++;
        this.getMeta().addItem(this);
    }

    protected EnumItem(String id, int weight) {
        this.id = id;
        this.message = new Message(this, id);
        this.weight = weight;
        this.getMeta().addItem(this);
    }

    protected EnumItem(String id, Message message) {
        this(id, message, WEIGHT++);
    }

    protected EnumItem(String id, Message message, int weight) {
        this.id = id;
        this.message = message;
        this.weight = weight;
        this.getMeta().addItem(this);
    }

    protected EnumItem(String id, String label) {
        this(id, label, WEIGHT++);
    }

    protected EnumItem(String id, String label, int weight) {
        this.id = id;
        this.label = label;
        this.weight = weight;
        this.getMeta().addItem(this);
    }

    public int compareTo(Object o) {
        EnumItem other = (EnumItem)o;
        return (int)Math.signum(this.getWeight() - other.getWeight());
    }

    public String getDescription() {
        return this.getTip();
    }

    public String getIconName() {
        return this.iconName;
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        if (this.label == null) {
            this.label = this.message.get();
        }
        return this.label;
    }

    public String getLocalizedLabel() {
        return this.getLabel();
    }

    public Message getMessage() {
        return this.message;
    }

    protected EnumMeta getMeta() {
        return EnumItem.getMeta(this.getClass());
    }

    public String getTip() {
        return this.getLabel();
    }

    protected int getWeight() {
        return this.weight;
    }

    protected void setDefault() {
        this.getMeta().setDefault(this);
    }

    protected void setIconName(String iconName) {
        this.iconName = iconName;
    }

    public String toString() {
        return this.getLabel();
    }
}

