/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.crypt;

import de.intarsys.pdf.crypt.AccessPermissionsFull;
import de.intarsys.pdf.crypt.AccessPermissionsR2;
import de.intarsys.pdf.crypt.COSSecurityException;
import de.intarsys.pdf.crypt.IAccessPermissions;
import de.intarsys.pdf.crypt.StandardSecurityHandler;
import java.security.MessageDigest;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public class StandardSecurityHandlerR2
extends StandardSecurityHandler {
    public static final String DIGEST_ALGORITHM = "MD5";
    public static final String KEY_ALGORITHM = "RC4";
    public static final String CIPHER_ALGORITHM = "RC4";

    public boolean authenticateOwner(byte[] owner) throws COSSecurityException {
        try {
            byte[] preparedOwner = this.prepareBytes(owner);
            MessageDigest md = MessageDigest.getInstance(DIGEST_ALGORITHM);
            md.update(preparedOwner);
            byte[] key = md.digest();
            int length = 5;
            byte[] encryptionKey = new byte[length];
            System.arraycopy(key, 0, encryptionKey, 0, length);
            Cipher cipher = Cipher.getInstance("RC4");
            if (cipher == null) {
                throw new COSSecurityException("RC4 cipher not found");
            }
            byte[] encrypted = this.getO();
            SecretKeySpec skeySpec = new SecretKeySpec(encryptionKey, "RC4");
            cipher.init(2, skeySpec);
            encrypted = cipher.doFinal(encrypted);
            if (this.authenticateUser(encrypted)) {
                this.setActiveAccessPermissions(AccessPermissionsFull.get());
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw new COSSecurityException(e);
        }
    }

    public boolean authenticateUser(byte[] user) throws COSSecurityException {
        byte[] tempU;
        byte[] entryU = this.getU();
        if (entryU.length != (tempU = this.createUserPassword(user)).length) {
            return false;
        }
        int i = 0;
        while (i < tempU.length) {
            if (entryU[i] != tempU[i]) {
                return false;
            }
            ++i;
        }
        this.setCryptKey(this.createCryptKey(user));
        this.setActiveAccessPermissions(this.createAccessPermissions());
        return true;
    }

    protected IAccessPermissions createAccessPermissions() {
        return new AccessPermissionsR2(this.getPermissionFlags());
    }

    protected byte[] createCryptKey(byte[] password) throws COSSecurityException {
        try {
            MessageDigest md = MessageDigest.getInstance(DIGEST_ALGORITHM);
            byte[] prepared = this.prepareBytes(password);
            md.update(prepared);
            md.update(this.getO());
            md.update(this.getPBytes());
            byte[] fd = this.getPermanentFileID();
            if (fd != null) {
                md.update(fd);
            }
            byte[] key = md.digest();
            int length = 5;
            byte[] result = new byte[length];
            System.arraycopy(key, 0, result, 0, length);
            return result;
        }
        catch (Exception e) {
            throw new COSSecurityException(e);
        }
    }

    protected byte[] createOwnerPassword(byte[] owner, byte[] user) throws COSSecurityException {
        try {
            byte[] preparedOwner = owner == null ? this.prepareBytes(user) : this.prepareBytes(owner);
            MessageDigest md = MessageDigest.getInstance(DIGEST_ALGORITHM);
            md.update(preparedOwner);
            byte[] key = md.digest();
            int length = 5;
            byte[] encryptionKey = new byte[length];
            System.arraycopy(key, 0, encryptionKey, 0, length);
            SecretKeySpec skeySpec = new SecretKeySpec(encryptionKey, "RC4");
            byte[] preparedUser = this.prepareBytes(user);
            Cipher cipher = Cipher.getInstance("RC4");
            cipher.init(2, skeySpec);
            byte[] encrypted = cipher.doFinal(preparedUser);
            return encrypted;
        }
        catch (Exception e) {
            throw new COSSecurityException(e);
        }
    }

    protected byte[] createUserPassword(byte[] user) throws COSSecurityException {
        try {
            byte[] encryptionKey = this.createCryptKey(user);
            SecretKeySpec skeySpec = new SecretKeySpec(encryptionKey, "RC4");
            Cipher cipher = Cipher.getInstance("RC4");
            cipher.init(1, skeySpec);
            byte[] encrypted = cipher.doFinal(PADDING);
            return encrypted;
        }
        catch (Exception e) {
            throw new COSSecurityException(e);
        }
    }

    public int getRevision() {
        return 2;
    }
}

