/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.gui.GenericDialog;
import ij.gui.Roi;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import ij.process.StackStatistics;

public class Filters
implements PlugInFilter {
    private static double sd = Prefs.getDouble("noise.sd", 25.0);
    private String arg;
    private ImagePlus imp;
    private int slice;
    private boolean canceled;

    public int setup(String arg, ImagePlus imp) {
        int flags;
        Roi roi;
        this.arg = arg;
        this.imp = imp;
        if (imp != null && (roi = imp.getRoi()) != null && !roi.isArea()) {
            imp.killRoi();
        }
        if (((flags = IJ.setupDialog(imp, 93)) & 0x20) != 0 && imp.getType() == 1 && imp.getStackSize() > 1 && arg.equals("invert")) {
            this.invert16BitStack(imp);
            return 4096;
        }
        return flags;
    }

    public void run(ImageProcessor ip) {
        if (this.arg.equals("invert")) {
            ip.invert();
            return;
        }
        if (this.arg.equals("smooth")) {
            ip.setSnapshotCopyMode(true);
            ip.smooth();
            ip.setSnapshotCopyMode(false);
            return;
        }
        if (this.arg.equals("sharpen")) {
            ip.setSnapshotCopyMode(true);
            ip.sharpen();
            ip.setSnapshotCopyMode(false);
            return;
        }
        if (this.arg.equals("edge")) {
            ip.setSnapshotCopyMode(true);
            ip.findEdges();
            ip.setSnapshotCopyMode(false);
            return;
        }
        if (this.arg.equals("add")) {
            ip.noise(25.0);
            return;
        }
        if (this.arg.equals("noise")) {
            if (this.canceled) {
                return;
            }
            ++this.slice;
            if (this.slice == 1) {
                GenericDialog gd = new GenericDialog("Gaussian Noise");
                gd.addNumericField("Standard Deviation:", sd, 2);
                gd.showDialog();
                if (gd.wasCanceled()) {
                    this.canceled = true;
                    return;
                }
                sd = gd.getNextNumber();
            }
            ip.noise(sd);
            IJ.register(Filters.class);
            return;
        }
    }

    void invert16BitStack(ImagePlus imp) {
        imp.killRoi();
        imp.getCalibration().disableDensityCalibration();
        StackStatistics stats = new StackStatistics(imp);
        ImageStack stack = imp.getStack();
        int nslices = stack.getSize();
        int min = (int)stats.min;
        int range = (int)(stats.max - stats.min);
        int n = imp.getWidth() * imp.getHeight();
        for (int slice = 1; slice <= nslices; ++slice) {
            ImageProcessor ip = stack.getProcessor(slice);
            short[] pixels = (short[])ip.getPixels();
            for (int i = 0; i < n; ++i) {
                int before = pixels[i] & 0xFFFF;
                pixels[i] = (short)(range - ((pixels[i] & 0xFFFF) - min));
            }
        }
        imp.setStack(null, stack);
        imp.setDisplayRange(0.0, range);
        imp.updateAndDraw();
    }

    public static double getSD() {
        return sd;
    }
}

