/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.bigintegermatrix.impl;

import java.math.BigInteger;
import java.util.Arrays;
import org.ujmp.core.Matrix;
import org.ujmp.core.bigintegermatrix.stub.AbstractDenseBigIntegerMatrix2D;
import org.ujmp.core.exceptions.MatrixException;

public class ArrayDenseBigIntegerMatrix2D
extends AbstractDenseBigIntegerMatrix2D {
    private static final long serialVersionUID = 3110279640095711135L;
    private BigInteger[][] values = null;

    public ArrayDenseBigIntegerMatrix2D(Matrix m) throws MatrixException {
        if (m instanceof ArrayDenseBigIntegerMatrix2D) {
            BigInteger[][] v = ((ArrayDenseBigIntegerMatrix2D)m).values;
            this.values = new BigInteger[v.length][v[0].length];
            int r = v.length;
            while (--r >= 0) {
                int c = v[0].length;
                while (--c >= 0) {
                    this.values[r][c] = v[r][c];
                }
            }
        } else {
            this.values = new BigInteger[(int)m.getRowCount()][(int)m.getColumnCount()];
            for (long[] c : m.allCoordinates()) {
                this.setAsBigInteger(m.getAsBigInteger(c), c);
            }
        }
    }

    public ArrayDenseBigIntegerMatrix2D(BigInteger[] ... v) {
        this.values = v;
    }

    public ArrayDenseBigIntegerMatrix2D(long ... size) {
        this.values = new BigInteger[(int)size[0]][(int)size[1]];
        int r = this.values.length;
        while (--r != -1) {
            Arrays.fill(this.values[r], BigInteger.ZERO);
        }
    }

    public ArrayDenseBigIntegerMatrix2D(BigInteger ... v) {
        this.values = new BigInteger[v.length][1];
        int r = v.length;
        while (--r >= 0) {
            this.values[r][0] = v[r];
        }
    }

    public long[] getSize() {
        return new long[]{this.values.length, this.values.length == 0 ? 0 : this.values[0].length};
    }

    public long getRowCount() {
        return this.values.length;
    }

    public long getColumnCount() {
        return this.values.length == 0 ? 0 : this.values[0].length;
    }

    public BigInteger getBigInteger(long row, long column) {
        return this.values[(int)row][(int)column];
    }

    public void setBigInteger(BigInteger value, long row, long column) {
        this.values[(int)row][(int)column] = value;
    }

    public BigInteger getBigInteger(int row, int column) {
        return this.values[row][column];
    }

    public void setBigInteger(BigInteger value, int row, int column) {
        this.values[row][column] = value;
    }
}

