/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.io;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.ujmp.core.Matrix;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.util.UJMPFormat;
import org.ujmp.core.util.io.IntelligentFileWriter;

public class ExportMatrixTEX {
    public static final void toFile(File file, Matrix m, Object ... parameters) throws IOException {
        IntelligentFileWriter w = new IntelligentFileWriter(file);
        ExportMatrixTEX.toWriter(w, m, parameters);
        w.close();
    }

    public static final void toStream(OutputStream out, Matrix m, Object ... parameters) throws IOException {
        OutputStreamWriter w = new OutputStreamWriter(out);
        ExportMatrixTEX.toWriter(w, m, parameters);
        w.close();
    }

    public static void toWriter(Writer w, Matrix m, Object ... parameters) throws IOException, MatrixException {
        String EOL = System.getProperty("line.separator");
        long rowCount = m.getRowCount();
        long colCount = m.getColumnCount();
        w.write("\\begin{table}[!ht]" + EOL);
        w.write("\\centering" + EOL);
        if (m.getMatrixAnnotation() != null) {
            w.write("\\caption{" + UJMPFormat.getSingleLineInstance().format(m.getMatrixAnnotation()) + "}" + EOL);
        }
        StringBuilder buf = new StringBuilder();
        long i = m.getColumnCount() - 1L;
        while (i != -1L) {
            buf.append('c');
            --i;
        }
        String alignment = buf.toString();
        w.write("\\begin{tabular}{" + alignment + "}" + EOL);
        w.write("\\toprule" + EOL);
        int row = 0;
        while ((long)row < rowCount) {
            int col = 0;
            while ((long)col < colCount) {
                w.write(UJMPFormat.getSingleLineInstance().format(m.getAsObject(row, col)));
                if ((long)col < colCount - 1L) {
                    w.write(" & ");
                }
                ++col;
            }
            w.write(" \\\\" + EOL);
            ++row;
        }
        w.write("\\bottomrule" + EOL);
        w.write("\\end{tabular}" + EOL);
        w.write("\\end{table}" + EOL);
    }
}

