/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.gui.menu;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import org.ujmp.core.enums.FileFormat;
import org.ujmp.core.util.JMathLib;
import org.ujmp.core.util.matrices.MatrixAvailableProcessors;
import org.ujmp.core.util.matrices.MatrixMemoryUsage;
import org.ujmp.core.util.matrices.MatrixRandomSeed;
import org.ujmp.core.util.matrices.MatrixRunningThreads;
import org.ujmp.core.util.matrices.MatrixSystemEnvironment;
import org.ujmp.core.util.matrices.MatrixSystemProperties;
import org.ujmp.core.util.matrices.MatrixSystemTime;
import org.ujmp.core.util.matrices.UJMPPluginsMatrix;
import org.ujmp.gui.actions.ShowInFrameAction;
import org.ujmp.gui.util.MatrixUIDefaults;

public class UJMPToolsMenu
extends JMenu {
    private static final long serialVersionUID = 853886481708901509L;

    public UJMPToolsMenu(JComponent component) {
        super("Tools");
        this.setMnemonic(84);
        this.add(new JMenuItem(new ShowInFrameAction(component, "UJMP Plugins", UJMPPluginsMatrix.class)));
        this.add(new JSeparator());
        this.add(new JMenuItem(new ShowInFrameAction(component, "Supported File Formats", FileFormat.class)));
        this.add(new JMenuItem(new ShowInFrameAction(component, "System Properties", MatrixSystemProperties.class)));
        this.add(new JMenuItem(new ShowInFrameAction(component, "System Environment", MatrixSystemEnvironment.class)));
        this.add(new JMenuItem(new ShowInFrameAction(component, "UI Defaults", MatrixUIDefaults.class)));
        this.add(new JSeparator());
        this.add(new JMenuItem(new ShowInFrameAction(component, "Memory Usage", MatrixMemoryUsage.class)));
        this.add(new JMenuItem(new ShowInFrameAction(component, "Running Threads", MatrixRunningThreads.class)));
        this.add(new JMenuItem(new ShowInFrameAction(component, "System Time", MatrixSystemTime.class)));
        this.add(new JMenuItem(new ShowInFrameAction(component, "Random Seed", MatrixRandomSeed.class)));
        this.add(new JMenuItem(new ShowInFrameAction(component, "Available Processors", MatrixAvailableProcessors.class)));
        if (JMathLib.isAvailable()) {
            this.add(new JSeparator());
            this.add(new JMathLibAction());
        }
    }

    class JMathLibAction
    extends AbstractAction {
        private static final long serialVersionUID = 1895232937545702538L;

        public JMathLibAction() {
            this.putValue("Name", "JMathLib");
            this.putValue("ShortDescription", "Show JMathlib in a new Window");
        }

        public void actionPerformed(ActionEvent e) {
            JMathLib.showGUI();
        }
    }
}

