/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.jfreechart;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import javax.swing.JFrame;
import org.jfree.chart.ChartPanel;
import org.ujmp.core.enums.FileFormat;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.gui.MatrixGUIObject;
import org.ujmp.gui.interfaces.CanRenderGraph;
import org.ujmp.gui.io.ExportJPEG;
import org.ujmp.gui.io.ExportPDF;
import org.ujmp.jfreechart.ChartConfiguration;

public abstract class AbstractChartPanel
extends ChartPanel
implements CanRenderGraph {
    private static final long serialVersionUID = -7609107739440534835L;
    private ChartConfiguration config = null;
    private MatrixGUIObject matrix = null;

    public AbstractChartPanel(MatrixGUIObject matrix, ChartConfiguration config) {
        super(null, true);
        this.matrix = matrix;
        this.config = config;
        this.setPreferredSize(new Dimension(800, 600));
        this.setMaximumDrawWidth(2000);
        this.setMaximumDrawHeight(2000);
        this.redraw();
    }

    public synchronized void renderGraph(Graphics2D g2d) {
        Rectangle2D.Double r = new Rectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight());
        try {
            this.redraw();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.getChart().draw(g2d, (Rectangle2D)r);
    }

    public synchronized void export(FileFormat fileFormat, File file) {
        JFrame frame = null;
        if (this.isVisible()) {
            frame = new JFrame();
            frame.setDefaultCloseOperation(2);
            frame.setContentPane((Container)((Object)this));
            frame.setSize(800, 600);
            frame.setVisible(true);
            try {
                this.redraw();
                this.repaint();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (FileFormat.JPG.equals((Object)fileFormat)) {
            try {
                ExportJPEG.save(file, (Component)((Object)this));
            }
            catch (Exception exception) {}
        } else if (FileFormat.PDF.equals((Object)fileFormat)) {
            try {
                ExportPDF.save(file, (Component)((Object)this));
            }
            catch (Exception exception) {}
        } else {
            throw new MatrixException("FileFormat not yet supported: " + (Object)((Object)fileFormat));
        }
        if (frame != null) {
            frame.setVisible(false);
            frame = null;
        }
    }

    public abstract void redraw();

    public synchronized ChartConfiguration getConfig() {
        return this.config;
    }

    public synchronized void setConfig(ChartConfiguration config) {
        this.config = config;
        this.redraw();
    }

    public MatrixGUIObject getMatrix() {
        return this.matrix;
    }

    public synchronized void setMatrix(MatrixGUIObject matrix) {
        this.matrix = matrix;
        this.redraw();
    }
}

