/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.core.splitcriteria;

import moa.classifiers.core.splitcriteria.SplitCriterion;
import moa.core.ObjectRepository;
import moa.options.AbstractOptionHandler;
import moa.tasks.TaskMonitor;
import weka.core.Utils;

public class GiniSplitCriterion
extends AbstractOptionHandler
implements SplitCriterion {
    private static final long serialVersionUID = 1L;

    public double getMeritOfSplit(double[] preSplitDist, double[][] postSplitDists) {
        double totalWeight = 0.0;
        double[] distWeights = new double[postSplitDists.length];
        for (int i = 0; i < postSplitDists.length; ++i) {
            distWeights[i] = Utils.sum((double[])postSplitDists[i]);
            totalWeight += distWeights[i];
        }
        double gini = 0.0;
        for (int i = 0; i < postSplitDists.length; ++i) {
            gini += distWeights[i] / totalWeight * GiniSplitCriterion.computeGini(postSplitDists[i], distWeights[i]);
        }
        return 1.0 - gini;
    }

    public double getRangeOfMerit(double[] preSplitDist) {
        return 1.0;
    }

    public static double computeGini(double[] dist, double distSumOfWeights) {
        double gini = 1.0;
        for (int i = 0; i < dist.length; ++i) {
            double relFreq = dist[i] / distSumOfWeights;
            gini -= relFreq * relFreq;
        }
        return gini;
    }

    public static double computeGini(double[] dist) {
        return GiniSplitCriterion.computeGini(dist, Utils.sum((double[])dist));
    }

    public void getDescription(StringBuilder sb, int indent) {
    }

    protected void prepareForUseImpl(TaskMonitor monitor, ObjectRepository repository) {
    }
}

