/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.condition.test;

import adams.core.ClassLister;
import adams.core.ShallowCopySupporter;
import adams.core.option.AbstractOptionConsumer;
import adams.core.option.AbstractOptionHandler;
import adams.core.option.ArrayConsumer;
import adams.core.option.OptionUtils;

public abstract class AbstractCondition
extends AbstractOptionHandler
implements Comparable,
ShallowCopySupporter<AbstractCondition> {
    private static final long serialVersionUID = 3879444121041551968L;
    protected boolean m_Tested;
    protected String m_TestResult;

    @Override
    protected void initialize() {
        this.m_TestResult = null;
    }

    @Override
    public void reset() {
        this.m_Tested = false;
        this.m_TestResult = null;
    }

    protected abstract String performTest();

    public String getTestResult() {
        if (!this.m_Tested) {
            this.m_TestResult = this.performTest();
            this.m_Tested = true;
        }
        return this.m_TestResult;
    }

    public int compareTo(Object o) {
        if (o == null) {
            return 1;
        }
        return OptionUtils.getCommandLine(this).compareTo(OptionUtils.getCommandLine(o));
    }

    public boolean equals(Object o) {
        return this.compareTo(o) == 0;
    }

    @Override
    public AbstractCondition shallowCopy() {
        return this.shallowCopy(false);
    }

    @Override
    public AbstractCondition shallowCopy(boolean expand) {
        return (AbstractCondition)OptionUtils.shallowCopy(this, expand);
    }

    public static String[] getConditions() {
        return ClassLister.getSingleton().getClassnames(AbstractCondition.class);
    }

    public static AbstractCondition forName(String classname, String[] options) {
        AbstractCondition result;
        try {
            result = (AbstractCondition)OptionUtils.forName(AbstractCondition.class, classname, options);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    public static AbstractCondition forCommandLine(String cmdline) {
        return (AbstractCondition)AbstractOptionConsumer.fromString(ArrayConsumer.class, cmdline);
    }
}

