/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.VariableName;
import adams.flow.core.Unknown;
import adams.flow.transformer.AbstractTransformer;

public class SetVariable
extends AbstractTransformer {
    private static final long serialVersionUID = -3383735680425581504L;
    protected VariableName m_VariableName;
    protected String m_VariableValue;

    @Override
    public String globalInfo() {
        return "Sets the value of a global variable. Each time a token passes through, the variable value will get updated.\nThe transformer just forwards tokens that it receives after the variable has been set.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("var-name", "variableName", new VariableName());
        this.m_OptionManager.add("var-value", "variableValue", "");
    }

    public void setVariableName(VariableName value) {
        this.m_VariableName = value;
        this.reset();
    }

    public VariableName getVariableName() {
        return this.m_VariableName;
    }

    public String variableNameTipText() {
        return "The name of the variable to update.";
    }

    public void setVariableValue(String value) {
        this.m_VariableValue = value;
        this.reset();
    }

    public String getVariableValue() {
        return this.m_VariableValue;
    }

    public String variableValueTipText() {
        return "The fixed value to use instead of the current token; only used if non-empty.";
    }

    @Override
    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("variableName");
        String result = variable != null ? "@{" + variable + "}" : this.m_VariableName.paddedValue();
        variable = this.getOptionManager().getVariableForProperty("variableValue");
        if (variable != null) {
            result = result + " using " + variable;
        } else if (this.m_VariableValue.length() > 0) {
            result = result + " using " + this.m_VariableValue;
        }
        return result;
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Unknown.class};
    }

    @Override
    protected String doExecute() {
        String result = null;
        try {
            String value = null;
            if (this.m_VariableValue.length() > 0) {
                value = this.m_VariableValue;
            } else if (this.m_InputToken.getPayload() != null) {
                value = this.m_InputToken.getPayload().toString();
            }
            if (value != null) {
                this.getVariables().set(this.m_VariableName.getValue(), value);
                if (this.isDebugOn()) {
                    this.debug("Setting variable '" + this.m_VariableName + "': " + value);
                }
            }
        }
        catch (Exception e) {
            this.getSystemErr().printStackTrace(e);
            result = e.toString();
        }
        this.m_OutputToken = this.m_InputToken;
        return result;
    }

    @Override
    public Class[] generates() {
        return new Class[]{Unknown.class};
    }
}

