/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.meta;

import moa.classifiers.Classifier;
import moa.classifiers.meta.OzaBag;
import moa.classifiers.trees.ASHoeffdingTree;
import moa.core.DoubleVector;
import moa.core.MiscUtils;
import moa.options.FlagOption;
import moa.options.IntOption;
import weka.core.Instance;
import weka.core.Utils;

public class OzaBagASHT
extends OzaBag {
    private static final long serialVersionUID = 1L;
    public IntOption firstClassifierSizeOption = new IntOption("firstClassifierSize", 'f', "The size of first classifier in the bag.", 1, 1, Integer.MAX_VALUE);
    public FlagOption useWeightOption = new FlagOption("useWeight", 'u', "Enable weight classifiers.");
    public FlagOption resetTreesOption = new FlagOption("resetTrees", 'r', "Reset trees when size is higher than the max.");
    protected double[] error;
    protected double alpha = 0.01;

    public String getPurposeString() {
        return "Bagging using trees of different size.";
    }

    public void resetLearningImpl() {
        this.ensemble = new Classifier[this.ensembleSizeOption.getValue()];
        this.error = new double[this.ensembleSizeOption.getValue()];
        Classifier baseLearner = (Classifier)this.getPreparedClassOption(this.baseLearnerOption);
        baseLearner.resetLearning();
        int pow = this.firstClassifierSizeOption.getValue();
        for (int i = 0; i < this.ensemble.length; ++i) {
            this.ensemble[i] = baseLearner.copy();
            this.error[i] = 0.0;
            ((ASHoeffdingTree)this.ensemble[i]).setMaxSize(pow);
            if (this.resetTreesOption != null && this.resetTreesOption.isSet()) {
                ((ASHoeffdingTree)this.ensemble[i]).setResetTree();
            }
            pow *= 2;
        }
    }

    public void trainOnInstanceImpl(Instance inst) {
        int trueClass = (int)inst.classValue();
        for (int i = 0; i < this.ensemble.length; ++i) {
            int k = MiscUtils.poisson(1.0, this.classifierRandom);
            if (k <= 0) continue;
            Instance weightedInst = (Instance)inst.copy();
            weightedInst.setWeight(inst.weight() * (double)k);
            if (Utils.maxIndex((double[])this.ensemble[i].getVotesForInstance(inst)) == trueClass) {
                int n = i;
                this.error[n] = this.error[n] + this.alpha * (0.0 - this.error[i]);
            } else {
                int n = i;
                this.error[n] = this.error[n] + this.alpha * (1.0 - this.error[i]);
            }
            this.ensemble[i].trainOnInstance(weightedInst);
        }
    }

    public double[] getVotesForInstance(Instance inst) {
        DoubleVector combinedVote = new DoubleVector();
        for (int i = 0; i < this.ensemble.length; ++i) {
            DoubleVector vote = new DoubleVector(this.ensemble[i].getVotesForInstance(inst));
            if (!(vote.sumOfValues() > 0.0)) continue;
            vote.normalize();
            if (this.useWeightOption != null && this.useWeightOption.isSet()) {
                vote.scaleValues(1.0 / (this.error[i] * this.error[i]));
            }
            combinedVote.addValues(vote);
        }
        return combinedVote.getArrayRef();
    }

    public void getModelDescription(StringBuilder out, int indent) {
    }
}

