/*
 * Decompiled with CFR 0.152.
 */
package moa.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import moa.core.StringUtils;
import moa.gui.ClassOptionSelectionPanel;
import moa.gui.FileExtensionFilter;
import moa.gui.GUIUtils;
import moa.gui.PreviewPanel;
import moa.options.ClassOption;
import moa.options.OptionHandler;
import moa.tasks.EvaluatePrequential;
import moa.tasks.MainTask;
import moa.tasks.Task;
import moa.tasks.TaskThread;

public class TaskManagerPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final int MILLISECS_BETWEEN_REFRESH = 600;
    public static String exportFileExtension = "log";
    protected MainTask currentTask = new EvaluatePrequential();
    protected List<TaskThread> taskList = new ArrayList<TaskThread>();
    protected JButton configureTaskButton = new JButton("Configure");
    protected JTextField taskDescField = new JTextField();
    protected JButton runTaskButton = new JButton("Run");
    protected TaskTableModel taskTableModel;
    protected JTable taskTable;
    protected JButton pauseTaskButton = new JButton("Pause");
    protected JButton resumeTaskButton = new JButton("Resume");
    protected JButton cancelTaskButton = new JButton("Cancel");
    protected JButton deleteTaskButton = new JButton("Delete");
    protected PreviewPanel previewPanel;

    public TaskManagerPanel() {
        this.taskDescField.setText(this.currentTask.getCLICreationString(MainTask.class));
        this.taskDescField.setEditable(false);
        final JTextField comp = this.taskDescField;
        this.taskDescField.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 1 && (evt.getButton() == 3 || evt.getButton() == 1 && evt.isAltDown() && evt.isShiftDown())) {
                    JPopupMenu menu = new JPopupMenu();
                    JMenuItem item = new JMenuItem("Copy configuration to clipboard");
                    item.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            TaskManagerPanel.this.copyClipBoardConfiguration();
                        }
                    });
                    menu.add(item);
                    item = new JMenuItem("Save selected tasks to file");
                    item.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent arg0) {
                            TaskManagerPanel.this.saveLogSelectedTasks();
                        }
                    });
                    menu.add(item);
                    item = new JMenuItem("Enter configuration...");
                    item.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent arg0) {
                            String newTaskString = JOptionPane.showInputDialog("Insert command line");
                            if (newTaskString != null) {
                                TaskManagerPanel.this.setTaskString(newTaskString);
                            }
                        }
                    });
                    menu.add(item);
                    menu.show(comp, evt.getX(), evt.getY());
                }
            }
        });
        JPanel configPanel = new JPanel();
        configPanel.setLayout(new BorderLayout());
        configPanel.add((Component)this.configureTaskButton, "West");
        configPanel.add((Component)this.taskDescField, "Center");
        configPanel.add((Component)this.runTaskButton, "East");
        this.taskTableModel = new TaskTableModel();
        this.taskTable = new JTable(this.taskTableModel);
        DefaultTableCellRenderer centerRenderer = new DefaultTableCellRenderer();
        centerRenderer.setHorizontalAlignment(0);
        this.taskTable.getColumnModel().getColumn(1).setCellRenderer(centerRenderer);
        this.taskTable.getColumnModel().getColumn(2).setCellRenderer(centerRenderer);
        this.taskTable.getColumnModel().getColumn(4).setCellRenderer(new ProgressCellRenderer());
        JPanel controlPanel = new JPanel();
        controlPanel.add(this.pauseTaskButton);
        controlPanel.add(this.resumeTaskButton);
        controlPanel.add(this.cancelTaskButton);
        controlPanel.add(this.deleteTaskButton);
        this.setLayout(new BorderLayout());
        this.add((Component)configPanel, "North");
        this.add((Component)new JScrollPane(this.taskTable), "Center");
        this.add((Component)controlPanel, "South");
        this.taskTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent arg0) {
                TaskManagerPanel.this.taskSelectionChanged();
            }
        });
        this.configureTaskButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                String newTaskString = ClassOptionSelectionPanel.showSelectClassDialog(TaskManagerPanel.this, "Configure task", MainTask.class, TaskManagerPanel.this.currentTask.getCLICreationString(MainTask.class), null);
                TaskManagerPanel.this.setTaskString(newTaskString);
            }
        });
        this.runTaskButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                TaskManagerPanel.this.runTask((Task)((Object)TaskManagerPanel.this.currentTask.copy()));
            }
        });
        this.pauseTaskButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                TaskManagerPanel.this.pauseSelectedTasks();
            }
        });
        this.resumeTaskButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                TaskManagerPanel.this.resumeSelectedTasks();
            }
        });
        this.cancelTaskButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                TaskManagerPanel.this.cancelSelectedTasks();
            }
        });
        this.deleteTaskButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                TaskManagerPanel.this.deleteSelectedTasks();
            }
        });
        Timer updateListTimer = new Timer(600, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TaskManagerPanel.this.taskTable.repaint();
            }
        });
        updateListTimer.start();
        this.setPreferredSize(new Dimension(0, 200));
    }

    public void setPreviewPanel(PreviewPanel previewPanel) {
        this.previewPanel = previewPanel;
    }

    public void setTaskString(String cliString) {
        try {
            this.currentTask = (MainTask)ClassOption.cliStringToObject(cliString, MainTask.class, null);
            this.taskDescField.setText(this.currentTask.getCLICreationString(MainTask.class));
        }
        catch (Exception ex) {
            GUIUtils.showExceptionDialog(this, "Problem with task", ex);
        }
    }

    public void runTask(Task task) {
        TaskThread thread = new TaskThread(task);
        this.taskList.add(0, thread);
        this.taskTableModel.fireTableDataChanged();
        this.taskTable.setRowSelectionInterval(0, 0);
        thread.start();
    }

    public void taskSelectionChanged() {
        TaskThread[] selectedTasks = this.getSelectedTasks();
        if (selectedTasks.length == 1) {
            this.setTaskString(((OptionHandler)((Object)selectedTasks[0].getTask())).getCLICreationString(MainTask.class));
            if (this.previewPanel != null) {
                this.previewPanel.setTaskThreadToPreview(selectedTasks[0]);
            }
        } else {
            this.previewPanel.setTaskThreadToPreview(null);
        }
    }

    public TaskThread[] getSelectedTasks() {
        int[] selectedRows = this.taskTable.getSelectedRows();
        TaskThread[] selectedTasks = new TaskThread[selectedRows.length];
        for (int i = 0; i < selectedRows.length; ++i) {
            selectedTasks[i] = this.taskList.get(selectedRows[i]);
        }
        return selectedTasks;
    }

    public void pauseSelectedTasks() {
        TaskThread[] selectedTasks;
        for (TaskThread thread : selectedTasks = this.getSelectedTasks()) {
            thread.pauseTask();
        }
    }

    public void resumeSelectedTasks() {
        TaskThread[] selectedTasks;
        for (TaskThread thread : selectedTasks = this.getSelectedTasks()) {
            thread.resumeTask();
        }
    }

    public void cancelSelectedTasks() {
        TaskThread[] selectedTasks;
        for (TaskThread thread : selectedTasks = this.getSelectedTasks()) {
            thread.cancelTask();
        }
    }

    public void deleteSelectedTasks() {
        TaskThread[] selectedTasks;
        for (TaskThread thread : selectedTasks = this.getSelectedTasks()) {
            thread.cancelTask();
            this.taskList.remove(thread);
        }
        this.taskTableModel.fireTableDataChanged();
    }

    public void copyClipBoardConfiguration() {
        StringSelection selection = new StringSelection(this.taskDescField.getText().trim());
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(selection, selection);
    }

    public void saveLogSelectedTasks() {
        TaskThread[] selectedTasks;
        String tasksLog = "";
        for (TaskThread thread : selectedTasks = this.getSelectedTasks()) {
            tasksLog = tasksLog + ((OptionHandler)((Object)thread.getTask())).getCLICreationString(MainTask.class) + "\n";
        }
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setAcceptAllFileFilterUsed(true);
        fileChooser.addChoosableFileFilter(new FileExtensionFilter(exportFileExtension));
        if (fileChooser.showSaveDialog(this) == 0) {
            File chosenFile = fileChooser.getSelectedFile();
            String fileName = chosenFile.getPath();
            if (!chosenFile.exists() && !fileName.endsWith(exportFileExtension)) {
                fileName = fileName + "." + exportFileExtension;
            }
            try {
                PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
                out.write(tasksLog);
                out.close();
            }
            catch (IOException ioe) {
                GUIUtils.showExceptionDialog(this, "Problem saving file " + fileName, ioe);
            }
        }
    }

    private static void createAndShowGUI() {
        JFrame frame = new JFrame("Test");
        frame.setDefaultCloseOperation(3);
        TaskManagerPanel panel = new TaskManagerPanel();
        panel.setOpaque(true);
        frame.setContentPane(panel);
        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    TaskManagerPanel.createAndShowGUI();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected class TaskTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        protected TaskTableModel() {
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return "command";
                }
                case 1: {
                    return "status";
                }
                case 2: {
                    return "time elapsed";
                }
                case 3: {
                    return "current activity";
                }
                case 4: {
                    return "% complete";
                }
            }
            return null;
        }

        public int getColumnCount() {
            return 5;
        }

        public int getRowCount() {
            return TaskManagerPanel.this.taskList.size();
        }

        public Object getValueAt(int row, int col) {
            TaskThread thread = TaskManagerPanel.this.taskList.get(row);
            switch (col) {
                case 0: {
                    return ((OptionHandler)((Object)thread.getTask())).getCLICreationString(MainTask.class);
                }
                case 1: {
                    return thread.getCurrentStatusString();
                }
                case 2: {
                    return StringUtils.secondsToDHMSString(thread.getCPUSecondsElapsed());
                }
                case 3: {
                    return thread.getCurrentActivityString();
                }
                case 4: {
                    return new Double(thread.getCurrentActivityFracComplete());
                }
            }
            return null;
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }

    public class ProgressCellRenderer
    extends JProgressBar
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        public ProgressCellRenderer() {
            super(0, 0, 10000);
            this.setBorderPainted(false);
            this.setStringPainted(true);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof Double) {
                double frac = (Double)value;
                if (frac >= 0.0) {
                    this.setIndeterminate(false);
                    this.setValue((int)(frac * 10000.0));
                    this.setString(StringUtils.doubleToString(frac * 100.0, 2, 2));
                } else {
                    this.setValue(0);
                    this.setIndeterminate(true);
                    this.setString("?");
                }
            }
            return this;
        }

        public void validate() {
        }

        public void revalidate() {
        }

        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        }

        public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        }
    }
}

