/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.experiment;

import adams.gui.chooser.DirectoryChooserPanel;
import adams.gui.chooser.FileChooserPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.IntrospectionException;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyDescriptor;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import weka.classifiers.Classifier;
import weka.core.xml.KOML;
import weka.experiment.CSVResultListener;
import weka.experiment.ClassifierSplitEvaluator;
import weka.experiment.CrossValidationResultProducer;
import weka.experiment.DatabaseResultListener;
import weka.experiment.Experiment;
import weka.experiment.PropertyNode;
import weka.experiment.RegressionSplitEvaluator;
import weka.experiment.ResultProducer;
import weka.experiment.SplitEvaluator;
import weka.gui.ExtensionFileFilter;
import weka.gui.experiment.AlgorithmListPanel;
import weka.gui.experiment.DatasetListPanel;
import weka.gui.experiment.ExperimenterDefaults;
import weka.gui.experiment.SetupModePanel;

public class HadoopGuiSetupPanel
extends JPanel {
    private static final long serialVersionUID = 5257424515609176509L;
    protected Experiment m_Exp;
    protected SetupModePanel m_modePanel = null;
    protected String m_destinationDatabaseURL;
    protected String m_destinationFilename = "";
    protected int m_numFolds = 10;
    protected double m_trainPercent = 66.0;
    protected int m_numRepetitions = 10;
    protected boolean m_userHasBeenAskedAboutConversion;
    protected ExtensionFileFilter m_csvFileFilter = new ExtensionFileFilter(".csv", "Comma separated value files");
    protected JButton m_OpenBut = new JButton("Open...");
    protected JButton m_SaveBut = new JButton("Save...");
    protected JButton m_NewBut = new JButton("New");
    protected FileFilter m_ExpFilter = new ExtensionFileFilter(Experiment.FILE_EXTENSION, "Experiment configuration files (*" + Experiment.FILE_EXTENSION + ")");
    protected FileFilter m_KOMLFilter = new ExtensionFileFilter(".koml", "Experiment configuration files (*.koml)");
    protected FileFilter m_XMLFilter = new ExtensionFileFilter(".xml", "Experiment configuration files (*.xml)");
    protected JFileChooser m_FileChooser = new JFileChooser(new File(System.getProperty("user.dir")));
    protected JFileChooser m_DestFileChooser = new JFileChooser(new File(System.getProperty("user.dir")));
    protected JLabel m_ResultsDestinationPathLabel = new JLabel("CSV Filename:");
    protected FileChooserPanel m_ResultDestinationPath = new FileChooserPanel();
    protected DirectoryChooserPanel m_InputHadoopHome = new DirectoryChooserPanel(new File(System.getProperty("user.dir")));
    protected JLabel m_InputHadoopHomeLabel = new JLabel("Hadoop Home");
    protected JLabel m_inputHadoopConfFolder = new JLabel("Hadoop Conf Folder");
    protected DirectoryChooserPanel m_InputHadoopConf = new DirectoryChooserPanel(new File(System.getProperty("user.dir")));
    protected JButton m_HadoopConfButton = new JButton("Browse");
    protected JLabel m_ExperimentParameterLabel = new JLabel("Number of folds:");
    protected JTextField m_ExperimentParameterTField = new JTextField();
    protected JRadioButton m_ExpClassificationRBut = new JRadioButton("Classification");
    protected JRadioButton m_ExpRegressionRBut = new JRadioButton("Regression");
    protected JTextField m_NumberOfRepetitionsTField = new JTextField();
    protected static String DEST_DATABASE_TEXT = "JDBC database";
    protected static String DEST_ARFF_TEXT = "ARFF file";
    protected static String DEST_CSV_TEXT = "CSV file";
    protected static String TYPE_CROSSVALIDATION_TEXT = "Cross-validation";
    protected static String TYPE_RANDOMSPLIT_TEXT = "Train/Test Percentage Split (data randomized)";
    protected static String TYPE_FIXEDSPLIT_TEXT = "Train/Test Percentage Split (order preserved)";
    protected DatasetListPanel m_DatasetListPanel = new DatasetListPanel();
    protected AlgorithmListPanel m_AlgorithmListPanel = new AlgorithmListPanel();
    protected JButton m_NotesButton = new JButton("Notes");
    protected JFrame m_NotesFrame = new JFrame("Notes");
    protected JTextArea m_NotesText = new JTextArea(null, 10, 0);
    protected PropertyChangeSupport m_Support = new PropertyChangeSupport(this);
    protected String m_hadoopConf = "";
    protected String m_jarPath = "";
    protected String m_expType = "";

    public HadoopGuiSetupPanel(Experiment exp) {
        this();
        this.setExperiment(exp);
    }

    public HadoopGuiSetupPanel() {
        this.m_InputHadoopHomeLabel.setEnabled(false);
        this.m_InputHadoopHome.setEnabled(false);
        this.m_inputHadoopConfFolder.setEnabled(false);
        this.m_InputHadoopConf.setEnabled(false);
        this.m_ResultsDestinationPathLabel.setEnabled(false);
        this.m_ResultDestinationPath.setEnabled(false);
        this.m_ExperimentParameterLabel.setEnabled(false);
        this.m_ExperimentParameterTField.setEnabled(false);
        this.m_ExpClassificationRBut.setEnabled(false);
        this.m_ExpRegressionRBut.setEnabled(false);
        this.m_NumberOfRepetitionsTField.setEnabled(false);
        this.m_HadoopConfButton.setEnabled(false);
        try {
            this.m_destinationDatabaseURL = new DatabaseResultListener().getDatabaseURL();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.m_NewBut.setMnemonic('N');
        this.m_NewBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment newExp = new Experiment();
                CrossValidationResultProducer cvrp = new CrossValidationResultProducer();
                cvrp.setNumFolds(10);
                cvrp.setSplitEvaluator((SplitEvaluator)new ClassifierSplitEvaluator());
                newExp.setResultProducer((ResultProducer)cvrp);
                newExp.setPropertyArray((Object)new Classifier[0]);
                newExp.setUsePropertyIterator(true);
                HadoopGuiSetupPanel.this.setExperiment(newExp);
                if (ExperimenterDefaults.getUseClassification()) {
                    HadoopGuiSetupPanel.this.m_ExpClassificationRBut.setSelected(true);
                } else {
                    HadoopGuiSetupPanel.this.m_ExpRegressionRBut.setSelected(true);
                }
                HadoopGuiSetupPanel.this.m_numRepetitions = ExperimenterDefaults.getRepetitions();
                HadoopGuiSetupPanel.this.m_NumberOfRepetitionsTField.setText("" + HadoopGuiSetupPanel.this.m_numRepetitions);
                if (ExperimenterDefaults.getExperimentType().equals(TYPE_CROSSVALIDATION_TEXT)) {
                    HadoopGuiSetupPanel.this.m_numFolds = ExperimenterDefaults.getFolds();
                    HadoopGuiSetupPanel.this.m_ExperimentParameterTField.setText("" + HadoopGuiSetupPanel.this.m_numFolds);
                } else {
                    HadoopGuiSetupPanel.this.m_trainPercent = ExperimenterDefaults.getTrainPercentage();
                    HadoopGuiSetupPanel.this.m_ExperimentParameterTField.setText("" + HadoopGuiSetupPanel.this.m_trainPercent);
                }
                HadoopGuiSetupPanel.this.expTypeChanged();
            }
        });
        this.m_SaveBut.setEnabled(false);
        this.m_SaveBut.setMnemonic('S');
        this.m_SaveBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HadoopGuiSetupPanel.this.saveExperiment();
            }
        });
        this.m_OpenBut.setMnemonic('O');
        this.m_OpenBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HadoopGuiSetupPanel.this.openExperiment();
            }
        });
        this.m_FileChooser.addChoosableFileFilter(this.m_ExpFilter);
        if (KOML.isPresent()) {
            this.m_FileChooser.addChoosableFileFilter(this.m_KOMLFilter);
        }
        this.m_FileChooser.addChoosableFileFilter(this.m_XMLFilter);
        if (ExperimenterDefaults.getExtension().equals(".xml")) {
            this.m_FileChooser.setFileFilter(this.m_XMLFilter);
        } else if (KOML.isPresent() && ExperimenterDefaults.getExtension().equals(".koml")) {
            this.m_FileChooser.setFileFilter(this.m_KOMLFilter);
        } else {
            this.m_FileChooser.setFileFilter(this.m_ExpFilter);
        }
        this.m_FileChooser.setFileSelectionMode(0);
        this.m_DestFileChooser.setFileSelectionMode(0);
        this.m_ExpClassificationRBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HadoopGuiSetupPanel.this.expTypeChanged();
            }
        });
        this.m_ExpRegressionRBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HadoopGuiSetupPanel.this.expTypeChanged();
            }
        });
        this.m_ResultDestinationPath.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                HadoopGuiSetupPanel.this.destinationAddressChanged();
            }
        });
        this.m_ExperimentParameterTField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                HadoopGuiSetupPanel.this.expParamChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                HadoopGuiSetupPanel.this.expParamChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                HadoopGuiSetupPanel.this.expParamChanged();
            }
        });
        this.m_NumberOfRepetitionsTField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                HadoopGuiSetupPanel.this.numRepetitionsChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                HadoopGuiSetupPanel.this.numRepetitionsChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                HadoopGuiSetupPanel.this.numRepetitionsChanged();
            }
        });
        this.m_NotesFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                HadoopGuiSetupPanel.this.m_NotesButton.setEnabled(true);
            }
        });
        this.m_NotesFrame.getContentPane().add(new JScrollPane(this.m_NotesText));
        this.m_NotesFrame.setSize(600, 400);
        this.m_NotesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HadoopGuiSetupPanel.this.m_NotesButton.setEnabled(false);
                HadoopGuiSetupPanel.this.m_NotesFrame.setVisible(true);
            }
        });
        this.m_NotesButton.setEnabled(false);
        this.m_NotesText.setEditable(true);
        this.m_NotesText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                HadoopGuiSetupPanel.this.m_Exp.setNotes(HadoopGuiSetupPanel.this.m_NotesText.getText());
            }
        });
        this.m_NotesText.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                HadoopGuiSetupPanel.this.m_Exp.setNotes(HadoopGuiSetupPanel.this.m_NotesText.getText());
            }
        });
        JPanel buttons = new JPanel();
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        buttons.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        buttons.setLayout(gb);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 5.0;
        constraints.fill = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.insets = new Insets(0, 2, 0, 2);
        buttons.add((Component)this.m_OpenBut, constraints);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.weightx = 5.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        buttons.add((Component)this.m_SaveBut, constraints);
        constraints.gridx = 2;
        constraints.gridy = 0;
        constraints.weightx = 5.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        buttons.add((Component)this.m_NewBut, constraints);
        JPanel inputName = new JPanel();
        inputName.setLayout(new BorderLayout(5, 5));
        inputName.add((Component)this.m_InputHadoopHomeLabel, "West");
        inputName.add((Component)this.m_InputHadoopHome, "Center");
        JPanel outputName = new JPanel();
        outputName.setLayout(new BorderLayout(5, 5));
        outputName.add((Component)this.m_inputHadoopConfFolder, "West");
        outputName.add((Component)this.m_InputHadoopConf, "Center");
        JPanel hadoopConf = new JPanel();
        hadoopConf.setLayout(new GridLayout(0, 1));
        hadoopConf.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Path Setting"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        hadoopConf.add(inputName);
        hadoopConf.add(outputName);
        JPanel destName = new JPanel();
        destName.setLayout(new BorderLayout(5, 5));
        destName.add((Component)this.m_ResultsDestinationPathLabel, "West");
        destName.add((Component)this.m_ResultDestinationPath, "Center");
        hadoopConf.add(destName);
        JPanel expParam = new JPanel();
        expParam.setLayout(new BorderLayout(5, 5));
        expParam.add((Component)this.m_ExperimentParameterLabel, "West");
        expParam.add((Component)this.m_ExperimentParameterTField, "Center");
        this.m_ExpClassificationRBut.setSelected(true);
        ButtonGroup typeBG = new ButtonGroup();
        typeBG.add(this.m_ExpClassificationRBut);
        typeBG.add(this.m_ExpRegressionRBut);
        JPanel typeRButtons = new JPanel();
        typeRButtons.setLayout(new GridLayout(1, 0));
        typeRButtons.add(this.m_ExpClassificationRBut);
        typeRButtons.add(this.m_ExpRegressionRBut);
        JPanel typeInner = new JPanel();
        typeInner.setLayout(new GridLayout(0, 1));
        typeInner.add(expParam);
        typeInner.add(typeRButtons);
        JPanel type = new JPanel();
        type.setLayout(new BorderLayout());
        type.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Cross Validation"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        type.add((Component)typeInner, "North");
        JPanel numIter = new JPanel();
        numIter.setLayout(new BorderLayout(5, 5));
        numIter.add((Component)new JLabel("Number of repetitions:"), "West");
        numIter.add((Component)this.m_NumberOfRepetitionsTField, "Center");
        JPanel controlInner = new JPanel();
        controlInner.setLayout(new GridLayout(0, 1));
        controlInner.add(numIter);
        JPanel control = new JPanel();
        control.setLayout(new BorderLayout());
        control.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Iteration Control"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        control.add((Component)controlInner, "North");
        JPanel type_control = new JPanel();
        type_control.setLayout(new GridLayout(1, 0));
        type_control.add(type);
        type_control.add(control);
        JPanel notes = new JPanel();
        notes.setLayout(new BorderLayout());
        notes.add((Component)this.m_NotesButton, "Center");
        JPanel top1 = new JPanel();
        top1.setLayout(new BorderLayout(5, 5));
        top1.add((Component)hadoopConf, "North");
        top1.add((Component)type_control, "Center");
        JPanel top = new JPanel();
        top.setLayout(new BorderLayout());
        top.add((Component)buttons, "North");
        top.add((Component)top1, "Center");
        JPanel datasets = new JPanel();
        datasets.setLayout(new BorderLayout());
        datasets.add((Component)this.m_DatasetListPanel, "Center");
        JPanel algorithms = new JPanel();
        algorithms.setLayout(new BorderLayout());
        algorithms.add((Component)this.m_AlgorithmListPanel, "Center");
        JPanel schemes = new JPanel();
        schemes.setLayout(new GridLayout(1, 0));
        schemes.add(datasets);
        schemes.add(algorithms);
        this.setLayout(new BorderLayout());
        this.add((Component)top, "North");
        this.add((Component)schemes, "Center");
        this.add((Component)notes, "South");
    }

    protected void setSelectedItem(JComboBox cb, String item) {
        for (int i = 0; i < cb.getItemCount(); ++i) {
            if (!cb.getItemAt(i).toString().equals(item)) continue;
            cb.setSelectedIndex(i);
            break;
        }
    }

    protected void removeNotesFrame() {
        this.m_NotesFrame.setVisible(false);
    }

    private boolean userWantsToConvert() {
        if (this.m_userHasBeenAskedAboutConversion) {
            return true;
        }
        this.m_userHasBeenAskedAboutConversion = true;
        return JOptionPane.showConfirmDialog(this, "This experiment has settings that are too advanced\nto be represented in the simple setup mode.\nDo you want the experiment to be converted,\nlosing some of the advanced settings?\n", "Confirm conversion", 0, 2) == 0;
    }

    public void setModePanel(SetupModePanel modePanel) {
        this.m_modePanel = modePanel;
    }

    public boolean setExperiment(Experiment exp) {
        this.m_userHasBeenAskedAboutConversion = false;
        this.m_Exp = null;
        this.m_SaveBut.setEnabled(true);
        if (exp.getResultListener() instanceof CSVResultListener) {
            this.m_destinationFilename = ((CSVResultListener)exp.getResultListener()).outputFileName();
            this.m_ResultDestinationPath.setCurrent(new File(this.m_destinationFilename));
            this.m_ResultDestinationPath.setEnabled(true);
        }
        this.m_InputHadoopHome.setEnabled(true);
        this.m_inputHadoopConfFolder.setEnabled(true);
        this.m_InputHadoopConf.setEnabled(true);
        this.m_ResultsDestinationPathLabel.setEnabled(true);
        this.m_ResultDestinationPath.setEnabled(true);
        this.m_HadoopConfButton.setEnabled(true);
        this.m_InputHadoopHomeLabel.setEnabled(true);
        if (exp.getResultProducer() instanceof CrossValidationResultProducer) {
            CrossValidationResultProducer cvrp = (CrossValidationResultProducer)exp.getResultProducer();
            this.m_numFolds = cvrp.getNumFolds();
            this.m_ExperimentParameterTField.setText("" + this.m_numFolds);
            if (cvrp.getSplitEvaluator() instanceof ClassifierSplitEvaluator) {
                this.m_ExpClassificationRBut.setSelected(true);
                this.m_ExpRegressionRBut.setSelected(false);
            } else if (cvrp.getSplitEvaluator() instanceof RegressionSplitEvaluator) {
                this.m_ExpClassificationRBut.setSelected(false);
                this.m_ExpRegressionRBut.setSelected(true);
            } else {
                System.out.println("SimpleSetup incompatibility: unrecognised split evaluator");
                if (this.userWantsToConvert()) {
                    this.m_ExpClassificationRBut.setSelected(true);
                    this.m_ExpRegressionRBut.setSelected(false);
                } else {
                    return false;
                }
            }
        }
        this.m_ExperimentParameterLabel.setEnabled(true);
        this.m_ExperimentParameterTField.setEnabled(true);
        this.m_ExpClassificationRBut.setEnabled(true);
        this.m_ExpRegressionRBut.setEnabled(true);
        if (exp.getRunLower() == 1) {
            this.m_numRepetitions = exp.getRunUpper();
            this.m_NumberOfRepetitionsTField.setText("" + this.m_numRepetitions);
        } else {
            System.out.println("SimpleSetup incompatibility: runLower is not 1");
            if (this.userWantsToConvert()) {
                exp.setRunLower(1);
                exp.setRunUpper(10);
                this.m_numRepetitions = 10;
                this.m_NumberOfRepetitionsTField.setText("" + this.m_numRepetitions);
            } else {
                return false;
            }
        }
        this.m_NumberOfRepetitionsTField.setEnabled(true);
        this.m_NotesText.setText(exp.getNotes());
        this.m_NotesButton.setEnabled(true);
        if (!exp.getUsePropertyIterator() || !(exp.getPropertyArray() instanceof Classifier[])) {
            System.out.println("SimpleSetup incompatibility: unrecognised property iteration");
            if (this.userWantsToConvert()) {
                exp.setPropertyArray((Object)new Classifier[0]);
                exp.setUsePropertyIterator(true);
            } else {
                return false;
            }
        }
        this.m_DatasetListPanel.setExperiment(exp);
        this.m_AlgorithmListPanel.setExperiment(exp);
        this.m_Exp = exp;
        this.expTypeChanged();
        this.m_Support.firePropertyChange("", null, null);
        return true;
    }

    public Experiment getExperiment() {
        return this.m_Exp;
    }

    private void openExperiment() {
        int returnVal = this.m_FileChooser.showOpenDialog(this);
        if (returnVal != 0) {
            return;
        }
        File expFile = this.m_FileChooser.getSelectedFile();
        if (this.m_FileChooser.getFileFilter() == this.m_ExpFilter) {
            if (!expFile.getName().toLowerCase().endsWith(Experiment.FILE_EXTENSION)) {
                expFile = new File(expFile.getParent(), expFile.getName() + Experiment.FILE_EXTENSION);
            }
        } else if (this.m_FileChooser.getFileFilter() == this.m_KOMLFilter) {
            if (!expFile.getName().toLowerCase().endsWith(".koml")) {
                expFile = new File(expFile.getParent(), expFile.getName() + ".koml");
            }
        } else if (this.m_FileChooser.getFileFilter() == this.m_XMLFilter && !expFile.getName().toLowerCase().endsWith(".xml")) {
            expFile = new File(expFile.getParent(), expFile.getName() + ".xml");
        }
        try {
            Experiment exp = Experiment.read((String)expFile.getAbsolutePath());
            if (!(exp.getResultProducer() instanceof CrossValidationResultProducer)) {
                throw new Exception("Experiment does not use cross-validation!");
            }
            if (!this.setExperiment(exp) && this.m_modePanel != null) {
                this.m_modePanel.switchToAdvanced(exp);
            }
            System.err.println("Opened experiment:\n" + exp);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this, "Couldn't open experiment file:\n" + expFile + "\nReason:\n" + ex.getMessage(), "Open Experiment", 0);
        }
    }

    private void saveExperiment() {
        int returnVal = this.m_FileChooser.showSaveDialog(this);
        if (returnVal != 0) {
            return;
        }
        File expFile = this.m_FileChooser.getSelectedFile();
        if (this.m_FileChooser.getFileFilter() == this.m_ExpFilter) {
            if (!expFile.getName().toLowerCase().endsWith(Experiment.FILE_EXTENSION)) {
                expFile = new File(expFile.getParent(), expFile.getName() + Experiment.FILE_EXTENSION);
            }
        } else if (this.m_FileChooser.getFileFilter() == this.m_KOMLFilter) {
            if (!expFile.getName().toLowerCase().endsWith(".koml")) {
                expFile = new File(expFile.getParent(), expFile.getName() + ".koml");
            }
        } else if (this.m_FileChooser.getFileFilter() == this.m_XMLFilter && !expFile.getName().toLowerCase().endsWith(".xml")) {
            expFile = new File(expFile.getParent(), expFile.getName() + ".xml");
        }
        try {
            Experiment.write((String)expFile.getAbsolutePath(), (Experiment)this.m_Exp);
            System.err.println("Saved experiment:\n" + this.m_Exp);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this, "Couldn't save experiment file:\n" + expFile + "\nReason:\n" + ex.getMessage(), "Save Experiment", 0);
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.m_Support.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.m_Support.removePropertyChangeListener(l);
    }

    private void destinationAddressChanged() {
        if (this.m_Exp == null) {
            return;
        }
        File resultsFile = null;
        this.m_destinationFilename = ((File)this.m_ResultDestinationPath.getCurrent()).getAbsolutePath();
        if (this.m_destinationFilename.equals("")) {
            try {
                resultsFile = File.createTempFile("weka_experiment", ".csv");
                resultsFile.deleteOnExit();
            }
            catch (Exception e) {
                System.err.println("Cannot create temp file, writing to standard out.");
                resultsFile = new File("-");
            }
        } else {
            if (!this.m_destinationFilename.endsWith(".csv")) {
                this.m_destinationFilename = this.m_destinationFilename + ".csv";
            }
            resultsFile = new File(this.m_destinationFilename);
        }
        ((CSVResultListener)this.m_Exp.getResultListener()).setOutputFile(resultsFile);
        ((CSVResultListener)this.m_Exp.getResultListener()).setOutputFileName(this.m_destinationFilename);
        this.m_Support.firePropertyChange("", null, null);
    }

    private void expTypeChanged() {
        if (this.m_Exp == null) {
            return;
        }
        ClassifierSplitEvaluator se = null;
        Classifier sec = null;
        if (this.m_ExpClassificationRBut.isSelected()) {
            se = new ClassifierSplitEvaluator();
            sec = se.getClassifier();
            this.m_expType = "classification";
        } else {
            se = new RegressionSplitEvaluator();
            sec = ((RegressionSplitEvaluator)se).getClassifier();
            this.m_expType = "regression";
        }
        CrossValidationResultProducer cvrp = new CrossValidationResultProducer();
        cvrp.setNumFolds(this.m_numFolds);
        cvrp.setSplitEvaluator((SplitEvaluator)se);
        PropertyNode[] propertyPath = new PropertyNode[2];
        try {
            propertyPath[0] = new PropertyNode((Object)se, new PropertyDescriptor("splitEvaluator", CrossValidationResultProducer.class), CrossValidationResultProducer.class);
            propertyPath[1] = new PropertyNode((Object)sec, new PropertyDescriptor("classifier", se.getClass()), se.getClass());
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
        this.m_Exp.setResultProducer((ResultProducer)cvrp);
        this.m_Exp.setPropertyPath(propertyPath);
        this.m_Exp.setUsePropertyIterator(true);
        this.m_Support.firePropertyChange("", null, null);
    }

    private void expParamChanged() {
        if (this.m_Exp == null) {
            return;
        }
        try {
            this.m_numFolds = Integer.parseInt(this.m_ExperimentParameterTField.getText());
        }
        catch (NumberFormatException e) {
            return;
        }
        if (!(this.m_Exp.getResultProducer() instanceof CrossValidationResultProducer)) {
            return;
        }
        CrossValidationResultProducer cvrp = (CrossValidationResultProducer)this.m_Exp.getResultProducer();
        cvrp.setNumFolds(this.m_numFolds);
        this.m_Support.firePropertyChange("", null, null);
    }

    private void numRepetitionsChanged() {
        if (this.m_Exp == null || !this.m_NumberOfRepetitionsTField.isEnabled()) {
            return;
        }
        try {
            this.m_numRepetitions = Integer.parseInt(this.m_NumberOfRepetitionsTField.getText());
        }
        catch (NumberFormatException e) {
            return;
        }
        this.m_Exp.setRunLower(1);
        this.m_Exp.setRunUpper(this.m_numRepetitions);
        this.m_Support.firePropertyChange("", null, null);
    }

    public String getHadoopHomePath() {
        return ((File)this.m_InputHadoopHome.getCurrent()).getAbsolutePath();
    }

    public String getHadoopConfPath() {
        return ((File)this.m_InputHadoopConf.getCurrent()).getAbsolutePath();
    }

    public String getExpType() {
        return this.m_expType;
    }
}

