/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.tools.kernel;

import de.intarsys.pdf.cds.CDSMatrix;
import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.pd.PDPage;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

public class PDFGeometryTools {
    protected static final double RADIANS_MIN_270 = Math.toRadians(-270.0);
    protected static final double RADIANS_MIN_180 = Math.toRadians(-180.0);
    protected static final double RADIANS_MIN_90 = Math.toRadians(-90.0);

    public static void adjustTransform(AffineTransform transform, int rotate, Rectangle2D rect) {
        if (rotate == 0) {
            transform.translate(-rect.getMinX(), -rect.getMinY());
        } else if (rotate == 90) {
            transform.translate(-rect.getMinY(), rect.getMaxX());
            transform.rotate(RADIANS_MIN_90);
        } else if (rotate == 180) {
            transform.translate(rect.getMaxX(), rect.getMaxY());
            transform.rotate(RADIANS_MIN_180);
        } else if (rotate == 270) {
            transform.translate(rect.getMaxY(), -rect.getMinX());
            transform.rotate(RADIANS_MIN_270);
        } else {
            transform.translate(-rect.getMinX(), -rect.getMinY());
        }
    }

    public static void adjustTransform(AffineTransform transform, PDPage page) {
        int rotate = PDFGeometryTools.normalizeRotate(page.getRotate());
        Rectangle2D rect = page.getCropBox().toNormalizedRectangle();
        PDFGeometryTools.adjustTransform(transform, rotate, rect);
    }

    public static int normalizeRotate(int rotation) {
        if ((rotation %= 360) > 0) {
            return rotation - rotation % 90;
        }
        if (rotation == 0) {
            return 0;
        }
        return (rotation += 360) - rotation % 90;
    }

    public static CDSRectangle transform(CDSMatrix matrix, CDSRectangle rect) {
        float[] vec = new float[]{rect.getLowerLeftX(), rect.getLowerLeftY(), rect.getUpperRightX(), rect.getUpperRightY()};
        float[] tVec = matrix.transform(vec);
        return new CDSRectangle(tVec);
    }

    private PDFGeometryTools() {
    }
}

