/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.benchmark;

import java.io.File;
import java.util.List;
import org.ujmp.core.Coordinates;
import org.ujmp.core.Matrix;
import org.ujmp.core.MatrixFactory;
import org.ujmp.core.benchmark.BenchmarkConfig;
import org.ujmp.core.benchmark.BenchmarkResult;
import org.ujmp.core.benchmark.BenchmarkUtil;
import org.ujmp.core.doublematrix.DenseDoubleMatrix2D;
import org.ujmp.core.enums.FileFormat;
import org.ujmp.core.enums.ValueType;
import org.ujmp.core.matrix.Matrix2D;
import org.ujmp.core.util.MathUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBenchmarkTask {
    private BenchmarkConfig config = null;
    private Class<? extends Matrix> matrixClass = null;
    private List<long[]> sizes = null;
    private long benchmarkSeed = 0L;

    public AbstractBenchmarkTask(long benchmarkSeed, Class<? extends Matrix> matrixClass, List<long[]> sizes, BenchmarkConfig config) {
        this.matrixClass = matrixClass;
        this.config = config;
        this.sizes = sizes;
    }

    public BenchmarkConfig getConfig() {
        return this.config;
    }

    public void run() {
        File timeFile = new File(String.valueOf(BenchmarkUtil.getResultDir(this.getConfig())) + this.getMatrixLabel() + "/" + this.getTaskName() + ".csv");
        File diffFile = new File(String.valueOf(BenchmarkUtil.getResultDir(this.getConfig())) + this.getMatrixLabel() + "/" + this.getTaskName() + "-diff.csv");
        File memFile = new File(String.valueOf(BenchmarkUtil.getResultDir(this.getConfig())) + this.getMatrixLabel() + "/" + this.getTaskName() + "-mem.csv");
        if (timeFile.exists()) {
            System.out.println("old results available, skipping " + this.getTaskName() + " for " + this.getMatrixLabel());
            return;
        }
        Matrix2D resultTime = (Matrix2D)MatrixFactory.zeros(ValueType.STRING, this.config.getRuns(), this.sizes.size());
        Matrix2D resultDiff = (Matrix2D)MatrixFactory.zeros(ValueType.STRING, this.config.getRuns(), this.sizes.size());
        Matrix2D resultMem = (Matrix2D)MatrixFactory.zeros(ValueType.STRING, this.config.getRuns(), this.sizes.size());
        resultTime.setLabel(String.valueOf(this.getMatrixLabel()) + "-" + this.getTaskName());
        resultDiff.setLabel(String.valueOf(this.getMatrixLabel()) + "-" + this.getTaskName() + "-diff");
        resultMem.setLabel(String.valueOf(this.getMatrixLabel()) + "-" + this.getTaskName() + "-mem");
        int s = 0;
        while (s < this.sizes.size()) {
            long[] size = this.sizes.get(s);
            resultTime.setColumnLabel(s, String.valueOf(size[0]));
            resultDiff.setColumnLabel(s, String.valueOf(size[0]));
            resultMem.setColumnLabel(s, String.valueOf(size[0]));
            ++s;
        }
        boolean stopped = false;
        int s2 = 0;
        while (!stopped && s2 < this.sizes.size()) {
            long[] size = this.sizes.get(s2);
            double bestStd = Double.MAX_VALUE;
            int tmpTrialCount = this.config.getMinTrialCount();
            DenseDoubleMatrix2D curTime = DenseDoubleMatrix2D.factory.zeros((long)this.config.getRuns(), 1L);
            DenseDoubleMatrix2D bestTime = DenseDoubleMatrix2D.factory.zeros((long)this.config.getRuns(), 1L);
            DenseDoubleMatrix2D curDiff = DenseDoubleMatrix2D.factory.zeros((long)this.config.getRuns(), 1L);
            DenseDoubleMatrix2D bestDiff = DenseDoubleMatrix2D.factory.zeros((long)this.config.getRuns(), 1L);
            DenseDoubleMatrix2D curMem = DenseDoubleMatrix2D.factory.zeros((long)this.config.getRuns(), 1L);
            DenseDoubleMatrix2D bestMem = DenseDoubleMatrix2D.factory.zeros((long)this.config.getRuns(), 1L);
            int c = 0;
            while (!stopped && c < tmpTrialCount) {
                double t;
                BenchmarkResult r;
                long t0;
                System.out.print(String.valueOf(this.getTaskName()) + " [" + Coordinates.toString('x', size) + "] ");
                System.out.print(String.valueOf(c + 1) + "/" + tmpTrialCount + ": ");
                System.out.flush();
                int i = 0;
                while (!stopped && i < this.config.getBurnInRuns()) {
                    t0 = System.currentTimeMillis();
                    r = this.task(this.matrixClass, this.benchmarkSeed + (long)c, i, size);
                    t = r.getTime();
                    long t1 = System.currentTimeMillis();
                    if (t == 0.0 || Double.isNaN(t) || t1 - t0 > (long)this.config.getMaxTime()) {
                        stopped = true;
                    }
                    System.out.print("#");
                    System.out.flush();
                    ++i;
                }
                i = 0;
                while (!stopped && i < this.config.getRuns()) {
                    t0 = System.currentTimeMillis();
                    r = this.task(this.matrixClass, this.benchmarkSeed + (long)c, i, size);
                    t = r.getTime();
                    double diff = r.getDifference();
                    long mem = r.getMem();
                    long t1 = System.currentTimeMillis();
                    if (t == 0.0 || Double.isNaN(t) || t1 - t0 > (long)this.config.getMaxTime()) {
                        stopped = true;
                    }
                    curTime.setAsDouble(t, i, 0L);
                    curDiff.setAsDouble(diff, i, 0L);
                    curMem.setAsLong(mem, i, 0L);
                    System.out.print(".");
                    System.out.flush();
                    ++i;
                }
                double meanTime = curTime.getMeanValue();
                double meanDiff = curDiff.getMeanValue();
                double meanMem = curMem.getMeanValue();
                double stdTime = curTime.getStdValue();
                double percentStd = stdTime / meanTime * 100.0;
                System.out.print(" " + MathUtil.round(meanTime, 3) + "+-" + MathUtil.round(stdTime, 3) + "ms (+-" + MathUtil.round(percentStd, 1) + "%)");
                if (!MathUtil.isNaNOrInfinite(meanDiff)) {
                    System.out.print(" diff:" + meanDiff + " ");
                }
                System.out.print(" mem:" + (int)meanMem + " Bytes ");
                if (percentStd > this.config.getMaxStd()) {
                    System.out.print(" standard deviation too large, result discarded");
                    if (tmpTrialCount < this.config.getMaxTrialCount()) {
                        ++tmpTrialCount;
                    }
                }
                if (percentStd < bestStd) {
                    bestStd = percentStd;
                    int i2 = 0;
                    while (i2 < this.config.getRuns()) {
                        bestTime.setDouble(curTime.getDouble(i2, 0), i2, 0);
                        bestDiff.setDouble(curDiff.getDouble(i2, 0), i2, 0);
                        bestMem.setDouble(curMem.getDouble(i2, 0), i2, 0);
                        ++i2;
                    }
                }
                System.out.println();
                ++c;
            }
            int i = 0;
            while (!stopped && i < this.config.getRuns()) {
                resultTime.setAsDouble(bestTime.getDouble(i, 0), i, s2);
                resultDiff.setAsDouble(bestDiff.getDouble(i, 0), i, s2);
                resultMem.setAsDouble(bestMem.getDouble(i, 0), i, s2);
                ++i;
            }
            ++s2;
        }
        Matrix temp = MatrixFactory.vertCat(resultTime.getAnnotation().getDimensionMatrix(0), resultTime);
        Matrix diff = MatrixFactory.vertCat(resultDiff.getAnnotation().getDimensionMatrix(0), resultDiff);
        Matrix mem = MatrixFactory.vertCat(resultMem.getAnnotation().getDimensionMatrix(0), resultMem);
        try {
            temp.exportToFile(FileFormat.CSV, timeFile, new Object[0]);
            mem.exportToFile(FileFormat.CSV, memFile, new Object[0]);
            if (!diff.containsMissingValues()) {
                diff.exportToFile(FileFormat.CSV, diffFile, new Object[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public abstract BenchmarkResult task(Class<? extends Matrix> var1, long var2, int var4, long[] var5);

    public abstract String getTaskName();

    public String getMatrixLabel() {
        return this.matrixClass.getSimpleName();
    }
}

