/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.bigdecimalmatrix.impl;

import java.math.BigDecimal;
import java.util.Arrays;
import org.ujmp.core.Matrix;
import org.ujmp.core.bigdecimalmatrix.stub.AbstractDenseBigDecimalMatrix2D;
import org.ujmp.core.exceptions.MatrixException;

public class ArrayDenseBigDecimalMatrix2D
extends AbstractDenseBigDecimalMatrix2D {
    private static final long serialVersionUID = 5701752483223767209L;
    private BigDecimal[][] values = null;

    public ArrayDenseBigDecimalMatrix2D(Matrix m) throws MatrixException {
        if (m instanceof ArrayDenseBigDecimalMatrix2D) {
            BigDecimal[][] v = ((ArrayDenseBigDecimalMatrix2D)m).values;
            this.values = new BigDecimal[v.length][v[0].length];
            int r = v.length;
            while (--r >= 0) {
                int c = v[0].length;
                while (--c >= 0) {
                    this.values[r][c] = v[r][c];
                }
            }
        } else {
            this.values = new BigDecimal[(int)m.getRowCount()][(int)m.getColumnCount()];
            for (long[] c : m.allCoordinates()) {
                this.setAsBigDecimal(m.getAsBigDecimal(c), c);
            }
        }
    }

    public ArrayDenseBigDecimalMatrix2D(BigDecimal[] ... v) {
        this.values = v;
    }

    public ArrayDenseBigDecimalMatrix2D(long ... size) {
        this.values = new BigDecimal[(int)size[0]][(int)size[1]];
        int r = this.values.length;
        while (--r != -1) {
            Arrays.fill(this.values[r], BigDecimal.ZERO);
        }
    }

    public ArrayDenseBigDecimalMatrix2D(BigDecimal ... v) {
        this.values = new BigDecimal[v.length][1];
        int r = v.length;
        while (--r >= 0) {
            this.values[r][0] = v[r];
        }
    }

    public long[] getSize() {
        return new long[]{this.values.length, this.values.length == 0 ? 0 : this.values[0].length};
    }

    public long getRowCount() {
        return this.values.length;
    }

    public long getColumnCount() {
        return this.values.length == 0 ? 0 : this.values[0].length;
    }

    public BigDecimal getBigDecimal(long row, long column) {
        return this.values[(int)row][(int)column];
    }

    public void setBigDecimal(BigDecimal value, long row, long column) {
        this.values[(int)row][(int)column] = value;
    }

    public BigDecimal getBigDecimal(int row, int column) {
        return this.values[row][column];
    }

    public void setBigDecimal(BigDecimal value, int row, int column) {
        this.values[row][column] = value;
    }
}

