/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.calculation;

import org.ujmp.core.Matrix;
import org.ujmp.core.calculation.MtimesCalculation;
import org.ujmp.core.matrix.SparseMatrix;
import org.ujmp.core.util.VerifyUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MtimesSparseMatrix1
implements MtimesCalculation<SparseMatrix, Matrix, Matrix> {
    MtimesSparseMatrix1() {
    }

    @Override
    public final void calc(SparseMatrix source1, Matrix source2, Matrix target) {
        VerifyUtil.assert2D(source1);
        VerifyUtil.assert2D(source2);
        VerifyUtil.assert2D(target);
        VerifyUtil.assertEquals(source1.getColumnCount(), source2.getRowCount(), "matrices have wrong sizes");
        VerifyUtil.assertEquals(target.getRowCount(), source1.getRowCount(), "matrices have wrong sizes");
        VerifyUtil.assertEquals(target.getColumnCount(), source2.getColumnCount(), "matrices have wrong sizes");
        target.clear();
        for (long[] c1 : source1.availableCoordinates()) {
            double v1 = source1.getAsDouble(c1);
            if (v1 == 0.0) continue;
            long col2 = source2.getColumnCount();
            while (--col2 != -1L) {
                double v2 = source2.getAsDouble(c1[1], col2);
                double temp = v1 * v2;
                if (temp == 0.0) continue;
                double v3 = target.getAsDouble(c1[0], col2);
                target.setAsDouble(v3 + temp, c1[0], col2);
            }
        }
    }
}

