/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.collections;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.interfaces.Wrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetToListWrapper<A>
implements Wrapper<Set<A>>,
List<A>,
Serializable {
    private static final long serialVersionUID = 4170885424845593802L;
    private Set<A> set = null;

    public SetToListWrapper(Set<A> set) {
        this.set = set;
    }

    @Override
    public Set<A> getWrappedObject() {
        return this.set;
    }

    @Override
    public void setWrappedObject(Set<A> object) {
        this.set = object;
    }

    @Override
    public boolean add(A e) {
        return this.set.add(e);
    }

    @Override
    public void add(int index, A element) {
        throw new MatrixException("not implemented");
    }

    @Override
    public boolean addAll(Collection<? extends A> c) {
        return this.set.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends A> c) {
        throw new MatrixException("not implemented");
    }

    @Override
    public void clear() {
        this.set.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.set.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.set.containsAll(c);
    }

    @Override
    public A get(int index) {
        Iterator<A> it = this.set.iterator();
        int i = 0;
        while (i < index && it.hasNext()) {
            it.next();
            ++i;
        }
        if (it.hasNext()) {
            return it.next();
        }
        return null;
    }

    @Override
    public int indexOf(Object o) {
        Iterator<A> it = this.set.iterator();
        int i = 0;
        while (it.hasNext()) {
            A a = it.next();
            if (o.equals(a)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    @Override
    public Iterator<A> iterator() {
        return this.set.iterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.indexOf(o);
    }

    @Override
    public ListIterator<A> listIterator() {
        throw new MatrixException("not implemented");
    }

    @Override
    public ListIterator<A> listIterator(int index) {
        throw new MatrixException("not implemented");
    }

    @Override
    public boolean remove(Object o) {
        return this.set.remove(o);
    }

    @Override
    public A remove(int index) {
        throw new MatrixException("not implemented");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.set.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.set.retainAll(c);
    }

    @Override
    public A set(int index, A element) {
        throw new MatrixException("not implemented");
    }

    @Override
    public int size() {
        return this.set.size();
    }

    @Override
    public List<A> subList(int fromIndex, int toIndex) {
        throw new MatrixException("not implemented");
    }

    @Override
    public Object[] toArray() {
        return this.set.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.set.toArray(a);
    }

    public String toString() {
        return this.set.toString();
    }
}

