/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.io;

import java.io.File;
import java.lang.ref.SoftReference;
import org.ujmp.core.Matrix;
import org.ujmp.core.MatrixFactory;
import org.ujmp.core.enums.FileFormat;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.objectmatrix.stub.AbstractObjectMatrix;

class DelayedContentMatrix
extends AbstractObjectMatrix {
    private static final long serialVersionUID = -2594340094573426876L;
    private SoftReference<Matrix> matrix = null;
    private FileFormat fileformat = null;
    private File file = null;
    private Object[] parameters = null;

    public DelayedContentMatrix(FileFormat fileformat, File file, Object ... parameters) {
        this.fileformat = fileformat;
        this.file = file;
        this.parameters = parameters;
    }

    public Object getObject(long ... coordinates) throws MatrixException {
        return this.getMatrix().getAsObject(coordinates);
    }

    private Matrix getMatrix() {
        if (this.matrix == null || this.matrix.get() == null) {
            try {
                this.matrix = new SoftReference<Matrix>(MatrixFactory.importFromFile(this.fileformat, this.file, this.parameters));
            }
            catch (Exception e) {
                return MatrixFactory.emptyMatrix();
            }
        }
        return this.matrix.get();
    }

    public void setObject(Object value, long ... coordinates) {
        this.getMatrix().setAsObject(value, coordinates);
    }

    public boolean contains(long ... coordinates) throws MatrixException {
        return this.getMatrix().contains(coordinates);
    }

    public long[] getSize() {
        return this.getMatrix().getSize();
    }

    public final Matrix.StorageType getStorageType() {
        return this.getMatrix().getStorageType();
    }
}

