/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.io;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.ujmp.core.Matrix;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.util.io.IntelligentFileWriter;

public abstract class ExportMatrixSPARSECSV {
    private static String separator = "\t";

    public static void toFile(File file, Matrix matrix, Object ... parameters) throws IOException, MatrixException {
        IntelligentFileWriter writer = new IntelligentFileWriter(file);
        ExportMatrixSPARSECSV.toWriter(writer, matrix, parameters);
        writer.close();
    }

    public static void toStream(OutputStream outputStream, Matrix matrix, Object ... parameters) throws IOException, MatrixException {
        OutputStreamWriter writer = new OutputStreamWriter(outputStream);
        ExportMatrixSPARSECSV.toWriter(writer, matrix, parameters);
        writer.close();
    }

    public static void toWriter(Writer writer, Matrix matrix, Object ... parameters) throws IOException, MatrixException {
        String lineend = System.getProperty("line.separator");
        for (long[] c : matrix.availableCoordinates()) {
            writer.append(String.valueOf(c[0]) + separator);
            writer.append(String.valueOf(c[1]) + separator);
            writer.append(String.valueOf(matrix.getAsString(c)) + lineend);
        }
    }
}

