/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.objectmatrix.calculation;

import org.ujmp.core.Coordinates;
import org.ujmp.core.Matrix;
import org.ujmp.core.annotation.Annotation;
import org.ujmp.core.annotation.DefaultAnnotation;
import org.ujmp.core.calculation.Calculation;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.objectmatrix.calculation.AbstractObjectCalculation;

public class ExtractAnnotation
extends AbstractObjectCalculation {
    private static final long serialVersionUID = 1461447576658284276L;
    private long[] size = null;

    public ExtractAnnotation(Matrix m, int dim) {
        super(dim, m);
        this.size = Coordinates.copyOf(m.getSize());
        int n = dim;
        this.size[n] = this.size[n] - 1L;
        this.setAnnotation(new DefaultAnnotation(this.size));
        this.getAnnotation().setMatrixAnnotation(m.getMatrixAnnotation());
        if (dim == 0) {
            Annotation a = m.getAnnotation();
            if (a != null) {
                Matrix ai = a.getDimensionMatrix(1);
                ai = ai.deleteRows(Calculation.Ret.NEW, 0L);
                this.getAnnotation().setDimensionMatrix(1, ai);
            }
            this.getAnnotation().setDimensionMatrix(0, m.selectRows(Calculation.Ret.NEW, 0L));
        } else if (dim == 1) {
            Annotation a = m.getAnnotation();
            if (a != null) {
                Matrix ai = a.getDimensionMatrix(0);
                ai = ai.selectColumns(Calculation.Ret.NEW, 0L);
                this.getAnnotation().setDimensionMatrix(0, ai);
            }
            this.getAnnotation().setDimensionMatrix(1, m.selectColumns(Calculation.Ret.NEW, 0L));
        } else {
            throw new MatrixException("only supported for 2D matrices");
        }
    }

    public Object getObject(long ... coordinates) throws MatrixException {
        coordinates = Coordinates.copyOf(coordinates);
        int n = this.getDimension();
        coordinates[n] = coordinates[n] + 1L;
        return this.getSource().getAsObject(coordinates);
    }

    public long[] getSize() {
        return this.size;
    }
}

