/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.shortmatrix.impl;

import org.ujmp.core.Matrix;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.shortmatrix.stub.AbstractDenseShortMatrix2D;

public class SimpleDenseShortMatrix2D
extends AbstractDenseShortMatrix2D {
    private static final long serialVersionUID = 4034565357457805099L;
    private short[][] values = null;

    public SimpleDenseShortMatrix2D(Matrix m) throws MatrixException {
        if (m instanceof SimpleDenseShortMatrix2D) {
            short[][] v = ((SimpleDenseShortMatrix2D)m).values;
            this.values = new short[v.length][v[0].length];
            int r = v.length;
            while (--r >= 0) {
                int c = v[0].length;
                while (--c >= 0) {
                    this.values[r][c] = v[r][c];
                }
            }
        } else {
            this.values = new short[(int)m.getRowCount()][(int)m.getColumnCount()];
            for (long[] c : m.allCoordinates()) {
                this.setAsShort(m.getAsShort(c), c);
            }
        }
    }

    public SimpleDenseShortMatrix2D(short[] ... v) {
        this.values = v;
    }

    public SimpleDenseShortMatrix2D(long ... size) {
        this.values = new short[(int)size[0]][(int)size[1]];
    }

    public long[] getSize() {
        return new long[]{this.values.length, this.values.length == 0 ? 0 : this.values[0].length};
    }

    public long getRowCount() {
        return this.values.length;
    }

    public long getColumnCount() {
        return this.values.length == 0 ? 0 : this.values[0].length;
    }

    public short getShort(long row, long column) {
        return this.values[(int)row][(int)column];
    }

    public void setShort(short value, long row, long column) {
        this.values[(int)row][(int)column] = value;
    }

    public final Matrix transpose() {
        short[][] result = new short[this.values[0].length][this.values.length];
        int r = result.length;
        while (--r >= 0) {
            int c = result[0].length;
            while (--c >= 0) {
                result[r][c] = this.values[c][r];
            }
        }
        return new SimpleDenseShortMatrix2D(result);
    }
}

