/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.util.matrices;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ujmp.core.Matrix;
import org.ujmp.core.calculation.Calculation;
import org.ujmp.core.enums.FileFormat;
import org.ujmp.core.stringmatrix.impl.DefaultDenseStringMatrix2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatrixLibraries
extends DefaultDenseStringMatrix2D {
    private static final long serialVersionUID = -2575195318248762416L;
    public static final int LABELCOLUMN = 0;
    public static final int VERSION = 1;
    public static final int DATE = 2;
    public static final int LICENCE = 3;
    public static final int JAVA14 = 4;
    public static final int JAVA5 = 5;
    public static final int JAVA6 = 6;
    public static final int DENSESA = 7;
    public static final int DENSEAA = 8;
    public static final int DENSEBLOCK = 9;
    public static final int SPARSEDOK = 10;
    public static final int SPARSELIL = 11;
    public static final int SPARSEYALE = 12;
    public static final int SPARSECRS = 13;
    public static final int SPARSECDS = 14;
    public static final int DOUBLE = 15;
    public static final int FLOAT = 16;
    public static final int BIGDECIMAL = 17;
    public static final int COMPLEX = 18;
    public static final int D2 = 19;
    public static final int D3 = 20;
    public static final int D3PLUS = 21;
    public static final int MULTITHREADED = 22;
    public static final int INPLACE = 23;
    public static final int CACHEDRESULTS = 24;
    public static final int TRANSPOSE = 25;
    public static final int SCALE = 26;
    public static final int PLUSMINUS = 27;
    public static final int INV = 28;
    public static final int SOLVE = 29;
    public static final int LU = 30;
    public static final int QR = 31;
    public static final int SVD = 32;
    public static final int CHOL = 33;
    public static final int EIG = 34;
    public static final int PACKAGE = 35;
    public static final int LABELROW = 0;
    public static final int ARRAY4J = 1;
    public static final int COLT = 2;
    public static final int COMMONSMATH = 3;
    public static final int EJML = 4;
    public static final int JAMA = 5;
    public static final int JAMPACK = 6;
    public static final int JBLAS = 7;
    public static final int JLINALG = 8;
    public static final int JMATHARRAY = 9;
    public static final int JMATRICES = 10;
    public static final int JSCI = 11;
    public static final int JSCIENCE = 12;
    public static final int MANTISSA = 13;
    public static final int MTJ = 14;
    public static final int OJALGO = 15;
    public static final int ORBITAL = 16;
    public static final int OWLPACK = 17;
    public static final int PARALLELCOLT = 18;
    public static final int SST = 19;
    public static final int UJMP = 20;
    public static final int VECMATH = 21;
    public static final String NONSINGULARLETTER = "n";
    public static final String NONSINGULARTEXT = "non-singular matrices only";
    public static final String ERRORTEXT = "error in implementation";
    private List<String> footnotes = new ArrayList<String>();
    private MatrixLibrariesFormat format = MatrixLibrariesFormat.DEFAULT;

    public MatrixLibraries() {
        this(MatrixLibrariesFormat.DEFAULT);
    }

    public MatrixLibraries(MatrixLibrariesFormat format) {
        super(36L, 22L);
        this.format = format;
        this.setAsString(this.turn("Array4J"), 0L, 1L);
        this.setAsString(this.turn("Colt"), 0L, 2L);
        this.setAsString(this.turn("commons-math"), 0L, 3L);
        this.setAsString(this.turn("EJML"), 0L, 4L);
        this.setAsString(this.turn("JAMA"), 0L, 5L);
        this.setAsString(this.turn("Jampack"), 0L, 6L);
        this.setAsString(this.turn("JBlas"), 0L, 7L);
        this.setAsString(this.turn("JLinAlg"), 0L, 8L);
        this.setAsString(this.turn("JMathArray"), 0L, 9L);
        this.setAsString(this.turn("JMatrices"), 0L, 10L);
        this.setAsString(this.turn("JSci"), 0L, 11L);
        this.setAsString(this.turn("JScience"), 0L, 12L);
        this.setAsString(this.turn("Mantissa"), 0L, 13L);
        this.setAsString(this.turn("MTJ"), 0L, 14L);
        this.setAsString(this.turn("ojAlgo"), 0L, 15L);
        this.setAsString(this.turn("Orbital"), 0L, 16L);
        this.setAsString(this.turn("OWLPack"), 0L, 17L);
        this.setAsString(this.turn("Parallel Colt"), 0L, 18L);
        this.setAsString(this.turn("SST"), 0L, 19L);
        this.setAsString(this.turn("UJMP"), 0L, 20L);
        this.setAsString(this.turn("vecmath"), 0L, 21L);
        this.setAsString("version", 1L, 0L);
        this.setAsString("release", 2L, 0L);
        this.setAsString("licence", 3L, 0L);
        this.setAsString("Java 1.4", 4L, 0L);
        this.setAsString("Java 5", 5L, 0L);
        this.setAsString("Java 6", 6L, 0L);
        this.setAsString("multithreaded", 22L, 0L);
        this.setAsString("in-place ops", 23L, 0L);
        this.setAsString("cached results", 24L, 0L);
        this.setAsString("dense SA" + this.footnote("1", "single array"), 7L, 0L);
        this.setAsString("dense AA" + this.footnote("2", "array of arrays"), 8L, 0L);
        this.setAsString("dense block", 9L, 0L);
        this.setAsString("sparse DOK" + this.footnote("3", "dictionary of key-value pairs"), 10L, 0L);
        this.setAsString("sparse LIL" + this.footnote("4", "list of lists"), 11L, 0L);
        this.setAsString("sparse CSR" + this.footnote("5", "compressed sparse row/column"), 13L, 0L);
        this.setAsString("sparse CDS" + this.footnote("6", "compressed sparse diagonal"), 14L, 0L);
        this.setAsString("sparse Yale", 12L, 0L);
        this.setAsString("complex", 18L, 0L);
        this.setAsString("double", 15L, 0L);
        this.setAsString("float", 16L, 0L);
        this.setAsString("BigDecimal", 17L, 0L);
        this.setAsString("2D", 19L, 0L);
        this.setAsString("3D", 20L, 0L);
        this.setAsString("$>$3D", 21L, 0L);
        this.setAsString("transpose", 25L, 0L);
        this.setAsString("scale", 26L, 0L);
        this.setAsString("plus/minus", 27L, 0L);
        this.setAsString("inverse", 28L, 0L);
        this.setAsString("solve", 29L, 0L);
        this.setAsString("SVD", 32L, 0L);
        this.setAsString("LU", 30L, 0L);
        this.setAsString("QR", 31L, 0L);
        this.setAsString("Cholesky", 33L, 0L);
        this.setAsString("Eigen", 34L, 0L);
        this.setAsString("package", 35L, 0L);
        this.setAsString("0.2.5", 1L, 20L);
        this.setAsString(this.small("2010"), 2L, 20L);
        this.setAsString(this.small("LGPL"), 3L, 20L);
        this.setAsString(this.notSupported(), 4L, 20L);
        this.setAsString(this.yes(), 5L, 20L);
        this.setAsString(this.yes(), 6L, 20L);
        this.setAsString(this.both(), 22L, 20L);
        this.setAsString(this.yes(), 23L, 20L);
        this.setAsString(this.notSupported(), 24L, 20L);
        this.setAsString(this.yes(), 8L, 20L);
        this.setAsString(this.yes(), 7L, 20L);
        this.setAsString(this.yes(), 9L, 20L);
        this.setAsString(this.yes(), 10L, 20L);
        this.setAsString(this.notSupported(), 12L, 20L);
        this.setAsString(this.yes(), 11L, 20L);
        this.setAsString(this.notSupported(), 13L, 20L);
        this.setAsString(this.notSupported(), 14L, 20L);
        this.setAsString(this.notSupported(), 18L, 20L);
        this.setAsString(this.yes(), 15L, 20L);
        this.setAsString(this.yes(), 16L, 20L);
        this.setAsString(this.yes(), 17L, 20L);
        this.setAsString(this.yes(), 19L, 20L);
        this.setAsString(this.yes(), 20L, 20L);
        this.setAsString(this.yes(), 21L, 20L);
        this.setAsString(this.yes(), 25L, 20L);
        this.setAsString(this.yes(), 26L, 20L);
        this.setAsString(this.yes(), 27L, 20L);
        this.setAsString(this.yes(), 28L, 20L);
        this.setAsString(this.squareTall(), 29L, 20L);
        this.setAsString(this.yes(), 33L, 20L);
        this.setAsString(this.yes(), 34L, 20L);
        this.setAsString(this.all(), 30L, 20L);
        this.setAsString(this.squareTall(), 31L, 20L);
        this.setAsString(this.all(), 32L, 20L);
        this.setAsString("org.ujmp.core", 35L, 20L);
        this.setAsString(this.small("SVN"), 1L, 1L);
        this.setAsString(this.small("2008"), 2L, 1L);
        this.setAsString(this.small("BSD"), 3L, 1L);
        this.setAsString(this.notSupported(), 4L, 1L);
        this.setAsString(this.notSupported(), 5L, 1L);
        this.setAsString(this.yes(), 6L, 1L);
        this.setAsString(String.valueOf(this.unknown()) + this.footnote("m", "using native machine code"), 22L, 1L);
        this.setAsString(this.yes(), 23L, 1L);
        this.setAsString(this.yes(), 7L, 1L);
        this.setAsString(this.notSupported(), 8L, 1L);
        this.setAsString(this.notSupported(), 9L, 1L);
        this.setAsString(String.valueOf(this.notSupported()) + this.footnote("i", "interface only, no implementation"), 10L, 1L);
        this.setAsString(String.valueOf(this.notSupported()) + this.footnote("i", "interface only, no implementation"), 12L, 1L);
        this.setAsString(String.valueOf(this.notSupported()) + this.footnote("i", "interface only, no implementation"), 11L, 1L);
        this.setAsString(String.valueOf(this.notSupported()) + this.footnote("i", "interface only, no implementation"), 13L, 1L);
        this.setAsString(String.valueOf(this.notSupported()) + this.footnote("i", "interface only, no implementation"), 14L, 1L);
        this.setAsString(String.valueOf(this.notSupported()) + this.footnote("i", "interface only, no implementation"), 18L, 1L);
        this.setAsString(String.valueOf(this.notSupported()) + this.footnote("i", "interface only, no implementation"), 15L, 1L);
        this.setAsString(this.yes(), 16L, 1L);
        this.setAsString(this.notSupported(), 17L, 1L);
        this.setAsString(this.notSupported(), 22L, 1L);
        this.setAsString(this.yes(), 23L, 1L);
        this.setAsString(this.notSupported(), 24L, 1L);
        this.setAsString(this.yes(), 27L, 1L);
        this.setAsString(this.yes(), 26L, 1L);
        this.setAsString(this.yes(), 25L, 1L);
        this.setAsString(this.yes(), 19L, 1L);
        this.setAsString(this.notSupported(), 20L, 1L);
        this.setAsString(this.notSupported(), 21L, 1L);
        this.setAsString(this.notSupported(), 29L, 1L);
        this.setAsString(this.notSupported(), 28L, 1L);
        this.setAsString(this.notSupported(), 32L, 1L);
        this.setAsString(this.notSupported(), 31L, 1L);
        this.setAsString(this.notSupported(), 30L, 1L);
        this.setAsString(this.notSupported(), 34L, 1L);
        this.setAsString(this.notSupported(), 33L, 1L);
        this.setAsString(this.notSupported(), 35L, 1L);
        this.setAsString(this.small("1.2.0"), 1L, 2L);
        this.setAsString(this.small("2004"), 2L, 2L);
        this.setAsString(this.small("BSD"), 3L, 2L);
        this.setAsString(this.yes(), 4L, 2L);
        this.setAsString(this.yes(), 5L, 2L);
        this.setAsString(this.yes(), 6L, 2L);
        this.setAsString(this.notSupported(), 22L, 2L);
        this.setAsString(this.yes(), 23L, 2L);
        this.setAsString(this.notSupported(), 24L, 2L);
        this.setAsString(String.valueOf(this.yes()) + this.footnote("f", "flags matrix as transposed"), 25L, 2L);
        this.setAsString(this.yes(), 26L, 2L);
        this.setAsString(this.yes(), 27L, 2L);
        this.setAsString(this.yes(), 7L, 2L);
        this.setAsString(this.notSupported(), 8L, 2L);
        this.setAsString(this.notSupported(), 9L, 2L);
        this.setAsString(this.yes(), 10L, 2L);
        this.setAsString(this.notSupported(), 12L, 2L);
        this.setAsString(this.notSupported(), 11L, 2L);
        this.setAsString(this.notSupported(), 13L, 2L);
        this.setAsString(this.notSupported(), 14L, 2L);
        this.setAsString(this.notSupported(), 18L, 2L);
        this.setAsString(this.yes(), 15L, 2L);
        this.setAsString(this.notSupported(), 16L, 2L);
        this.setAsString(this.notSupported(), 17L, 2L);
        this.setAsString(this.yes(), 19L, 2L);
        this.setAsString(this.yes(), 20L, 2L);
        this.setAsString(this.notSupported(), 21L, 2L);
        this.setAsString(this.yes(), 28L, 2L);
        this.setAsString(this.squareTall(), 29L, 2L);
        this.setAsString(this.all(), 32L, 2L);
        this.setAsString(this.squareTall(), 30L, 2L);
        this.setAsString(this.squareTall(), 31L, 2L);
        this.setAsString(this.yes(), 34L, 2L);
        this.setAsString(this.yes(), 33L, 2L);
        this.setAsString("org.ujmp.colt", 35L, 2L);
        this.setAsString(this.small("2.1"), 1L, 3L);
        this.setAsString(this.small("2010"), 2L, 3L);
        this.setAsString(this.small("Apache"), 3L, 3L);
        this.setAsString(this.notSupported(), 4L, 3L);
        this.setAsString(this.yes(), 5L, 3L);
        this.setAsString(this.yes(), 6L, 3L);
        this.setAsString(this.notSupported(), 22L, 3L);
        this.setAsString(this.yes(), 23L, 3L);
        this.setAsString(this.notSupported(), 24L, 3L);
        this.setAsString(this.yes(), 25L, 3L);
        this.setAsString(this.yes(), 26L, 3L);
        this.setAsString(this.yes(), 27L, 3L);
        this.setAsString(this.yes(), 8L, 3L);
        this.setAsString(this.notSupported(), 7L, 3L);
        this.setAsString(this.yes(), 9L, 3L);
        this.setAsString(this.yes(), 10L, 3L);
        this.setAsString(this.notSupported(), 12L, 3L);
        this.setAsString(this.notSupported(), 11L, 3L);
        this.setAsString(this.notSupported(), 13L, 3L);
        this.setAsString(this.notSupported(), 14L, 3L);
        this.setAsString(this.yes(), 18L, 3L);
        this.setAsString(this.yes(), 15L, 3L);
        this.setAsString(this.notSupported(), 16L, 3L);
        this.setAsString(this.yes(), 17L, 3L);
        this.setAsString(this.yes(), 19L, 3L);
        this.setAsString(this.notSupported(), 20L, 3L);
        this.setAsString(this.notSupported(), 21L, 3L);
        this.setAsString(this.yes(), 28L, 3L);
        this.setAsString(this.squareTall(), 29L, 3L);
        this.setAsString(this.all(), 32L, 3L);
        this.setAsString(String.valueOf(this.square()) + this.footnote(NONSINGULARLETTER, NONSINGULARTEXT), 30L, 3L);
        this.setAsString(this.all(), 31L, 3L);
        this.setAsString(String.valueOf(this.yes()) + this.footnote("s", "symmetric matrices only"), 34L, 3L);
        this.setAsString(this.yes(), 33L, 3L);
        this.setAsString("org.ujmp.commonsmath", 35L, 3L);
        this.setAsString(this.small("0.12"), 1L, 4L);
        this.setAsString(this.small("2010"), 2L, 4L);
        this.setAsString(this.small("LGPL"), 3L, 4L);
        this.setAsString(this.notSupported(), 4L, 4L);
        this.setAsString(this.notSupported(), 5L, 4L);
        this.setAsString(this.yes(), 6L, 4L);
        this.setAsString(this.notSupported(), 22L, 4L);
        this.setAsString(this.notSupported(), 24L, 4L);
        this.setAsString(this.yes(), 23L, 4L);
        this.setAsString(this.yes(), 7L, 4L);
        this.setAsString(this.notSupported(), 8L, 4L);
        this.setAsString(this.yes(), 9L, 4L);
        this.setAsString(this.notSupported(), 10L, 4L);
        this.setAsString(this.notSupported(), 12L, 4L);
        this.setAsString(this.notSupported(), 11L, 4L);
        this.setAsString(this.notSupported(), 13L, 4L);
        this.setAsString(this.notSupported(), 14L, 4L);
        this.setAsString(this.notSupported(), 18L, 4L);
        this.setAsString(this.yes(), 15L, 4L);
        this.setAsString(this.notSupported(), 16L, 4L);
        this.setAsString(this.notSupported(), 17L, 4L);
        this.setAsString(this.yes(), 19L, 4L);
        this.setAsString(this.notSupported(), 20L, 4L);
        this.setAsString(this.notSupported(), 21L, 4L);
        this.setAsString(this.yes(), 25L, 4L);
        this.setAsString(this.yes(), 26L, 4L);
        this.setAsString(this.yes(), 27L, 4L);
        this.setAsString(this.yes(), 28L, 4L);
        this.setAsString(this.squareTall(), 29L, 4L);
        this.setAsString(this.all(), 32L, 4L);
        this.setAsString(this.all(), 30L, 4L);
        this.setAsString(this.square(), 31L, 4L);
        this.setAsString(this.yes(), 34L, 4L);
        this.setAsString(this.yes(), 33L, 4L);
        this.setAsString("org.ujmp.ejml", 35L, 4L);
        this.setAsString(this.small("1.0.2"), 1L, 5L);
        this.setAsString(this.small("2005"), 2L, 5L);
        this.setAsString(this.small("PD"), 3L, 5L);
        this.setAsString(this.yes(), 4L, 5L);
        this.setAsString(this.yes(), 5L, 5L);
        this.setAsString(this.yes(), 6L, 5L);
        this.setAsString(this.notSupported(), 22L, 5L);
        this.setAsString(this.notSupported(), 23L, 5L);
        this.setAsString(this.notSupported(), 24L, 5L);
        this.setAsString(this.yes(), 8L, 5L);
        this.setAsString(this.notSupported(), 7L, 5L);
        this.setAsString(this.notSupported(), 9L, 5L);
        this.setAsString(this.notSupported(), 10L, 5L);
        this.setAsString(this.notSupported(), 12L, 5L);
        this.setAsString(this.notSupported(), 11L, 5L);
        this.setAsString(this.notSupported(), 13L, 5L);
        this.setAsString(this.notSupported(), 14L, 5L);
        this.setAsString(this.notSupported(), 18L, 5L);
        this.setAsString(this.yes(), 15L, 5L);
        this.setAsString(this.notSupported(), 16L, 5L);
        this.setAsString(this.notSupported(), 17L, 5L);
        this.setAsString(this.yes(), 19L, 5L);
        this.setAsString(this.notSupported(), 20L, 5L);
        this.setAsString(this.notSupported(), 21L, 5L);
        this.setAsString(this.yes(), 25L, 5L);
        this.setAsString(this.yes(), 26L, 5L);
        this.setAsString(this.yes(), 27L, 5L);
        this.setAsString(this.yes(), 28L, 5L);
        this.setAsString(this.squareTall(), 29L, 5L);
        this.setAsString(this.squareTall(), 32L, 5L);
        this.setAsString(this.squareTall(), 30L, 5L);
        this.setAsString(this.squareTall(), 31L, 5L);
        this.setAsString(this.yes(), 34L, 5L);
        this.setAsString(this.yes(), 33L, 5L);
        this.setAsString("org.ujmp.jama", 35L, 5L);
        this.setAsString(this.small("?"), 1L, 6L);
        this.setAsString(this.small("1999"), 2L, 6L);
        this.setAsString(this.small("?"), 3L, 6L);
        this.setAsString(this.yes(), 4L, 6L);
        this.setAsString(this.yes(), 5L, 6L);
        this.setAsString(this.yes(), 6L, 6L);
        this.setAsString(this.notSupported(), 22L, 6L);
        this.setAsString(this.notSupported(), 23L, 6L);
        this.setAsString(this.yes(), 8L, 6L);
        this.setAsString(this.notSupported(), 7L, 6L);
        this.setAsString(this.notSupported(), 9L, 6L);
        this.setAsString(this.notSupported(), 10L, 6L);
        this.setAsString(this.notSupported(), 12L, 6L);
        this.setAsString(this.notSupported(), 11L, 6L);
        this.setAsString(this.notSupported(), 13L, 6L);
        this.setAsString(this.notSupported(), 14L, 6L);
        this.setAsString(this.yes(), 18L, 6L);
        this.setAsString(this.yes(), 15L, 6L);
        this.setAsString(this.notSupported(), 16L, 6L);
        this.setAsString(this.notSupported(), 17L, 6L);
        this.setAsString(this.yes(), 19L, 6L);
        this.setAsString(this.notSupported(), 20L, 6L);
        this.setAsString(this.notSupported(), 21L, 6L);
        this.setAsString(this.yes(), 24L, 6L);
        this.setAsString(this.yes(), 25L, 6L);
        this.setAsString(this.yes(), 27L, 6L);
        this.setAsString(this.yes(), 26L, 6L);
        this.setAsString(this.yes(), 28L, 6L);
        this.setAsString(this.square(), 29L, 6L);
        this.setAsString(this.square(), 32L, 6L);
        this.setAsString(this.all(), 30L, 6L);
        this.setAsString(this.all(), 31L, 6L);
        this.setAsString(this.yes(), 34L, 6L);
        this.setAsString(String.valueOf(this.yes()) + this.footnote("e", ERRORTEXT), 33L, 6L);
        this.setAsString("org.ujmp.jampack", 35L, 6L);
        this.setAsString(this.small("1.0.2"), 1L, 7L);
        this.setAsString(this.small("2010"), 2L, 7L);
        this.setAsString(this.small("BSD"), 3L, 7L);
        this.setAsString(this.notSupported(), 4L, 7L);
        this.setAsString(this.yes(), 5L, 7L);
        this.setAsString(this.yes(), 6L, 7L);
        this.setAsString(String.valueOf(this.yes()) + this.footnote("m", "using native machine code"), 22L, 7L);
        this.setAsString(this.yes(), 23L, 7L);
        this.setAsString(this.notSupported(), 24L, 7L);
        this.setAsString(this.yes(), 7L, 7L);
        this.setAsString(this.notSupported(), 8L, 7L);
        this.setAsString(this.notSupported(), 9L, 7L);
        this.setAsString(this.notSupported(), 10L, 7L);
        this.setAsString(this.notSupported(), 12L, 7L);
        this.setAsString(this.notSupported(), 11L, 7L);
        this.setAsString(this.notSupported(), 13L, 7L);
        this.setAsString(this.notSupported(), 14L, 7L);
        this.setAsString(this.yes(), 18L, 7L);
        this.setAsString(this.yes(), 15L, 7L);
        this.setAsString(this.yes(), 16L, 7L);
        this.setAsString(this.notSupported(), 17L, 7L);
        this.setAsString(this.yes(), 19L, 7L);
        this.setAsString(this.notSupported(), 20L, 7L);
        this.setAsString(this.notSupported(), 21L, 7L);
        this.setAsString(this.yes(), 25L, 7L);
        this.setAsString(this.yes(), 26L, 7L);
        this.setAsString(this.yes(), 27L, 7L);
        this.setAsString(this.yes(), 28L, 7L);
        this.setAsString(this.square(), 29L, 7L);
        this.setAsString(this.notSupported(), 32L, 7L);
        this.setAsString(this.all(), 30L, 7L);
        this.setAsString(this.notSupported(), 31L, 7L);
        this.setAsString(String.valueOf(this.yes()) + this.footnote("s", "symmetric matrices only"), 34L, 7L);
        this.setAsString(this.yes(), 33L, 7L);
        this.setAsString("org.ujmp.jblas", 35L, 7L);
        this.setAsString(this.small("0.6"), 1L, 8L);
        this.setAsString(this.small("2009"), 2L, 8L);
        this.setAsString(this.small("GPL"), 3L, 8L);
        this.setAsString(this.notSupported(), 4L, 8L);
        this.setAsString(this.notSupported(), 5L, 8L);
        this.setAsString(this.yes(), 6L, 8L);
        this.setAsString(this.notSupported(), 22L, 8L);
        this.setAsString(this.notSupported(), 24L, 8L);
        this.setAsString(this.yes(), 23L, 8L);
        this.setAsString(this.yes(), 8L, 8L);
        this.setAsString(this.notSupported(), 7L, 8L);
        this.setAsString(this.notSupported(), 9L, 8L);
        this.setAsString(this.notSupported(), 10L, 8L);
        this.setAsString(this.notSupported(), 12L, 8L);
        this.setAsString(this.notSupported(), 11L, 8L);
        this.setAsString(this.notSupported(), 13L, 8L);
        this.setAsString(this.notSupported(), 14L, 8L);
        this.setAsString(this.yes(), 18L, 8L);
        this.setAsString(this.yes(), 15L, 8L);
        this.setAsString(this.notSupported(), 16L, 8L);
        this.setAsString(this.yes(), 17L, 8L);
        this.setAsString(this.yes(), 25L, 8L);
        this.setAsString(this.yes(), 26L, 8L);
        this.setAsString(this.yes(), 27L, 8L);
        this.setAsString(this.yes(), 19L, 8L);
        this.setAsString(this.notSupported(), 20L, 8L);
        this.setAsString(this.notSupported(), 21L, 8L);
        this.setAsString(this.yes(), 28L, 8L);
        this.setAsString(String.valueOf(this.notSupported()) + this.footnote("v", "only for $A \\cdot X = \\mbox{vector}$"), 29L, 8L);
        this.setAsString(this.notSupported(), 32L, 8L);
        this.setAsString(this.notSupported(), 30L, 8L);
        this.setAsString(this.notSupported(), 31L, 8L);
        this.setAsString(this.notSupported(), 34L, 8L);
        this.setAsString(this.notSupported(), 33L, 8L);
        this.setAsString("org.ujmp.jlinalg", 35L, 8L);
        this.setAsString(this.small("?"), 1L, 9L);
        this.setAsString(this.small("2009"), 2L, 9L);
        this.setAsString(this.small("BSD"), 3L, 9L);
        this.setAsString(this.notSupported(), 4L, 9L);
        this.setAsString(this.yes(), 5L, 9L);
        this.setAsString(this.yes(), 6L, 9L);
        this.setAsString(this.notSupported(), 22L, 9L);
        this.setAsString(this.notSupported(), 23L, 9L);
        this.setAsString(this.notSupported(), 24L, 9L);
        this.setAsString(this.yes(), 25L, 9L);
        this.setAsString(this.yes(), 26L, 9L);
        this.setAsString(this.yes(), 27L, 9L);
        this.setAsString(this.yes(), 8L, 9L);
        this.setAsString(this.notSupported(), 7L, 9L);
        this.setAsString(this.notSupported(), 9L, 9L);
        this.setAsString(this.notSupported(), 10L, 9L);
        this.setAsString(this.notSupported(), 12L, 9L);
        this.setAsString(this.notSupported(), 11L, 9L);
        this.setAsString(this.notSupported(), 13L, 9L);
        this.setAsString(this.notSupported(), 14L, 9L);
        this.setAsString(this.notSupported(), 18L, 9L);
        this.setAsString(this.yes(), 15L, 9L);
        this.setAsString(this.notSupported(), 16L, 9L);
        this.setAsString(this.notSupported(), 17L, 9L);
        this.setAsString(this.yes(), 19L, 9L);
        this.setAsString(this.notSupported(), 20L, 9L);
        this.setAsString(this.notSupported(), 21L, 9L);
        this.setAsString(this.yes(), 28L, 9L);
        this.setAsString(this.squareTall(), 29L, 9L);
        this.setAsString(this.squareTall(), 32L, 9L);
        this.setAsString(this.squareTall(), 30L, 9L);
        this.setAsString(this.squareTall(), 31L, 9L);
        this.setAsString(this.yes(), 34L, 9L);
        this.setAsString(this.yes(), 33L, 9L);
        this.setAsString("org.ujmp.jmatharray", 35L, 9L);
        this.setAsString(this.small("0.6"), 1L, 10L);
        this.setAsString(this.small("2004"), 2L, 10L);
        this.setAsString(this.small("LGPL"), 3L, 10L);
        this.setAsString(this.yes(), 4L, 10L);
        this.setAsString(this.yes(), 5L, 10L);
        this.setAsString(this.yes(), 6L, 10L);
        this.setAsString(this.notSupported(), 22L, 10L);
        this.setAsString(this.notSupported(), 23L, 10L);
        this.setAsString(this.notSupported(), 24L, 10L);
        this.setAsString(this.yes(), 8L, 10L);
        this.setAsString(this.notSupported(), 7L, 10L);
        this.setAsString(this.notSupported(), 9L, 10L);
        this.setAsString(this.notSupported(), 10L, 10L);
        this.setAsString(this.notSupported(), 12L, 10L);
        this.setAsString(this.notSupported(), 11L, 10L);
        this.setAsString(this.notSupported(), 13L, 10L);
        this.setAsString(this.notSupported(), 14L, 10L);
        this.setAsString(this.yes(), 18L, 10L);
        this.setAsString(this.yes(), 15L, 10L);
        this.setAsString(this.notSupported(), 16L, 10L);
        this.setAsString(this.yes(), 17L, 10L);
        this.setAsString(this.yes(), 19L, 10L);
        this.setAsString(this.notSupported(), 20L, 10L);
        this.setAsString(this.notSupported(), 21L, 10L);
        this.setAsString(this.yes(), 25L, 10L);
        this.setAsString(this.yes(), 27L, 10L);
        this.setAsString(this.yes(), 26L, 10L);
        this.setAsString(this.yes(), 28L, 10L);
        this.setAsString(this.squareTall(), 29L, 10L);
        this.setAsString(this.square(), 32L, 10L);
        this.setAsString(this.squareTall(), 30L, 10L);
        this.setAsString(this.squareTall(), 31L, 10L);
        this.setAsString(this.yes(), 34L, 10L);
        this.setAsString(this.yes(), 33L, 10L);
        this.setAsString("org.ujmp.jmatrices", 35L, 10L);
        this.setAsString(this.small("1.1"), 1L, 11L);
        this.setAsString(this.small("2009"), 2L, 11L);
        this.setAsString(this.small("LGPL"), 3L, 11L);
        this.setAsString(this.yes(), 4L, 11L);
        this.setAsString(this.yes(), 5L, 11L);
        this.setAsString(this.yes(), 6L, 11L);
        this.setAsString(this.notSupported(), 22L, 11L);
        this.setAsString(this.notSupported(), 23L, 11L);
        this.setAsString(this.notSupported(), 24L, 11L);
        this.setAsString(this.yes(), 8L, 11L);
        this.setAsString(this.notSupported(), 7L, 11L);
        this.setAsString(this.notSupported(), 9L, 11L);
        this.setAsString(this.yes(), 12L, 11L);
        this.setAsString(this.notSupported(), 10L, 11L);
        this.setAsString(this.notSupported(), 11L, 11L);
        this.setAsString(this.notSupported(), 13L, 11L);
        this.setAsString(this.notSupported(), 14L, 11L);
        this.setAsString(this.yes(), 18L, 11L);
        this.setAsString(this.yes(), 15L, 11L);
        this.setAsString(this.notSupported(), 16L, 11L);
        this.setAsString(this.notSupported(), 17L, 11L);
        this.setAsString(this.yes(), 19L, 11L);
        this.setAsString(this.notSupported(), 20L, 11L);
        this.setAsString(this.notSupported(), 21L, 11L);
        this.setAsString(this.yes(), 25L, 11L);
        this.setAsString(this.yes(), 27L, 11L);
        this.setAsString(this.yes(), 26L, 11L);
        this.setAsString(String.valueOf(this.notSupported()) + this.footnote("v", "only for $A \\cdot X = \\mbox{vector}$"), 29L, 11L);
        this.setAsString(this.yes(), 28L, 11L);
        this.setAsString(this.square(), 32L, 11L);
        this.setAsString(String.valueOf(this.square()) + this.footnote(NONSINGULARLETTER, NONSINGULARTEXT), 30L, 11L);
        this.setAsString(this.square(), 31L, 11L);
        this.setAsString(String.valueOf(this.yes()) + this.footnote("s", "symmetric matrices only") + this.footnote("a", "results not directly accessible"), 34L, 11L);
        this.setAsString(this.yes(), 33L, 11L);
        this.setAsString("org.ujmp.jsci", 35L, 11L);
        this.setAsString(this.small("4.3.1"), 1L, 12L);
        this.setAsString(this.small("2007"), 2L, 12L);
        this.setAsString(this.small("BSD"), 3L, 12L);
        this.setAsString(this.notSupported(), 4L, 12L);
        this.setAsString(this.yes(), 5L, 12L);
        this.setAsString(this.yes(), 6L, 12L);
        this.setAsString(this.yes(), 22L, 12L);
        this.setAsString(this.notSupported(), 23L, 12L);
        this.setAsString(this.notSupported(), 24L, 12L);
        this.setAsString(this.yes(), 8L, 12L);
        this.setAsString(this.notSupported(), 9L, 12L);
        this.setAsString(this.notSupported(), 7L, 12L);
        this.setAsString(this.yes(), 11L, 12L);
        this.setAsString(this.notSupported(), 12L, 12L);
        this.setAsString(this.notSupported(), 14L, 12L);
        this.setAsString(this.notSupported(), 13L, 12L);
        this.setAsString(this.yes(), 10L, 12L);
        this.setAsString(this.yes(), 18L, 12L);
        this.setAsString(this.yes(), 15L, 12L);
        this.setAsString(this.notSupported(), 16L, 12L);
        this.setAsString(this.notSupported(), 17L, 12L);
        this.setAsString(this.yes(), 19L, 12L);
        this.setAsString(this.notSupported(), 20L, 12L);
        this.setAsString(this.notSupported(), 21L, 12L);
        this.setAsString(String.valueOf(this.yes()) + this.footnote("f", "flags matrix as transposed"), 25L, 12L);
        this.setAsString(this.yes(), 26L, 12L);
        this.setAsString(this.yes(), 27L, 12L);
        this.setAsString(this.yes(), 28L, 12L);
        this.setAsString(this.square(), 29L, 12L);
        this.setAsString(this.notSupported(), 32L, 12L);
        this.setAsString(String.valueOf(this.square()) + this.footnote(NONSINGULARLETTER, NONSINGULARTEXT), 30L, 12L);
        this.setAsString(this.notSupported(), 31L, 12L);
        this.setAsString(this.notSupported(), 34L, 12L);
        this.setAsString(this.notSupported(), 33L, 12L);
        this.setAsString("org.ujmp.jscience", 35L, 12L);
        this.setAsString(this.small("7.2"), 1L, 13L);
        this.setAsString(this.small("2007"), 2L, 13L);
        this.setAsString(this.small("BSD"), 3L, 13L);
        this.setAsString(this.yes(), 4L, 13L);
        this.setAsString(this.yes(), 5L, 13L);
        this.setAsString(this.yes(), 6L, 13L);
        this.setAsString(this.notSupported(), 22L, 13L);
        this.setAsString(this.notSupported(), 24L, 13L);
        this.setAsString(this.yes(), 23L, 13L);
        this.setAsString(this.yes(), 25L, 13L);
        this.setAsString(this.yes(), 27L, 13L);
        this.setAsString(this.yes(), 26L, 13L);
        this.setAsString(this.yes(), 7L, 13L);
        this.setAsString(this.notSupported(), 8L, 13L);
        this.setAsString(this.notSupported(), 9L, 13L);
        this.setAsString(this.notSupported(), 10L, 13L);
        this.setAsString(this.notSupported(), 12L, 13L);
        this.setAsString(this.notSupported(), 11L, 13L);
        this.setAsString(this.notSupported(), 13L, 13L);
        this.setAsString(this.notSupported(), 14L, 13L);
        this.setAsString(this.notSupported(), 18L, 13L);
        this.setAsString(this.yes(), 15L, 13L);
        this.setAsString(this.notSupported(), 16L, 13L);
        this.setAsString(this.notSupported(), 17L, 13L);
        this.setAsString(this.yes(), 19L, 13L);
        this.setAsString(this.notSupported(), 20L, 13L);
        this.setAsString(this.notSupported(), 21L, 13L);
        this.setAsString(this.yes(), 28L, 13L);
        this.setAsString(this.square(), 29L, 13L);
        this.setAsString(this.notSupported(), 32L, 13L);
        this.setAsString(String.valueOf(this.square()) + this.footnote("a", "results not directly accessible"), 30L, 13L);
        this.setAsString(this.notSupported(), 31L, 13L);
        this.setAsString(this.notSupported(), 34L, 13L);
        this.setAsString(this.notSupported(), 33L, 13L);
        this.setAsString("org.ujmp.mantissa", 35L, 13L);
        this.setAsString(this.small("0.9.12"), 1L, 14L);
        this.setAsString(this.small("2009"), 2L, 14L);
        this.setAsString(this.small("LGPL"), 3L, 14L);
        this.setAsString(this.notSupported(), 4L, 14L);
        this.setAsString(this.yes(), 5L, 14L);
        this.setAsString(this.yes(), 6L, 14L);
        this.setAsString(String.valueOf(this.yes()) + this.footnote("m", "using native machine code"), 22L, 14L);
        this.setAsString(this.yes(), 23L, 14L);
        this.setAsString(this.notSupported(), 24L, 14L);
        this.setAsString(this.yes(), 7L, 14L);
        this.setAsString(this.notSupported(), 8L, 14L);
        this.setAsString(this.notSupported(), 9L, 14L);
        this.setAsString(this.yes(), 13L, 14L);
        this.setAsString(this.yes(), 14L, 14L);
        this.setAsString(this.yes(), 11L, 14L);
        this.setAsString(this.notSupported(), 10L, 14L);
        this.setAsString(this.notSupported(), 12L, 14L);
        this.setAsString(this.notSupported(), 18L, 14L);
        this.setAsString(this.yes(), 15L, 14L);
        this.setAsString(this.notSupported(), 16L, 14L);
        this.setAsString(this.notSupported(), 17L, 14L);
        this.setAsString(this.yes(), 19L, 14L);
        this.setAsString(this.notSupported(), 20L, 14L);
        this.setAsString(this.notSupported(), 21L, 14L);
        this.setAsString(this.yes(), 25L, 14L);
        this.setAsString(this.yes(), 26L, 14L);
        this.setAsString(this.yes(), 27L, 14L);
        this.setAsString(this.yes(), 28L, 14L);
        this.setAsString(this.squareTall(), 29L, 14L);
        this.setAsString(this.all(), 32L, 14L);
        this.setAsString(String.valueOf(this.all()) + this.footnote("e", ERRORTEXT), 30L, 14L);
        this.setAsString(this.squareTall(), 31L, 14L);
        this.setAsString(String.valueOf(this.yes()) + this.footnote("s", "symmetric matrices only"), 34L, 14L);
        this.setAsString(String.valueOf(this.yes()) + this.footnote("e", ERRORTEXT), 33L, 14L);
        this.setAsString("org.ujmp.mtj", 35L, 14L);
        this.setAsString(this.small("29.8"), 1L, 15L);
        this.setAsString(this.small("2010"), 2L, 15L);
        this.setAsString(this.small("MIT"), 3L, 15L);
        this.setAsString(this.notSupported(), 4L, 15L);
        this.setAsString(this.yes(), 5L, 15L);
        this.setAsString(this.yes(), 6L, 15L);
        this.setAsString(this.both(), 22L, 15L);
        this.setAsString(this.yes(), 23L, 15L);
        this.setAsString(this.notSupported(), 24L, 15L);
        this.setAsString(String.valueOf(this.yes()) + this.footnote("f", "flags matrix as transposed"), 25L, 15L);
        this.setAsString(this.yes(), 26L, 15L);
        this.setAsString(this.yes(), 27L, 15L);
        this.setAsString(this.yes(), 7L, 15L);
        this.setAsString(this.notSupported(), 8L, 15L);
        this.setAsString(this.notSupported(), 9L, 15L);
        this.setAsString(this.notSupported(), 14L, 15L);
        this.setAsString(this.notSupported(), 13L, 15L);
        this.setAsString(this.notSupported(), 12L, 15L);
        this.setAsString(this.notSupported(), 11L, 15L);
        this.setAsString(this.notSupported(), 10L, 15L);
        this.setAsString(this.yes(), 18L, 15L);
        this.setAsString(this.yes(), 15L, 15L);
        this.setAsString(this.yes(), 16L, 15L);
        this.setAsString(this.yes(), 17L, 15L);
        this.setAsString(this.yes(), 19L, 15L);
        this.setAsString(this.notSupported(), 20L, 15L);
        this.setAsString(this.notSupported(), 21L, 15L);
        this.setAsString(this.yes(), 28L, 15L);
        this.setAsString(this.squareTall(), 29L, 15L);
        this.setAsString(this.all(), 32L, 15L);
        this.setAsString(this.all(), 30L, 15L);
        this.setAsString(this.all(), 31L, 15L);
        this.setAsString(this.yes(), 34L, 15L);
        this.setAsString(this.yes(), 33L, 15L);
        this.setAsString("org.ujmp.ojalgo", 35L, 15L);
        this.setAsString(this.small("1.3.0"), 1L, 16L);
        this.setAsString(this.small("2009"), 2L, 16L);
        this.setAsString(this.small("custom"), 3L, 16L);
        this.setAsString(this.yes(), 4L, 16L);
        this.setAsString(this.yes(), 5L, 16L);
        this.setAsString(this.yes(), 6L, 16L);
        this.setAsString(this.notSupported(), 22L, 16L);
        this.setAsString(this.notSupported(), 23L, 16L);
        this.setAsString(this.notSupported(), 24L, 16L);
        this.setAsString(this.yes(), 7L, 16L);
        this.setAsString(this.yes(), 8L, 16L);
        this.setAsString(this.notSupported(), 9L, 16L);
        this.setAsString(this.notSupported(), 14L, 16L);
        this.setAsString(this.notSupported(), 13L, 16L);
        this.setAsString(this.notSupported(), 10L, 16L);
        this.setAsString(this.notSupported(), 11L, 16L);
        this.setAsString(this.notSupported(), 12L, 16L);
        this.setAsString(this.yes(), 18L, 16L);
        this.setAsString(this.yes(), 15L, 16L);
        this.setAsString(this.notSupported(), 16L, 16L);
        this.setAsString(this.notSupported(), 17L, 16L);
        this.setAsString(this.yes(), 25L, 16L);
        this.setAsString(this.yes(), 27L, 16L);
        this.setAsString(this.yes(), 26L, 16L);
        this.setAsString(this.yes(), 19L, 16L);
        this.setAsString(this.yes(), 20L, 16L);
        this.setAsString(this.yes(), 21L, 16L);
        this.setAsString(this.yes(), 28L, 16L);
        this.setAsString(this.notSupported(), 32L, 16L);
        this.setAsString(String.valueOf(this.notSupported()) + this.footnote("v", "only for $A \\cdot X = \\mbox{vector}$"), 29L, 16L);
        this.setAsString(String.valueOf(this.square()) + this.footnote(NONSINGULARLETTER, NONSINGULARTEXT), 30L, 16L);
        this.setAsString(this.notSupported(), 31L, 16L);
        this.setAsString(this.notSupported(), 34L, 16L);
        this.setAsString(this.notSupported(), 33L, 16L);
        this.setAsString("org.ujmp.orbital", 35L, 16L);
        this.setAsString(this.unknown(), 1L, 17L);
        this.setAsString(this.small("1999"), 2L, 17L);
        this.setAsString(this.unknown(), 3L, 17L);
        this.setAsString(this.yes(), 4L, 17L);
        this.setAsString(this.yes(), 5L, 17L);
        this.setAsString(this.yes(), 6L, 17L);
        this.setAsString(this.notSupported(), 22L, 17L);
        this.setAsString(this.yes(), 23L, 17L);
        this.setAsString(this.notSupported(), 24L, 17L);
        this.setAsString(this.yes(), 8L, 17L);
        this.setAsString(this.notSupported(), 7L, 17L);
        this.setAsString(this.notSupported(), 9L, 17L);
        this.setAsString(this.notSupported(), 14L, 17L);
        this.setAsString(this.notSupported(), 13L, 17L);
        this.setAsString(this.notSupported(), 12L, 17L);
        this.setAsString(this.notSupported(), 10L, 17L);
        this.setAsString(this.notSupported(), 11L, 17L);
        this.setAsString(this.yes(), 18L, 17L);
        this.setAsString(this.yes(), 15L, 17L);
        this.setAsString(this.yes(), 16L, 17L);
        this.setAsString(this.notSupported(), 17L, 17L);
        this.setAsString(this.yes(), 25L, 17L);
        this.setAsString(this.yes(), 27L, 17L);
        this.setAsString(this.yes(), 26L, 17L);
        this.setAsString(this.yes(), 19L, 17L);
        this.setAsString(this.notSupported(), 20L, 17L);
        this.setAsString(this.notSupported(), 21L, 17L);
        this.setAsString(String.valueOf(this.notSupported()) + this.footnote("v", "only for $A \\cdot X = \\mbox{vector}$"), 29L, 17L);
        this.setAsString(String.valueOf(this.yes()) + this.footnote("e", ERRORTEXT), 28L, 17L);
        this.setAsString(String.valueOf(this.circle()) + this.footnote("e", ERRORTEXT), 32L, 17L);
        this.setAsString(this.notSupported(), 30L, 17L);
        this.setAsString(String.valueOf(this.circle()) + this.footnote("u", "unuseable without documentation"), 31L, 17L);
        this.setAsString(this.notSupported(), 34L, 17L);
        this.setAsString(this.notSupported(), 33L, 17L);
        this.setAsString("org.ujmp.owlpack", 35L, 17L);
        this.setAsString(this.small("0.9.4"), 1L, 18L);
        this.setAsString(this.small("2010"), 2L, 18L);
        this.setAsString(this.small("BSD"), 3L, 18L);
        this.setAsString(this.yes(), 4L, 18L);
        this.setAsString(this.yes(), 5L, 18L);
        this.setAsString(this.yes(), 6L, 18L);
        this.setAsString(this.both(), 22L, 18L);
        this.setAsString(this.yes(), 23L, 18L);
        this.setAsString(String.valueOf(this.yes()) + this.footnote("f", "flags matrix as transposed"), 25L, 18L);
        this.setAsString(this.yes(), 26L, 18L);
        this.setAsString(this.yes(), 27L, 18L);
        this.setAsString(this.notSupported(), 24L, 18L);
        this.setAsString(this.yes(), 7L, 18L);
        this.setAsString(this.yes(), 8L, 18L);
        this.setAsString(this.notSupported(), 9L, 18L);
        this.setAsString(this.yes(), 13L, 18L);
        this.setAsString(this.yes(), 11L, 18L);
        this.setAsString(this.yes(), 10L, 18L);
        this.setAsString(this.notSupported(), 12L, 18L);
        this.setAsString(this.notSupported(), 14L, 18L);
        this.setAsString(this.yes(), 18L, 18L);
        this.setAsString(this.yes(), 15L, 18L);
        this.setAsString(this.yes(), 16L, 18L);
        this.setAsString(this.notSupported(), 17L, 18L);
        this.setAsString(this.yes(), 19L, 18L);
        this.setAsString(this.yes(), 20L, 18L);
        this.setAsString(this.notSupported(), 21L, 18L);
        this.setAsString(this.yes(), 28L, 18L);
        this.setAsString(this.squareTall(), 29L, 18L);
        this.setAsString(this.all(), 32L, 18L);
        this.setAsString(this.squareTall(), 30L, 18L);
        this.setAsString(this.squareTall(), 31L, 18L);
        this.setAsString(this.yes(), 34L, 18L);
        this.setAsString(this.yes(), 33L, 18L);
        this.setAsString("org.ujmp.parallelcolt", 35L, 18L);
        this.setAsString(this.small("1.10"), 1L, 19L);
        this.setAsString(this.small("2009"), 2L, 19L);
        this.setAsString(this.small("LGPL"), 3L, 19L);
        this.setAsString(this.notSupported(), 4L, 19L);
        this.setAsString(String.valueOf(this.yes()) + this.footnote("j", "jar does not work with Java 5"), 5L, 19L);
        this.setAsString(this.yes(), 6L, 19L);
        this.setAsString(this.notSupported(), 22L, 19L);
        this.setAsString(this.yes(), 23L, 19L);
        this.setAsString(this.yes(), 25L, 19L);
        this.setAsString(this.yes(), 26L, 19L);
        this.setAsString(this.yes(), 27L, 19L);
        this.setAsString(this.notSupported(), 24L, 19L);
        this.setAsString(this.yes(), 7L, 19L);
        this.setAsString(this.notSupported(), 8L, 19L);
        this.setAsString(this.notSupported(), 9L, 19L);
        this.setAsString(this.yes(), 10L, 19L);
        this.setAsString(this.notSupported(), 11L, 19L);
        this.setAsString(this.notSupported(), 12L, 19L);
        this.setAsString(this.notSupported(), 14L, 19L);
        this.setAsString(this.notSupported(), 13L, 19L);
        this.setAsString(this.yes(), 18L, 19L);
        this.setAsString(this.yes(), 15L, 19L);
        this.setAsString(this.notSupported(), 16L, 19L);
        this.setAsString(this.notSupported(), 17L, 19L);
        this.setAsString(this.yes(), 19L, 19L);
        this.setAsString(this.yes(), 20L, 19L);
        this.setAsString(this.yes(), 21L, 19L);
        this.setAsString(this.yes(), 28L, 19L);
        this.setAsString(this.notSupported(), 29L, 19L);
        this.setAsString(this.all(), 32L, 19L);
        this.setAsString(this.notSupported(), 30L, 19L);
        this.setAsString(this.notSupported(), 31L, 19L);
        this.setAsString(this.yes(), 34L, 19L);
        this.setAsString(this.notSupported(), 33L, 19L);
        this.setAsString("org.ujmp.sst", 35L, 19L);
        this.setAsString(this.small("1.5.1"), 1L, 21L);
        this.setAsString(this.small("2007"), 2L, 21L);
        this.setAsString(this.small("other"), 3L, 21L);
        this.setAsString(this.notSupported(), 4L, 21L);
        this.setAsString(this.yes(), 5L, 21L);
        this.setAsString(this.yes(), 6L, 21L);
        this.setAsString(this.notSupported(), 22L, 21L);
        this.setAsString(this.yes(), 23L, 21L);
        this.setAsString(this.yes(), 25L, 21L);
        this.setAsString(this.notSupported(), 26L, 21L);
        this.setAsString(this.yes(), 27L, 21L);
        this.setAsString(this.notSupported(), 24L, 21L);
        this.setAsString(this.yes(), 8L, 21L);
        this.setAsString(this.notSupported(), 7L, 21L);
        this.setAsString(this.notSupported(), 9L, 21L);
        this.setAsString(this.notSupported(), 10L, 21L);
        this.setAsString(this.notSupported(), 11L, 21L);
        this.setAsString(this.notSupported(), 14L, 21L);
        this.setAsString(this.notSupported(), 13L, 21L);
        this.setAsString(this.notSupported(), 12L, 21L);
        this.setAsString(this.notSupported(), 18L, 21L);
        this.setAsString(this.yes(), 15L, 21L);
        this.setAsString(this.notSupported(), 16L, 21L);
        this.setAsString(this.notSupported(), 17L, 21L);
        this.setAsString(this.yes(), 19L, 21L);
        this.setAsString(this.notSupported(), 20L, 21L);
        this.setAsString(this.notSupported(), 21L, 21L);
        this.setAsString(this.yes(), 28L, 21L);
        this.setAsString(this.notSupported(), 29L, 21L);
        this.setAsString(String.valueOf(this.circle()) + this.footnote("e", ERRORTEXT), 32L, 21L);
        this.setAsString(String.valueOf(this.square()) + this.footnote(NONSINGULARLETTER, NONSINGULARTEXT), 30L, 21L);
        this.setAsString(this.notSupported(), 31L, 21L);
        this.setAsString(this.notSupported(), 34L, 21L);
        this.setAsString(this.notSupported(), 33L, 21L);
        this.setAsString("org.ujmp.vecmath", 35L, 21L);
    }

    public String yes() {
        switch (this.format) {
            case LATEX: {
                return "\\bf{$+$}";
            }
        }
        return "yes";
    }

    public String both() {
        switch (this.format) {
            case LATEX: {
                return "\\bf{$+/-$}";
            }
        }
        return "configurable";
    }

    public String all() {
        switch (this.format) {
            case LATEX: {
                return "\\scalebox{0.6}[1.0]{$\\square$}\\,$\\square$\\,\\scalebox{1.0}[0.6]{$\\square$}";
            }
        }
        return "all";
    }

    public String squareTall() {
        switch (this.format) {
            case LATEX: {
                return "\\scalebox{0.6}[1.0]{$\\square$}\\,$\\square$";
            }
        }
        return "square, tall";
    }

    public String square() {
        switch (this.format) {
            case LATEX: {
                return "$\\square$";
            }
        }
        return "square";
    }

    public String tall() {
        switch (this.format) {
            case LATEX: {
                return "$\\tall$";
            }
        }
        return "tall";
    }

    public String fat() {
        switch (this.format) {
            case LATEX: {
                return "$\\fat$";
            }
        }
        return "fat";
    }

    public String circle() {
        switch (this.format) {
            case LATEX: {
                return "$\\circ$";
            }
        }
        return "square";
    }

    public String notSupported() {
        switch (this.format) {
            case LATEX: {
                return "\\bf{$-$}";
            }
        }
        return "yes";
    }

    public String unknown() {
        return "?";
    }

    public String turn(String text) {
        switch (this.format) {
            case LATEX: {
                return "\\begin{turn}{90}" + text + "\\end{turn}";
            }
        }
        return "";
    }

    public String small(String text) {
        switch (this.format) {
            case LATEX: {
                return "\\small " + text;
            }
        }
        return text;
    }

    public String footnote(String footnote, String text) {
        switch (this.format) {
            case LATEX: {
                String f = "\\footnotesize{$^\\mathrm{" + footnote + "}$ " + text + "}";
                if (!this.footnotes.contains(f)) {
                    this.footnotes.add(f);
                }
                return "$^{\\mathrm{" + footnote + "}}$";
            }
        }
        String f = String.valueOf(footnote) + " " + text;
        if (!this.footnotes.contains(f)) {
            this.footnotes.add(f);
        }
        return text;
    }

    public List<String> getFootnotes() {
        return this.footnotes;
    }

    public static void main(String[] args) throws Exception {
        MatrixLibraries ml = new MatrixLibraries(MatrixLibrariesFormat.LATEX);
        Matrix m = ml.deleteRows(Calculation.Ret.NEW, ml.getRowCount() - 1L);
        String s = m.exportToString(FileFormat.TEX, new Object[0]);
        s = s.replaceAll("table", "sidewaystable");
        s = s.replaceAll("\\\\centering", "");
        s = s.replaceAll("\\\\toprule", "");
        s = s.replaceAll("\\\\begin\\{tabular\\}", "\\\\caption{Overview of matrix libraries in Java}\n\\\\bigskip\n\\\\begin{centering}\n\\\\scalebox{0.8}{%\n\\\\begin{tabular}");
        s = s.replaceAll("latest version", "\\\\toprule\nlatest version");
        s = s.replaceAll("\\\\end\\{sidewaystable\\}", "");
        s = s.replaceAll("\\\\end\\{tabular\\}", "\\\\end{tabular}}\n\\\\end{centering}");
        s = s.replaceAll("version &", "\\\\toprule\nversion &");
        s = s.replaceAll("Java 1.4 &", "\\\\midrule\nJava 1.4 &");
        s = s.replaceAll("multithreaded &", "\\\\midrule\nmultithreaded &");
        s = s.replaceAll("dense SA", "\\\\midrule\ndense SA");
        s = s.replaceAll("sparse DOK", "\\\\midrule\nsparse DOK");
        s = s.replaceAll("double &", "\\\\midrule\ndouble &");
        s = s.replaceAll("2D &", "\\\\midrule\n2D &");
        s = s.replaceAll("transpose &", "\\\\midrule\ntranspose &");
        s = s.replaceAll("inverse &", "\\\\midrule\ninverse &");
        s = String.valueOf(s) + "\\medskip\n";
        s = String.valueOf(s) + "\\begin{tabular}{p{0.25\\textwidth}p{0.25\\textwidth}p{0.25\\textwidth}p{0.25\\textwidth}}\n";
        s = String.valueOf(s) + "\\renewcommand{\\tabcolsep}{30pt}";
        List<String> fn = ml.getFootnotes();
        Collections.sort(fn);
        int i = 0;
        while (i < fn.size()) {
            String f = fn.get(i);
            s = String.valueOf(s) + f;
            s = i % 4 == 3 ? String.valueOf(s) + "\\\\\n" : String.valueOf(s) + " & ";
            ++i;
        }
        s = String.valueOf(s) + "\\end{tabular}\n";
        s = String.valueOf(s) + "\\end{sidewaystable}";
        System.out.println(s);
    }

    public long getColumnForPackage(String label) {
        long c = this.getColumnCount();
        while (--c != -1L) {
            String p = this.getAsString(35L, c);
            if (!label.equals(p)) continue;
            return c;
        }
        return -1L;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MatrixLibrariesFormat {
        DEFAULT,
        LATEX,
        HTML;

    }
}

