/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.util.matrices;

import java.util.ArrayList;
import java.util.List;
import org.ujmp.core.Matrix;
import org.ujmp.core.MatrixFactory;
import org.ujmp.core.enums.ValueType;
import org.ujmp.core.stringmatrix.stub.AbstractDenseStringMatrix2D;
import org.ujmp.core.util.AbstractPlugin;

public class UJMPPluginsMatrix
extends AbstractDenseStringMatrix2D {
    private static final long serialVersionUID = 9076856922668700140L;
    private final List<String> classes = new ArrayList<String>();
    private Matrix matrix = null;

    public UJMPPluginsMatrix() {
        this.addClass("ujmp-core");
        this.addClass("ujmp-gui");
        this.addClass("ujmp-colt");
        this.addClass("ujmp-commonsmath");
        this.addClass("ujmp-ehcache");
        this.addClass("ujmp-ejml");
        this.addClass("ujmp-hadoop");
        this.addClass("ujmp-itext");
        this.addClass("ujmp-jackcess");
        this.addClass("ujmp-jama");
        this.addClass("ujmp-jampack");
        this.addClass("ujmp-jblas");
        this.addClass("ujmp-jbpcafill");
        this.addClass("ujmp-jlinalg");
        this.addClass("ujmp-jdbc");
        this.addClass("ujmp-jexcelapi");
        this.addClass("ujmp-jfreechart");
        this.addClass("ujmp-jmatharray");
        this.addClass("ujmp-jmathplot");
        this.addClass("ujmp-jmatio");
        this.addClass("ujmp-jmatrices");
        this.addClass("ujmp-jsci");
        this.addClass("ujmp-jscience");
        this.addClass("ujmp-jung");
        this.addClass("ujmp-lsimpute");
        this.addClass("ujmp-lucene");
        this.addClass("ujmp-mail");
        this.addClass("ujmp-mantissa");
        this.addClass("ujmp-mtj");
        this.addClass("ujmp-ojalgo");
        this.addClass("ujmp-orbital");
        this.addClass("ujmp-owlpack");
        this.addClass("ujmp-parallelcolt");
        this.addClass("ujmp-pdfbox");
        this.addClass("ujmp-sst");
        this.addClass("ujmp-vecmath");
        this.refresh();
        this.setLabel("UJMP Plugins");
        this.setColumnLabel(0L, "Name");
        this.setColumnLabel(1L, "Available");
        this.setColumnLabel(2L, "Description");
        this.setColumnLabel(3L, "Dependencies");
        this.setColumnLabel(4L, "Status");
    }

    public void refresh() {
        this.matrix = MatrixFactory.dense(ValueType.STRING, this.classes.size(), 5L);
        int r = 0;
        for (String s : this.classes) {
            this.matrix.setAsString(s, r, 0L);
            Class<?> cl = null;
            if (s.startsWith("ujmp")) {
                try {
                    cl = Class.forName("org.ujmp." + s.substring(5) + ".Plugin");
                }
                catch (ClassNotFoundException classNotFoundException) {}
            } else {
                try {
                    cl = Class.forName("org.jdmp." + s.substring(5) + ".Plugin");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            AbstractPlugin o = null;
            if (cl != null) {
                try {
                    o = (AbstractPlugin)cl.newInstance();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (o != null) {
                try {
                    this.matrix.setAsString("yes", r, 1L);
                    this.matrix.setAsString(o.getDescription(), r, 2L);
                    this.matrix.setAsString("" + o.getDependencies(), r, 3L);
                    this.matrix.setAsString(o.getStatus(), r, 4L);
                }
                catch (Throwable t) {
                    this.matrix.setAsString("no", r, 1L);
                    this.matrix.setAsString("n/a", r, 2L);
                    this.matrix.setAsString("n/a", r, 3L);
                    this.matrix.setAsString(t.getMessage(), r, 4L);
                }
            } else {
                this.matrix.setAsString("no", r, 1L);
                this.matrix.setAsString("n/a", r, 2L);
                this.matrix.setAsString("n/a", r, 3L);
                this.matrix.setAsString("n/a", r, 4L);
            }
            ++r;
        }
    }

    protected void addClass(String c) {
        this.classes.add(c);
    }

    public String getString(long row, long column) {
        return this.matrix.getAsString(row, column);
    }

    public void setString(String value, long row, long column) {
    }

    public long[] getSize() {
        return this.matrix.getSize();
    }
}

