/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.lucene;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.Flushable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Version;
import org.ujmp.core.collections.AbstractMap;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.interfaces.Erasable;
import org.ujmp.core.util.StringUtil;
import org.ujmp.core.util.io.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneMap<K, V>
extends AbstractMap<K, V>
implements Flushable,
Closeable,
Erasable {
    private static final long serialVersionUID = 8998898900190996038L;
    private static final String KEYSTRING = "KS";
    private static final String KEYDATA = "KD";
    private static final String VALUESTRING = "VS";
    private static final String VALUEDATA = "VD";
    private transient Directory directory = null;
    private transient IndexWriter indexWriter = null;
    private transient IndexSearcher indexSearcher = null;
    private static final int MAXSIZE = 1000000;
    private static final int AUTOFLUSHCOUNT = 100000;
    private boolean readOnly = false;
    private transient File path = null;
    private transient Analyzer analyzer = null;
    private int count = 0;

    public LuceneMap() throws IOException {
        this(null, false);
    }

    public LuceneMap(File dir) throws IOException {
        this(dir, false);
    }

    public LuceneMap(File path, boolean readOnly) throws IOException {
        this.readOnly = readOnly;
        this.path = path;
    }

    public Directory getDirectory() throws IOException {
        if (this.directory == null) {
            this.directory = FSDirectory.open((File)this.getPath());
        }
        return this.directory;
    }

    public File getPath() throws IOException {
        if (this.path == null) {
            this.path = File.createTempFile("lucene", "");
            this.path.delete();
            this.path.mkdir();
        }
        return this.path;
    }

    public synchronized void optimize() throws CorruptIndexException, IOException {
        this.getIndexWriter().optimize();
    }

    @Override
    public synchronized void clear() {
        try {
            this.getIndexWriter().deleteAll();
        }
        catch (Exception e) {
            throw new MatrixException("cannot clear index", e);
        }
    }

    @Override
    public synchronized boolean containsKey(Object key) {
        try {
            Term term = new Term(KEYSTRING, LuceneMap.getUniqueString(key));
            return this.getIndexSearcher().docFreq(term) > 0;
        }
        catch (Exception e) {
            throw new MatrixException("could not search documents: " + key, e);
        }
    }

    @Override
    public synchronized boolean containsValue(Object value) {
        try {
            Term term = new Term(VALUESTRING, LuceneMap.getUniqueString(value));
            return this.getIndexSearcher().docFreq(term) > 0;
        }
        catch (Exception e) {
            throw new MatrixException("could not search documents: " + value, e);
        }
    }

    @Override
    public synchronized V get(Object key) {
        try {
            Term term = new Term(KEYSTRING, LuceneMap.getUniqueString(key));
            TermQuery query = new TermQuery(term);
            TopDocs docs = this.getIndexSearcher().search((Query)query, 1);
            if (docs.totalHits > 0) {
                ScoreDoc match = docs.scoreDocs[0];
                Document doc = this.getIndexSearcher().doc(match.doc);
                return this.getObjectFromBytes(doc.getBinaryValue(VALUEDATA));
            }
        }
        catch (Exception e) {
            throw new MatrixException("could not search documents: " + key, e);
        }
        return null;
    }

    private V getObjectFromBytes(byte[] bytes) {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = new ObjectInputStream(bis);
            Object o = ois.readObject();
            ois.close();
            bis.close();
            return (V)o;
        }
        catch (Exception e) {
            throw new MatrixException("could not convert to object", e);
        }
    }

    @Override
    public synchronized Set<K> keySet() {
        HashSet<V> set = new HashSet<V>();
        if (this.isEmpty()) {
            return set;
        }
        try {
            Term term = new Term(KEYSTRING, "*");
            WildcardQuery query = new WildcardQuery(term);
            TopDocs docs = this.getIndexSearcher().search((Query)query, 1000000);
            ScoreDoc[] scoreDocArray = docs.scoreDocs;
            int n = docs.scoreDocs.length;
            int n2 = 0;
            while (n2 < n) {
                ScoreDoc sd = scoreDocArray[n2];
                Document d = this.getIndexSearcher().doc(sd.doc);
                set.add(this.getObjectFromBytes(d.getBinaryValue(KEYDATA)));
                ++n2;
            }
            return set;
        }
        catch (Exception e) {
            throw new MatrixException("could not search documents", e);
        }
    }

    private static String getUniqueString(Object o) throws IOException {
        if (o == null) {
            return "";
        }
        if (o instanceof String) {
            return (String)o;
        }
        return StringUtil.encodeToHex((Serializable)o);
    }

    @Override
    public synchronized V put(K key, V value) {
        block2: {
            try {
                Term term = new Term(KEYSTRING, LuceneMap.getUniqueString(key));
                Document doc = new Document();
                doc.add((Fieldable)new Field(KEYSTRING, LuceneMap.getUniqueString(key), Field.Store.YES, Field.Index.NOT_ANALYZED));
                doc.add((Fieldable)new Field(KEYDATA, this.getBytes(key), Field.Store.YES));
                doc.add((Fieldable)new Field(VALUESTRING, LuceneMap.getUniqueString(value), Field.Store.YES, Field.Index.NOT_ANALYZED));
                doc.add((Fieldable)new Field(VALUEDATA, this.getBytes(value), Field.Store.YES));
                this.getIndexWriter().updateDocument(term, doc);
                if (++this.count % 100000 != 0) break block2;
                this.flush();
            }
            catch (Exception e) {
                throw new MatrixException("could not add document: " + key, e);
            }
        }
        return null;
    }

    @Override
    public synchronized V remove(Object key) {
        block2: {
            try {
                Term term = new Term(KEYSTRING, LuceneMap.getUniqueString(key));
                this.getIndexWriter().deleteDocuments(term);
                if (++this.count % 100000 != 0) break block2;
                this.flush();
            }
            catch (Exception e) {
                throw new MatrixException("could not delete document: " + key, e);
            }
        }
        return null;
    }

    public Analyzer getAnalyzer() {
        if (this.analyzer == null) {
            this.analyzer = new StandardAnalyzer(Version.LUCENE_CURRENT);
        }
        return this.analyzer;
    }

    public void setAnalyzer(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    @Override
    public synchronized int size() {
        try {
            this.flush();
            if (this.indexSearcher != null && this.indexSearcher.getIndexReader().isCurrent()) {
                return this.indexSearcher.getIndexReader().numDocs();
            }
            int size = this.getIndexWriter().numDocs();
            return size;
        }
        catch (Exception e) {
            throw new MatrixException("could not count documents", e);
        }
    }

    @Override
    public synchronized void flush() throws IOException {
        IndexWriter iw = this.getIndexWriter();
        iw.expungeDeletes(true);
        iw.commit();
        iw.close(true);
        this.indexWriter = null;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.indexSearcher != null) {
            this.indexSearcher.close();
            this.indexSearcher = null;
        }
        if (this.indexWriter != null) {
            this.indexWriter.close(true);
            this.indexWriter = null;
        }
    }

    private synchronized IndexWriter getIndexWriter() {
        try {
            if (!this.readOnly && this.indexSearcher != null) {
                this.indexSearcher.close();
                this.indexSearcher = null;
            }
            if (this.indexWriter == null) {
                if (IndexReader.indexExists((Directory)this.getDirectory())) {
                    if (!this.readOnly) {
                        if (IndexWriter.isLocked((Directory)this.getDirectory())) {
                            IndexWriter.unlock((Directory)this.getDirectory());
                        }
                        this.indexWriter = new IndexWriter(this.getDirectory(), this.getAnalyzer(), IndexWriter.MaxFieldLength.UNLIMITED);
                    }
                } else if (!this.readOnly) {
                    this.indexWriter = new IndexWriter(this.getDirectory(), this.getAnalyzer(), true, IndexWriter.MaxFieldLength.UNLIMITED);
                }
            }
            return this.indexWriter;
        }
        catch (Exception e) {
            throw new MatrixException("could not prepare writher", e);
        }
    }

    private synchronized IndexSearcher getIndexSearcher() {
        try {
            if (!IndexReader.indexExists((Directory)this.getDirectory())) {
                this.getIndexWriter();
            }
            if (this.indexWriter != null) {
                if (this.indexSearcher != null) {
                    this.indexSearcher.close();
                    this.indexSearcher = null;
                }
                this.indexWriter.commit();
                this.indexWriter.waitForMerges();
                this.indexWriter.expungeDeletes(true);
                this.indexWriter.close();
                this.indexWriter = null;
            }
            if (this.indexSearcher != null && !this.indexSearcher.getIndexReader().isCurrent()) {
                this.indexSearcher.close();
                this.indexSearcher = null;
            }
            if (this.indexSearcher == null) {
                this.indexSearcher = new IndexSearcher(this.directory, true);
            }
            return this.indexSearcher;
        }
        catch (Exception e) {
            throw new MatrixException("could not prepare reader", e);
        }
    }

    private byte[] getBytes(Object o) {
        try {
            ByteArrayOutputStream bao = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bao);
            oos.writeObject(o);
            oos.close();
            bao.close();
            return bao.toByteArray();
        }
        catch (Exception e) {
            throw new MatrixException("could not convert to bytes: " + o, e);
        }
    }

    @Override
    public synchronized void erase() throws IOException {
        this.close();
        FileUtil.deleteRecursive(this.path);
    }
}

