/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.functor;

import de.intarsys.tools.functor.Declaration;
import de.intarsys.tools.functor.DeclarationException;
import de.intarsys.tools.functor.EmptyDeclarationBlock;
import de.intarsys.tools.functor.IDeclaration;
import de.intarsys.tools.functor.IDeclarationBlock;
import de.intarsys.tools.functor.IFunctorCall;

public class DeclarationBlock
extends Declaration
implements IDeclarationBlock {
    public static final IDeclarationBlock EMPTY = new EmptyDeclarationBlock();
    private IDeclaration[] declarations;

    public DeclarationBlock(Object declarationContext) {
        super(declarationContext);
        this.declarations = new IDeclaration[0];
    }

    public DeclarationBlock(Object declarationContext, IDeclaration[] declarations) {
        super(declarationContext);
        this.declarations = declarations;
    }

    public IFunctorCall accept(IFunctorCall call) throws DeclarationException {
        IFunctorCall result = call;
        int i = 0;
        while (i < this.declarations.length) {
            IDeclaration declaration = this.declarations[i];
            result = declaration.accept(result);
            ++i;
        }
        return result;
    }

    public void addDeclaration(IDeclaration declaration) {
        IDeclaration[] newDeclarations = new IDeclaration[this.declarations.length + 1];
        System.arraycopy(this.declarations, 0, newDeclarations, 0, this.declarations.length);
        newDeclarations[this.declarations.length] = declaration;
        this.declarations = newDeclarations;
    }

    public IDeclaration[] getDeclarations() {
        return this.declarations;
    }

    public boolean isBlock() {
        return true;
    }

    public boolean removeDeclaration(IDeclaration declaration) {
        int i = 0;
        while (i < this.declarations.length) {
            if (this.declarations[i] == declaration) {
                IDeclaration[] newDeclarations = new IDeclaration[this.declarations.length - 1];
                System.arraycopy(this.declarations, 0, newDeclarations, 0, i);
                System.arraycopy(this.declarations, i + 1, newDeclarations, i, this.declarations.length - i - 1);
                this.declarations = newDeclarations;
                return true;
            }
            ++i;
        }
        return false;
    }

    public int size() {
        return this.declarations.length;
    }
}

