/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.geometry;

import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class GeometryTools {
    public static Point2D deltaTransformPoint(AffineTransform transform, float x, float y) {
        Point2D.Float pt = new Point2D.Float(x, y);
        transform.deltaTransform(pt, pt);
        return pt;
    }

    public static void deltaTransformPoint(AffineTransform transform, float[] pts) {
        double[] dpts = new double[]{pts[0], pts[1]};
        transform.deltaTransform(dpts, 0, dpts, 0, 1);
        pts[0] = (float)dpts[0];
        pts[1] = (float)dpts[1];
    }

    public static void deltaTransformPoint(AffineTransform transform, Point2D pt) {
        transform.deltaTransform(pt, pt);
    }

    public static void inverseTransformRect(AffineTransform transform, Rectangle2D rect) {
        double[] pts = new double[4];
        pts[0] = rect.getX();
        pts[2] = rect.getMaxX();
        pts[1] = rect.getY();
        pts[3] = rect.getMaxY();
        try {
            transform.inverseTransform(pts, 0, pts, 0, pts.length >> 1);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
        rect.setRect(pts[0], pts[1], pts[2] - pts[0], pts[3] - pts[1]);
        GeometryTools.normalizeRect(rect);
    }

    public static void normalizeRect(float[] pts) {
        float temp;
        if (pts[0] > pts[2]) {
            temp = pts[0];
            pts[0] = pts[2];
            pts[2] = temp;
        }
        if (pts[1] > pts[3]) {
            temp = pts[1];
            pts[1] = pts[3];
            pts[3] = temp;
        }
    }

    public static void normalizeRect(Rectangle2D rect) {
        double llx = rect.getMinX();
        double lly = rect.getMinY();
        double width = rect.getWidth();
        double height = rect.getHeight();
        if (width < 0.0) {
            llx += width;
            width = -width;
        }
        if (height < 0.0) {
            lly += height;
            height = -height;
        }
        rect.setRect(llx, lly, width, height);
    }

    public static float[] toFloatArray(Rectangle2D rect) {
        float[] pts;
        pts = new float[]{(float)rect.getX(), (float)rect.getY(), (float)((double)pts[0] + rect.getWidth()), (float)((double)pts[1] + rect.getHeight())};
        return pts;
    }

    public static Point2D transformPoint(AffineTransform transform, float x, float y) {
        Point2D.Float pt = new Point2D.Float(x, y);
        transform.transform(pt, pt);
        return pt;
    }

    public static void transformPoint(AffineTransform transform, float[] pts) {
        transform.transform(pts, 0, pts, 0, 1);
    }

    public static void transformPoint(AffineTransform transform, Point2D pt) {
        transform.transform(pt, pt);
    }

    public static void transformRect(AffineTransform transform, float[] pts) {
        transform.transform(pts, 0, pts, 0, 2);
        GeometryTools.normalizeRect(pts);
    }

    public static void transformRect(AffineTransform transform, Rectangle2D rect) {
        double[] pts = new double[4];
        pts[0] = rect.getMinX();
        pts[2] = rect.getMaxX();
        pts[1] = rect.getMinY();
        pts[3] = rect.getMaxY();
        transform.transform(pts, 0, pts, 0, pts.length >> 1);
        rect.setRect(pts[0], pts[1], pts[2] - pts[0], pts[3] - pts[1]);
        GeometryTools.normalizeRect(rect);
    }

    private GeometryTools() {
    }
}

