/*
 * Decompiled with CFR 0.152.
 */
package adams.core.io;

import adams.core.io.PlaceholderFile;
import adams.core.management.OS;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Vector;

public class FileUtils {
    public static final String FILENAME_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_-.,()";
    public static final int MAX_EXTENSION_LENGTH = 5;

    public static Vector<String> loadFromFile(File file) {
        Vector<String> result = new Vector<String>();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(file.getAbsolutePath()));
            while ((line = reader.readLine()) != null) {
                result.add(line);
            }
            reader.close();
        }
        catch (Exception e) {
            result = null;
            e.printStackTrace();
        }
        return result;
    }

    public static byte[] loadFromBinaryFile(File file) {
        byte[] result;
        int i;
        Vector<Byte> content = new Vector<Byte>();
        BufferedInputStream stream = null;
        try {
            int read;
            byte[] buffer = new byte[1024];
            stream = new BufferedInputStream(new FileInputStream(file.getAbsoluteFile()));
            while ((read = stream.read(buffer)) != -1) {
                for (i = 0; i < read; ++i) {
                    content.add(buffer[i]);
                }
            }
        }
        catch (Exception e) {
            System.err.println("Problem loading binary file '" + file + "':");
            e.printStackTrace();
            content = null;
        }
        if (stream != null) {
            try {
                stream.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (content != null) {
            result = new byte[content.size()];
            for (i = 0; i < result.length; ++i) {
                result[i] = (Byte)content.get(i);
            }
        } else {
            result = null;
        }
        return result;
    }

    public static boolean saveToFile(String[] content, File file) {
        Vector<String> lines = new Vector<String>();
        for (int i = 0; i < content.length; ++i) {
            lines.add(content[i]);
        }
        return FileUtils.saveToFile(lines, file);
    }

    public static boolean saveToFile(List<String> content, File file) {
        boolean result = true;
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(new File(file.getAbsolutePath())));
            for (int i = 0; i < content.size(); ++i) {
                writer.write(content.get(i));
                writer.newLine();
            }
            writer.flush();
            writer.close();
        }
        catch (Exception e) {
            result = false;
            e.printStackTrace();
        }
        return result;
    }

    public static boolean writeToFile(String filename, Object obj) {
        return FileUtils.writeToFile(filename, obj, true);
    }

    public static boolean writeToFile(String filename, Object obj, boolean append) {
        boolean result;
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(filename, append));
            writer.write("" + obj);
            writer.newLine();
            writer.flush();
            writer.close();
            result = true;
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    public static void copyOrMove(File sourceLocation, File targetLocation, boolean move) throws IOException {
        if (sourceLocation.isDirectory()) {
            if (!targetLocation.exists()) {
                targetLocation.mkdir();
            }
            String[] children = sourceLocation.list();
            for (int i = 0; i < children.length; ++i) {
                FileUtils.copyOrMove(new File(sourceLocation.getAbsoluteFile(), children[i]), new File(targetLocation.getAbsoluteFile(), children[i]), move);
            }
            if (move) {
                sourceLocation.delete();
            }
        } else {
            int len;
            FileInputStream in = new FileInputStream(sourceLocation.getAbsoluteFile());
            FileOutputStream out = targetLocation.isDirectory() ? new FileOutputStream(targetLocation.getAbsolutePath() + File.separator + sourceLocation.getName()) : new FileOutputStream(targetLocation.getAbsoluteFile());
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
            if (move) {
                sourceLocation.delete();
            }
        }
    }

    public static void copy(File sourceLocation, File targetLocation) throws IOException {
        FileUtils.copyOrMove(sourceLocation, targetLocation, false);
    }

    public static void move(File sourceLocation, File targetLocation) throws IOException {
        FileUtils.copyOrMove(sourceLocation, targetLocation, true);
    }

    public static boolean delete(String file) {
        return FileUtils.delete(new PlaceholderFile(file));
    }

    public static boolean delete(File file) {
        boolean result = true;
        if (file.isDirectory()) {
            File[] files;
            for (File f : files = file.listFiles()) {
                if (f.getName().equals(".") || f.getName().equals("..")) continue;
                FileUtils.delete(f);
            }
        }
        result = file.delete();
        return result;
    }

    public static String createFilename(String s, String replace) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            if (FILENAME_CHARS.indexOf(s.charAt(i)) == -1) {
                result.append(replace);
                continue;
            }
            result.append(s.charAt(i));
        }
        return result.toString();
    }

    public static String createPartialFilename(File file, int numParentDirs) {
        String result;
        if (numParentDirs == -1) {
            result = file.getAbsolutePath();
        } else {
            result = file.getName();
            File parent = file;
            for (int i = 0; i < numParentDirs && parent.getParentFile() != null; ++i) {
                parent = parent.getParentFile();
                result = parent.getName() + File.separator + result;
            }
        }
        return result;
    }

    public static boolean isDirEmpty(File dir) {
        return FileUtils.isDirEmpty(dir, null);
    }

    public static boolean isDirEmpty(String dir) {
        return FileUtils.isDirEmpty(dir, null);
    }

    public static boolean isDirEmpty(File dir, String regExp) {
        return FileUtils.isDirEmpty(dir.getAbsolutePath(), regExp);
    }

    public static boolean isDirEmpty(String dir, String regExp) {
        boolean result = true;
        File file = new File(dir);
        String[] files = file.list();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].equals(".") || files[i].equals("..") || regExp != null && !files[i].matches(regExp)) continue;
            result = false;
            break;
        }
        return result;
    }

    public static String fixExecutable(String executable) {
        String result = executable;
        if (OS.isWindows()) {
            if (!result.endsWith(".exe") || !result.endsWith(".com")) {
                result = result + ".exe";
            }
        } else if (result.endsWith(".exe") || result.endsWith(".com")) {
            result = result.substring(0, result.length() - 4);
        }
        return result;
    }

    public static String quoteExecutable(String executable) {
        String result = executable;
        if (result.indexOf(32) > -1) {
            result = "\"" + result + "\"";
        }
        return result;
    }

    public static String getExtension(File file) {
        return FileUtils.getExtension(file.getAbsolutePath());
    }

    public static String getExtension(String filename) {
        String[] result = FileUtils.getExtensions(filename);
        if (result != null) {
            return result[0];
        }
        return null;
    }

    public static String[] getExtensions(File file) {
        return FileUtils.getExtensions(file.getAbsolutePath());
    }

    public static String[] getExtensions(String filename) {
        if (filename.indexOf(46) == -1) {
            return null;
        }
        Vector<String> result = new Vector<String>();
        int pos = filename.lastIndexOf(46);
        result.add(filename.substring(pos + 1));
        int posNext = filename.lastIndexOf(46, pos - 1);
        if (pos - posNext <= 5) {
            result.add(0, filename.substring(posNext + 1));
        }
        return result.toArray(new String[result.size()]);
    }

    public static File getTempDirectory() {
        return new File(System.getProperty("java.io.tmpdir"));
    }
}

