/*
 * Decompiled with CFR 0.152.
 */
package adams.data.filter;

import adams.data.container.DataContainer;
import adams.data.container.DataPoint;
import adams.data.filter.AbstractFilter;
import java.io.Serializable;
import java.util.List;
import java.util.Vector;

public abstract class AbstractDerivative<T extends DataContainer>
extends AbstractFilter<T> {
    private static final long serialVersionUID = 530300053103127948L;
    protected int m_Order;
    protected double m_ScalingRange;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("order", "order", 1);
        this.m_OptionManager.add("scaling", "scalingRange", 0.0);
    }

    public void setOrder(int value) {
        if (value > 0) {
            this.m_Order = value;
            this.reset();
        } else {
            this.getSystemErr().println(this.getClass().getName() + ": only positive numbers are allowed!");
        }
    }

    public int getOrder() {
        return this.m_Order;
    }

    public String orderTipText() {
        return "The order of the derivative to calculate.";
    }

    public void setScalingRange(double value) {
        this.m_ScalingRange = value;
        this.reset();
    }

    public double getScalingRange() {
        return this.m_ScalingRange;
    }

    public String scalingRangeTipText() {
        return "The range to scale the abundances to after each derivation step; use 0 to turn off and -1 to set it to the input range.";
    }

    protected Vector<Point> derive(Vector<Point> data) {
        double range;
        int i;
        Vector<Point> result = new Vector<Point>();
        boolean scaling = this.m_ScalingRange > 0.0 || this.m_ScalingRange == -1.0;
        double minAbund = Double.MAX_VALUE;
        double maxAbund = -1.7976931348623157E308;
        double minAbundInput = Double.MAX_VALUE;
        double maxAbundInput = -1.7976931348623157E308;
        for (i = 1; i < data.size(); ++i) {
            Point prevPoint = data.get(i - 1);
            Point currPoint = data.get(i);
            Point newPoint = new Point(prevPoint.getX(), (currPoint.getY() - prevPoint.getY()) / (currPoint.getX() - prevPoint.getX()));
            if (scaling) {
                if (prevPoint.getY() > maxAbundInput) {
                    maxAbundInput = prevPoint.getY();
                }
                if (prevPoint.getY() < minAbundInput) {
                    minAbundInput = prevPoint.getY();
                }
                if (newPoint.getY() > maxAbund) {
                    maxAbund = newPoint.getY();
                }
                if (newPoint.getY() < minAbund) {
                    minAbund = newPoint.getY();
                }
            }
            result.add(newPoint);
        }
        if (scaling && (range = maxAbund - minAbund) != 0.0) {
            double factor = this.m_ScalingRange == -1.0 ? (maxAbundInput - minAbundInput) / range : this.m_ScalingRange / range;
            for (i = 0; i < result.size(); ++i) {
                result.get(i).setY(result.get(i).getY() * factor);
            }
        }
        return result;
    }

    protected abstract Point toPoint(DataPoint var1);

    protected abstract DataPoint toDataPoint(Point var1);

    @Override
    protected T processData(T data) {
        int i;
        List datapoints = data.toList();
        Vector<Point> points = new Vector<Point>();
        for (i = 0; i < datapoints.size(); ++i) {
            points.add(this.toPoint((DataPoint)datapoints.get(i)));
        }
        for (i = 0; i < this.m_Order; ++i) {
            points = this.derive(points);
        }
        DataContainer result = data.getHeader();
        for (i = 0; i < points.size(); ++i) {
            result.add(this.toDataPoint(points.get(i)));
        }
        return (T)result;
    }

    public static class Point
    implements Serializable {
        private static final long serialVersionUID = -5500693386976351214L;
        protected double m_X;
        protected double m_Y;

        public Point(double x, double y) {
            this.m_X = x;
            this.m_Y = y;
        }

        public double getX() {
            return this.m_X;
        }

        public double getY() {
            return this.m_Y;
        }

        public void setY(double value) {
            this.m_Y = value;
        }

        public String toString() {
            return "X=" + this.m_X + ", Y=" + this.m_Y;
        }
    }
}

