/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.flow.condition.bool.AbstractBooleanCondition;
import adams.flow.condition.bool.True;
import adams.flow.control.AbstractDirectedControlActor;
import adams.flow.control.AbstractDirector;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorExecution;
import adams.flow.core.ActorHandlerInfo;
import adams.flow.core.ActorUtils;
import adams.flow.core.InputConsumer;
import adams.flow.core.MutableActorHandler;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import adams.flow.sink.Null;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;

public class Switch
extends AbstractDirectedControlActor
implements InputConsumer,
MutableActorHandler {
    private static final long serialVersionUID = 185561131623293880L;
    public static final String BACKUP_INPUT = "input";
    protected AbstractBooleanCondition[] m_Conditions;
    protected Vector<AbstractActor> m_Cases;
    protected transient Token m_InputToken;

    @Override
    public String globalInfo() {
        return "Emulates a Switch control statement. The first 'condition' that evaluates to 'true' executes the corresponding 'case' actor and stops evaluation of conditions.\nA catch-all or default can be set up as well by having one more 'case' than 'conditions' (the last case acts as default).";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("condition", "conditions", new AbstractBooleanCondition[]{new True()});
        this.m_OptionManager.add("case", "cases", new AbstractActor[]{new Null()});
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_InputToken = null;
        this.m_Cases = new Vector();
    }

    @Override
    protected AbstractDirector newDirector() {
        return new SwitchDirector();
    }

    public void setConditions(AbstractBooleanCondition[] value) {
        this.m_Conditions = value;
        this.reset();
    }

    public AbstractBooleanCondition[] getConditions() {
        return this.m_Conditions;
    }

    public String conditionsTipText() {
        return "The switch conditions to evaluate - the first condition that evaluates to 'true' triggers the execution of the corresponding 'case' actor.";
    }

    public void setCases(AbstractActor[] value) {
        ActorUtils.uniqueNames(value);
        this.m_Cases.clear();
        for (int i = 0; i < value.length; ++i) {
            this.m_Cases.add(value[i]);
        }
        this.updateParent();
        this.reset();
    }

    public AbstractActor[] getCases() {
        return this.m_Cases.toArray(new AbstractActor[this.m_Cases.size()]);
    }

    public String casesTipText() {
        return "The 'cases' - one of them gets executed if the corresponding 'condition' evaluates to 'true'.";
    }

    @Override
    public String getQuickInfo() {
        String result = this.m_Conditions.length + " condition";
        if (this.m_Conditions.length != 1) {
            result = result + "s";
        }
        return result;
    }

    @Override
    public int size() {
        return this.m_Cases.size();
    }

    @Override
    public AbstractActor get(int index) {
        return this.m_Cases.get(index);
    }

    @Override
    public void set(int index, AbstractActor actor) {
        if (index > -1 && index < this.m_Cases.size()) {
            ActorUtils.uniqueName(actor, this, index);
            this.m_Cases.set(index, actor);
            this.reset();
            this.updateParent();
        } else {
            this.getSystemErr().println("Index out of range (0-" + (this.m_Cases.size() - 1) + "): " + index);
        }
    }

    @Override
    public void add(int index, AbstractActor actor) {
        this.m_Cases.add(index, actor);
        this.reset();
        this.updateParent();
    }

    @Override
    public AbstractActor remove(int index) {
        AbstractActor result = this.m_Cases.remove(index);
        this.reset();
        return result;
    }

    @Override
    public void removeAll() {
        this.m_Cases.clear();
        this.reset();
    }

    @Override
    public int indexOf(String actor) {
        int result = -1;
        for (int i = 0; i < this.m_Cases.size(); ++i) {
            if (!this.m_Cases.get(i).getName().equals(actor)) continue;
            result = i;
            break;
        }
        return result;
    }

    @Override
    public ActorHandlerInfo getActorHandlerInfo() {
        return new ActorHandlerInfo(false, ActorExecution.PARALLEL, true);
    }

    @Override
    public Class[] accepts() {
        HashSet<Class> result = new HashSet<Class>();
        if (this.m_Cases.size() == 0) {
            result.add(Unknown.class);
        } else {
            for (AbstractActor actor : this.m_Cases) {
                if (!(actor instanceof InputConsumer)) continue;
                result.addAll(Arrays.asList(((InputConsumer)((Object)actor)).accepts()));
            }
        }
        return result.toArray(new Class[result.size()]);
    }

    @Override
    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_INPUT);
    }

    @Override
    protected Hashtable<String, Object> backupState() {
        Hashtable<String, Object> result = super.backupState();
        if (this.m_InputToken != null) {
            result.put(BACKUP_INPUT, this.m_InputToken);
        }
        return result;
    }

    @Override
    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_INPUT)) {
            this.m_InputToken = (Token)state.get(BACKUP_INPUT);
            ((SwitchDirector)this.m_Director).setCaseToken(this.m_InputToken);
            state.remove(BACKUP_INPUT);
        }
        super.restoreState(state);
    }

    @Override
    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            if (this.m_Conditions == null || this.m_Conditions.length == 0) {
                result = "No condition provided!";
            } else if (this.m_Cases.size() > this.m_Conditions.length + 1) {
                result = "Only 1 default case can be defined: " + this.m_Conditions + " condition(s) but " + this.m_Cases.size() + " case(s)";
            } else if (this.m_Cases.size() < this.m_Conditions.length) {
                result = "Not enough cases defined: " + this.m_Conditions.length + " required";
            }
        }
        return result;
    }

    @Override
    public void input(Token token) {
        this.m_InputToken = token;
        ((SwitchDirector)this.m_Director).setCaseToken(this.m_InputToken);
    }

    @Override
    public void cleanUp() {
        this.m_InputToken = null;
        super.cleanUp();
    }

    public static class SwitchDirector
    extends AbstractDirector {
        private static final long serialVersionUID = 8414511259688024553L;
        protected transient Token m_CaseToken;

        public void setControlActor(AbstractDirectedControlActor value) {
            if (value instanceof Switch || value == null) {
                super.setControlActor(value);
            } else {
                System.err.println("Group must be a Switch actor (provided: " + (value != null ? value.getClass().getName() : "-null-") + ")!");
            }
        }

        public void setCaseToken(Token value) {
            this.m_CaseToken = value;
        }

        public Token getCaseToken() {
            return this.m_CaseToken;
        }

        protected int whichCase() {
            int result = -1;
            Switch switchActor = (Switch)this.m_ControlActor;
            for (int i = 0; i < switchActor.getConditions().length; ++i) {
                try {
                    if (!switchActor.getConditions()[i].evaluate(switchActor, this.m_CaseToken)) continue;
                    result = i;
                    break;
                }
                catch (Exception e) {
                    this.getSystemErr().println("Error evaluating boolean condition: " + switchActor.getConditions());
                    this.getSystemErr().printStackTrace(e);
                }
            }
            if (result == -1 && switchActor.getCases().length > switchActor.getConditions().length) {
                result = switchActor.getCases().length - 1;
            }
            return result;
        }

        @Override
        public String execute() {
            String result = null;
            int index = this.whichCase();
            if (index == -1) {
                result = "No matching case found!";
            } else {
                AbstractActor caseActor = ((Switch)this.m_ControlActor).get(index);
                try {
                    if (caseActor instanceof InputConsumer) {
                        ((InputConsumer)((Object)caseActor)).input(this.m_CaseToken);
                    }
                    result = caseActor.execute();
                }
                catch (Exception e) {
                    String msg = caseActor.getFullName() + " generated the following exception: ";
                    result = msg + e;
                    this.getSystemErr().println(msg);
                    this.getSystemErr().printStackTrace(e);
                }
                if (result != null) {
                    caseActor.handleError("execute", result);
                }
            }
            return result;
        }

        @Override
        public void cleanUp() {
            this.m_CaseToken = null;
            super.cleanUp();
        }
    }
}

