/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.core.base.BasePassword;
import adams.flow.standalone.AbstractStandalone;

public abstract class AbstractDatabaseConnection
extends AbstractStandalone {
    private static final long serialVersionUID = -1726172998200420556L;
    protected String m_URL;
    protected String m_User;
    protected BasePassword m_Password;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("url", "URL", "jdbc:mysql://somehost:3306/somedatabase", false);
        this.m_OptionManager.add("user", "user", "", false);
        this.m_OptionManager.add("password", "password", new BasePassword(), false);
    }

    @Override
    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("URL");
        String result = variable != null ? variable : this.getURL();
        return result;
    }

    public void setURL(String value) {
        this.m_URL = value;
        this.reset();
    }

    public String getURL() {
        return this.m_URL;
    }

    public String URLTipText() {
        return "The JDBC URL of the database to connect to.";
    }

    public void setUser(String value) {
        this.m_User = value;
        this.reset();
    }

    public String getUser() {
        return this.m_User;
    }

    public String userTipText() {
        return "The database user to connect with.";
    }

    public void setPassword(BasePassword value) {
        this.m_Password = value;
        this.reset();
    }

    public BasePassword getPassword() {
        return this.m_Password;
    }

    public String passwordTipText() {
        return "The password of the database user.";
    }

    @Override
    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            adams.db.AbstractDatabaseConnection conn = this.getConnection();
            String msg = null;
            if (!conn.isConnected() && !conn.getConnectOnStartUp()) {
                try {
                    conn.connect();
                }
                catch (Exception e) {
                    this.getSystemErr().println("Failed to connect to database (" + this.getURL() + "):");
                    this.getSystemErr().printStackTrace(e);
                    msg = e.toString();
                }
            }
            if (!conn.isConnected()) {
                result = "Failed to connect to database (" + this.getURL() + ")";
                result = msg == null ? result + "!" : result + ": " + msg;
            }
        }
        return result;
    }

    @Override
    protected String doExecute() {
        return null;
    }

    public abstract adams.db.AbstractDatabaseConnection getConnection();
}

