/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import adams.gui.core.AbstractDoubleClickableComponentWithButtons;
import adams.gui.core.BaseTable;
import adams.gui.core.MoveableTableModel;
import adams.gui.event.RemoveItemsListener;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class BaseTableWithButtons
extends AbstractDoubleClickableComponentWithButtons<BaseTable> {
    private static final long serialVersionUID = 1935542795448084154L;
    protected TableModelListener m_CountModelListener;

    public BaseTableWithButtons() {
    }

    public BaseTableWithButtons(TableModel model) {
        ((BaseTable)this.m_Component).setModel(model);
        ((BaseTable)this.m_Component).setOptimalColumnWidth();
        model.addTableModelListener((TableModelListener)((Object)this.m_Component));
        this.updateCountsModelListener(model);
    }

    @Override
    public boolean requiresScrollPane() {
        return true;
    }

    @Override
    protected BaseTable createComponent() {
        BaseTable result = new BaseTable();
        result.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                BaseTableWithButtons.this.updateCounts();
            }
        });
        return result;
    }

    @Override
    protected boolean isValidDoubleClick(MouseEvent e) {
        return ((BaseTable)this.m_Component).getSelectedRowCount() == 1;
    }

    public void setModel(TableModel dataModel) {
        this.updateCountsModelListener(dataModel);
        ((BaseTable)this.m_Component).setModel(dataModel);
        this.updateCounts();
    }

    public TableModel getModel() {
        return ((BaseTable)this.m_Component).getModel();
    }

    public boolean supportsMovingRows() {
        return this.getModel() instanceof MoveableTableModel;
    }

    public void moveUp() {
        if (this.supportsMovingRows()) {
            ((MoveableTableModel)this.getModel()).moveUp(((BaseTable)this.m_Component).getSelectedRows());
        }
    }

    public void moveDown() {
        if (this.supportsMovingRows()) {
            ((MoveableTableModel)this.getModel()).moveDown(((BaseTable)this.m_Component).getSelectedRows());
        }
    }

    public void moveTop() {
        if (this.supportsMovingRows()) {
            ((MoveableTableModel)this.getModel()).moveTop(((BaseTable)this.m_Component).getSelectedRows());
        }
    }

    public void moveBottom() {
        if (this.supportsMovingRows()) {
            ((MoveableTableModel)this.getModel()).moveBottom(((BaseTable)this.m_Component).getSelectedRows());
        }
    }

    public boolean canMoveUp() {
        if (this.supportsMovingRows()) {
            return ((MoveableTableModel)this.getModel()).canMoveUp(((BaseTable)this.m_Component).getSelectedRows());
        }
        return false;
    }

    public boolean canMoveDown() {
        if (this.supportsMovingRows()) {
            return ((MoveableTableModel)this.getModel()).canMoveDown(((BaseTable)this.m_Component).getSelectedRows());
        }
        return false;
    }

    public void setColumnModel(TableColumnModel columnModel) {
        ((BaseTable)this.m_Component).setColumnModel(columnModel);
    }

    public TableColumnModel getColumnModel() {
        return ((BaseTable)this.m_Component).getColumnModel();
    }

    public void setSelectionModel(ListSelectionModel newModel) {
        ((BaseTable)this.m_Component).setSelectionModel(newModel);
    }

    public ListSelectionModel getSelectionModel() {
        return ((BaseTable)this.m_Component).getSelectionModel();
    }

    public void setAutoResizeMode(int mode) {
        ((BaseTable)this.m_Component).setAutoResizeMode(mode);
    }

    public int getAutoResizeMode() {
        return ((BaseTable)this.m_Component).getAutoResizeMode();
    }

    public void setOptimalColumnWidth() {
        ((BaseTable)this.m_Component).setOptimalColumnWidth();
    }

    public void setOptimalColumnWidth(int column) {
        ((BaseTable)this.m_Component).setOptimalColumnWidth(column);
    }

    public void setRowHeight(int rowHeight) {
        ((BaseTable)this.m_Component).setRowHeight(rowHeight);
    }

    public int getRowHeight(int row) {
        return ((BaseTable)this.m_Component).getRowHeight(row);
    }

    public int rowAtPoint(Point point) {
        return ((BaseTable)this.m_Component).rowAtPoint(point);
    }

    public int getSelectedRow() {
        return ((BaseTable)this.m_Component).getSelectedRow();
    }

    public int getSelectedColumn() {
        return ((BaseTable)this.m_Component).getSelectedColumn();
    }

    public int[] getSelectedRows() {
        return ((BaseTable)this.m_Component).getSelectedRows();
    }

    public int[] getSelectedColumns() {
        return ((BaseTable)this.m_Component).getSelectedColumns();
    }

    public int getSelectedRowCount() {
        return ((BaseTable)this.m_Component).getSelectedRowCount();
    }

    public int getSelectedColumnCount() {
        return ((BaseTable)this.m_Component).getSelectedColumnCount();
    }

    public boolean isRowSelected(int row) {
        return ((BaseTable)this.m_Component).isRowSelected(row);
    }

    public boolean isColumnSelected(int column) {
        return ((BaseTable)this.m_Component).isColumnSelected(column);
    }

    public boolean isCellSelected(int row, int column) {
        return ((BaseTable)this.m_Component).isCellSelected(row, column);
    }

    public int getRowCount() {
        return ((BaseTable)this.m_Component).getRowCount();
    }

    public int getColumnCount() {
        return ((BaseTable)this.m_Component).getColumnCount();
    }

    public String getColumnName(int column) {
        return ((BaseTable)this.m_Component).getColumnName(column);
    }

    public Class<?> getColumnClass(int column) {
        return ((BaseTable)this.m_Component).getColumnClass(column);
    }

    public Object getValueAt(int row, int column) {
        return ((BaseTable)this.m_Component).getValueAt(row, column);
    }

    public void setValueAt(Object aValue, int row, int column) {
        ((BaseTable)this.m_Component).setValueAt(aValue, row, column);
    }

    public boolean isCellEditable(int row, int column) {
        return ((BaseTable)this.m_Component).isCellEditable(row, column);
    }

    public void setSelectionMode(int selectionMode) {
        ((BaseTable)this.m_Component).setSelectionMode(selectionMode);
    }

    public void addRemoveItemsListener(RemoveItemsListener l) {
        ((BaseTable)this.m_Component).addRemoveItemsListener(l);
    }

    public void removeRemoveItemsListener(RemoveItemsListener l) {
        ((BaseTable)this.m_Component).removeRemoveItemsListener(l);
    }

    @Override
    public void setInfoVisible(boolean value) {
        super.setInfoVisible(value);
        if (value) {
            this.updateCounts();
        }
    }

    protected void updateCountsModelListener(TableModel dataModel) {
        if (this.m_CountModelListener != null) {
            this.getModel().removeTableModelListener(this.m_CountModelListener);
        }
        this.m_CountModelListener = new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                BaseTableWithButtons.this.updateCounts();
            }
        };
        dataModel.addTableModelListener(this.m_CountModelListener);
    }

    protected void updateCounts() {
        this.updateInfo("Total: " + ((BaseTable)this.m_Component).getRowCount() + ", Selected: " + ((BaseTable)this.m_Component).getSelectedRowCount());
    }
}

