/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.menu;

import adams.gui.application.AbstractApplicationFrame;
import adams.gui.application.AbstractMenuItemDefinition;
import adams.gui.application.UserMode;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.BaseTree;
import adams.gui.core.BaseTreeNode;
import adams.gui.core.GUIHelper;
import java.awt.BorderLayout;
import java.awt.Container;
import javax.swing.JOptionPane;

public class ContainerNesting
extends AbstractMenuItemDefinition {
    private static final long serialVersionUID = 6149133251059325645L;

    public ContainerNesting() {
        this(null);
    }

    public ContainerNesting(AbstractApplicationFrame owner) {
        super(owner);
    }

    @Override
    public void launch() {
        BaseTree tree;
        String classname = JOptionPane.showInputDialog("Please enter class name of Swing container:");
        if (classname == null) {
            return;
        }
        try {
            tree = adams.gui.tools.ContainerNesting.analyze((Container)Class.forName(classname).newInstance());
        }
        catch (Exception e) {
            GUIHelper.showErrorMessage(null, "Failed to generate tree:\n" + e);
            return;
        }
        BasePanel panel = new BasePanel(new BorderLayout());
        panel.add(new BaseScrollPane(tree));
        tree.setShowsRootHandles(true);
        tree.expand((BaseTreeNode)tree.getModel().getRoot());
        this.createChildFrame(panel, 800, 800);
    }

    @Override
    public String getTitle() {
        return "Container nesting";
    }

    @Override
    public boolean isSingleton() {
        return false;
    }

    @Override
    public UserMode getUserMode() {
        return UserMode.DEVELOPER;
    }

    @Override
    public String getCategory() {
        return "Maintenance";
    }
}

