/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.macro.Interpreter;
import ij.measure.Calibration;
import ij.plugin.ImagesToStack;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import ij.process.LUT;
import java.awt.Color;

public class StackEditor
implements PlugIn {
    ImagePlus imp;
    int nSlices;
    int width;
    int height;
    static boolean deleteFrames;

    public void run(String arg) {
        this.imp = IJ.getImage();
        this.nSlices = this.imp.getStackSize();
        this.width = this.imp.getWidth();
        this.height = this.imp.getHeight();
        if (arg.equals("add")) {
            this.addSlice();
        } else if (arg.equals("delete")) {
            this.deleteSlice();
        } else if (arg.equals("toimages")) {
            this.convertStackToImages(this.imp);
        }
    }

    void addSlice() {
        if (this.imp.isComposite() && this.nSlices == this.imp.getNChannels()) {
            this.addChannel();
            return;
        }
        if (this.imp.isDisplayedHyperStack()) {
            return;
        }
        if (!this.imp.lock()) {
            return;
        }
        int id = 0;
        ImageStack stack = this.imp.getStack();
        if (stack.getSize() == 1) {
            Object obj;
            String label = stack.getSliceLabel(1);
            if (label != null && label.indexOf("\n") != -1) {
                stack.setSliceLabel(null, 1);
            }
            if ((obj = this.imp.getProperty("Label")) != null && obj instanceof String) {
                stack.setSliceLabel((String)obj, 1);
            }
            id = this.imp.getID();
        }
        ImageProcessor ip = this.imp.getProcessor();
        int n = this.imp.getCurrentSlice();
        if (IJ.altKeyDown()) {
            --n;
        }
        stack.addSlice(null, ip.createProcessor(this.width, this.height), n);
        this.imp.setStack(null, stack);
        this.imp.setSlice(n + 1);
        this.imp.unlock();
        if (id != 0) {
            IJ.selectWindow(id);
        }
    }

    void deleteSlice() {
        String label;
        if (this.nSlices < 2) {
            IJ.error("\"Delete Slice\" requires a stack");
            return;
        }
        if (this.imp.isComposite() && this.nSlices == this.imp.getNChannels()) {
            this.deleteChannel();
            return;
        }
        if (this.imp.isDisplayedHyperStack()) {
            this.deleteHyperstackSliceOrFrame();
            return;
        }
        if (!this.imp.lock()) {
            return;
        }
        ImageStack stack = this.imp.getStack();
        int n = this.imp.getCurrentSlice();
        stack.deleteSlice(n);
        if (stack.getSize() == 1 && (label = stack.getSliceLabel(1)) != null) {
            this.imp.setProperty("Label", label);
        }
        this.imp.setStack(null, stack);
        if (n-- < 1) {
            n = 1;
        }
        this.imp.setSlice(n);
        this.imp.unlock();
    }

    void addChannel() {
        int c = this.imp.getChannel();
        ImageStack stack = this.imp.getStack();
        CompositeImage ci = (CompositeImage)this.imp;
        LUT[] luts = ci.getLuts();
        ImageProcessor ip = stack.getProcessor(1);
        ImageProcessor ip2 = ip.createProcessor(ip.getWidth(), ip.getHeight());
        stack.addSlice(null, ip2, c);
        ImagePlus imp2 = this.imp.createImagePlus();
        imp2.setStack(stack);
        int n = imp2.getStackSize();
        imp2 = new CompositeImage(this.imp, ci.getMode());
        LUT lut = LUT.createLutFromColor(Color.white);
        int index = 0;
        for (int i = 1; i <= n; ++i) {
            if (c + 1 == index + 1) {
                ((CompositeImage)imp2).setChannelLut(lut, i);
                c = -1;
                continue;
            }
            ((CompositeImage)imp2).setChannelLut(luts[index++], i);
        }
        this.imp.changes = false;
        this.imp.hide();
        imp2.show();
    }

    void deleteChannel() {
        int c = this.imp.getChannel();
        ImageStack stack = this.imp.getStack();
        CompositeImage ci = (CompositeImage)this.imp;
        LUT[] luts = ci.getLuts();
        stack.deleteSlice(c);
        ImagePlus imp2 = this.imp.createImagePlus();
        imp2.setStack(stack);
        int n = imp2.getStackSize();
        int mode = ci.getMode();
        if (mode == 1 && n == 1) {
            mode = 2;
        }
        imp2 = new CompositeImage(this.imp, mode);
        int index = 0;
        for (int i = 1; i <= n; ++i) {
            if (c == index + 1) {
                // empty if block
            }
            int n2 = ++index;
            ++index;
            ((CompositeImage)imp2).setChannelLut(luts[n2], i);
        }
        this.imp.changes = false;
        this.imp.hide();
        imp2.show();
    }

    void deleteHyperstackSliceOrFrame() {
        int channels = this.imp.getNChannels();
        int slices = this.imp.getNSlices();
        int frames = this.imp.getNFrames();
        int c1 = this.imp.getChannel();
        int z1 = this.imp.getSlice();
        int t1 = this.imp.getFrame();
        if (frames > 1 && slices == 1) {
            deleteFrames = true;
        } else if (frames == 1 && slices > 1) {
            deleteFrames = false;
        } else if (slices > 1 && frames > 1) {
            GenericDialog gd = new GenericDialog("Delete Slice");
            gd.addCheckbox("Delete time point " + t1, deleteFrames);
            gd.showDialog();
            if (gd.wasCanceled()) {
                return;
            }
            deleteFrames = gd.getNextBoolean();
        } else {
            return;
        }
        if (!this.imp.lock()) {
            return;
        }
        ImageStack stack = this.imp.getStack();
        if (deleteFrames) {
            for (int z = slices; z >= 1; --z) {
                int index = this.imp.getStackIndex(channels, z, t1);
                for (int i = 0; i < channels; ++i) {
                    stack.deleteSlice(index - i);
                }
            }
            --frames;
        } else {
            for (int t = frames; t >= 1; --t) {
                int index = this.imp.getStackIndex(channels, z1, t);
                for (int i = 0; i < channels; ++i) {
                    stack.deleteSlice(index - i);
                }
            }
            --slices;
        }
        this.imp.setDimensions(channels, slices, frames);
        this.imp.unlock();
    }

    public void convertImagesToStack() {
        new ImagesToStack().run("");
    }

    public void convertStackToImages(ImagePlus imp) {
        CompositeImage cimg;
        boolean ok;
        if (this.nSlices < 2) {
            IJ.error("\"Convert Stack to Images\" requires a stack");
            return;
        }
        if (!imp.lock()) {
            return;
        }
        ImageStack stack = imp.getStack();
        int size = stack.getSize();
        if (size > 30 && !IJ.isMacro() && !(ok = IJ.showMessageWithCancel("Convert to Images?", "Are you sure you want to convert this\nstack to " + size + " separate windows?"))) {
            imp.unlock();
            return;
        }
        Calibration cal = imp.getCalibration();
        CompositeImage compositeImage = cimg = imp.isComposite() ? (CompositeImage)imp : null;
        if (imp.getNChannels() != imp.getStackSize()) {
            cimg = null;
        }
        for (int i = 1; i <= size; ++i) {
            LUT lut;
            String label = stack.getShortSliceLabel(i);
            String title = label != null && !label.equals("") ? label : this.getTitle(imp, i);
            ImageProcessor ip = stack.getProcessor(i);
            if (cimg != null && (lut = cimg.getChannelLut(i)) != null) {
                ip.setColorModel(lut);
                ip.setMinAndMax(lut.min, lut.max);
            }
            ImagePlus imp2 = new ImagePlus(title, ip);
            imp2.setCalibration(cal);
            String info = stack.getSliceLabel(i);
            if (info != null && !info.equals(label)) {
                imp2.setProperty("Info", info);
            }
            imp2.show();
        }
        imp.changes = false;
        ImageWindow win = imp.getWindow();
        if (win != null) {
            win.close();
        } else if (Interpreter.isBatchMode()) {
            Interpreter.removeBatchModeImage(imp);
        }
        imp.unlock();
    }

    String getTitle(ImagePlus imp, int n) {
        String digits = "00000000" + n;
        return imp.getShortTitle() + "-" + digits.substring(digits.length() - 4, digits.length());
    }
}

