/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.complete.benchmark;

import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.ojalgo.concurrent.ProcessorCount;
import org.ujmp.colt.benchmark.ColtDenseDoubleMatrix2DBenchmark;
import org.ujmp.commonsmath.benchmark.CommonsMathArrayDenseDoubleMatrix2DBenchmark;
import org.ujmp.commonsmath.benchmark.CommonsMathBlockDenseDoubleMatrix2DBenchmark;
import org.ujmp.core.Coordinates;
import org.ujmp.core.Matrix;
import org.ujmp.core.MatrixFactory;
import org.ujmp.core.benchmark.AbstractMatrix2DBenchmark;
import org.ujmp.core.benchmark.ArrayDenseDoubleMatrix2DBenchmark;
import org.ujmp.core.benchmark.BenchmarkUtil;
import org.ujmp.core.benchmark.BlockDenseDoubleMatrix2DBenchmark;
import org.ujmp.core.benchmark.DefaultDenseDoubleMatrix2DBenchmark;
import org.ujmp.core.calculation.Calculation;
import org.ujmp.core.doublematrix.DoubleMatrix2D;
import org.ujmp.core.doublematrix.impl.DefaultDenseDoubleMatrix2D;
import org.ujmp.core.enums.FileFormat;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.listmatrix.DefaultListMatrix;
import org.ujmp.core.util.CommandLineUtil;
import org.ujmp.core.util.StringUtil;
import org.ujmp.core.util.UJMPSettings;
import org.ujmp.core.util.matrices.MatrixSystemEnvironment;
import org.ujmp.core.util.matrices.MatrixSystemProperties;
import org.ujmp.ejml.benchmark.EJMLDenseDoubleMatrix2DBenchmark;
import org.ujmp.jama.JamaDenseDoubleMatrix2D;
import org.ujmp.jama.benchmark.JamaDenseDoubleMatrix2DBenchmark;
import org.ujmp.jampack.benchmark.JampackDenseDoubleMatrix2DBenchmark;
import org.ujmp.jblas.benchmark.JBlasDenseDoubleMatrix2DBenchmark;
import org.ujmp.jlinalg.benchmark.JLinAlgDenseDoubleMatrix2DBenchmark;
import org.ujmp.jmatharray.benchmark.JMathArrayDenseDoubleMatrix2DBenchmark;
import org.ujmp.jmatrices.benchmark.JMatricesDenseDoubleMatrix2DBenchmark;
import org.ujmp.jsci.benchmark.JSciDenseDoubleMatrix2DBenchmark;
import org.ujmp.jscience.benchmark.JScienceDenseDoubleMatrix2DBenchmark;
import org.ujmp.mantissa.benchmark.MantissaDenseDoubleMatrix2DBenchmark;
import org.ujmp.mtj.benchmark.MTJDenseDoubleMatrix2DBenchmark;
import org.ujmp.ojalgo.benchmark.OjalgoDenseDoubleMatrix2DBenchmark;
import org.ujmp.orbital.benchmark.OrbitalDenseDoubleMatrix2DBenchmark;
import org.ujmp.owlpack.benchmark.OwlpackDenseDoubleMatrix2DBenchmark;
import org.ujmp.parallelcolt.benchmark.ParallelColtDenseDoubleMatrix2DBenchmark;
import org.ujmp.sst.benchmark.SSTDenseDoubleMatrix2DBenchmark;
import org.ujmp.vecmath.benchmark.VecMathDenseDoubleMatrix2DBenchmark;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompleteMatrixBenchmark
extends AbstractMatrix2DBenchmark {
    public List<AbstractMatrix2DBenchmark> getDenseBenchmarks() {
        ArrayList<AbstractMatrix2DBenchmark> list = new ArrayList<AbstractMatrix2DBenchmark>();
        if (this.getConfig().isRunVecMathDenseDoubleMatrix2D()) {
            list.add(new VecMathDenseDoubleMatrix2DBenchmark());
        }
        if (this.getConfig().isRunDefaultDenseDoubleMatrix2D()) {
            list.add(new DefaultDenseDoubleMatrix2DBenchmark());
        }
        if (this.getConfig().isRunArrayDenseDoubleMatrix2D()) {
            list.add(new ArrayDenseDoubleMatrix2DBenchmark());
        }
        if (this.getConfig().isRunBlockDenseDoubleMatrix2D()) {
            list.add(new BlockDenseDoubleMatrix2DBenchmark());
        }
        if (this.getConfig().isRunSSTDenseDoubleMatrix2D()) {
            list.add(new SSTDenseDoubleMatrix2DBenchmark());
        }
        if (this.getConfig().isRunOwlpackDenseDoubleMatrix2D()) {
            list.add(new OwlpackDenseDoubleMatrix2DBenchmark());
        }
        if (this.getConfig().isRunOrbitalDenseDoubleMatrix2D()) {
            list.add(new OrbitalDenseDoubleMatrix2DBenchmark());
        }
        if (this.getConfig().isRunOjalgoDenseDoubleMatrix2D()) {
            list.add(new OjalgoDenseDoubleMatrix2DBenchmark());
        }
        if (this.getConfig().isRunMTJDenseDoubleMatrix2D()) {
            list.add(new MTJDenseDoubleMatrix2DBenchmark());
        }
        if (this.getConfig().isRunMantissaDenseDoubleMatrix2D()) {
            list.add(new MantissaDenseDoubleMatrix2DBenchmark());
        }
        if (this.getConfig().isRunJScienceDenseDoubleMatrix2D()) {
            list.add(new JScienceDenseDoubleMatrix2DBenchmark());
        }
        if (this.getConfig().isRunJSciDenseDoubleMatrix2D()) {
            list.add(new JSciDenseDoubleMatrix2DBenchmark());
        }
        if (this.getConfig().isRunJMatricesDenseDoubleMatrix2D()) {
            list.add(new JMatricesDenseDoubleMatrix2DBenchmark());
        }
        if (this.getConfig().isRunJMathArrayDenseDoubleMatrix2D()) {
            list.add(new JMathArrayDenseDoubleMatrix2DBenchmark());
        }
        if (this.getConfig().isRunJLinAlgDenseDoubleMatrix2D()) {
            list.add(new JLinAlgDenseDoubleMatrix2DBenchmark());
        }
        if (this.getConfig().isRunJBlasDenseDoubleMatrix2D()) {
            list.add(new JBlasDenseDoubleMatrix2DBenchmark());
        }
        if (this.getConfig().isRunJampackDenseDoubleMatrix2D()) {
            list.add(new JampackDenseDoubleMatrix2DBenchmark());
        }
        if (this.getConfig().isRunJamaDenseDoubleMatrix2D()) {
            list.add(new JamaDenseDoubleMatrix2DBenchmark());
        }
        if (this.getConfig().isRunEJMLDenseDoubleMatrix2D()) {
            list.add(new EJMLDenseDoubleMatrix2DBenchmark());
        }
        if (this.getConfig().isRunCommonsMathBlockDenseDoubleMatrix2D()) {
            list.add(new CommonsMathBlockDenseDoubleMatrix2DBenchmark());
        }
        if (this.getConfig().isRunCommonsMathArrayDenseDoubleMatrix2D()) {
            list.add(new CommonsMathArrayDenseDoubleMatrix2DBenchmark());
        }
        if (this.getConfig().isRunColtDenseDoubleMatrix2D()) {
            list.add(new ColtDenseDoubleMatrix2DBenchmark());
        }
        if (this.getConfig().isRunParallelColtDenseDoubleMatrix2D()) {
            list.add(new ParallelColtDenseDoubleMatrix2DBenchmark());
        }
        return list;
    }

    public void runAll() throws Exception {
        List<AbstractMatrix2DBenchmark> benchmarks = this.getDenseBenchmarks();
        UJMPSettings.setNumberOfThreads(this.getConfig().getNumberOfThreads());
        ProcessorCount.RUNTIME = this.getConfig().getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads((int)this.getConfig().getNumberOfThreads());
        System.setProperty("ATLAS_NUM_THREADS", "" + this.getConfig().getNumberOfThreads());
        if (this.getConfig().isShuffle()) {
            Collections.shuffle(benchmarks);
        }
        if (this.getConfig().isReverse()) {
            Collections.reverse(benchmarks);
        }
        long t0 = System.currentTimeMillis();
        int j = 0;
        while (j < benchmarks.size()) {
            AbstractMatrix2DBenchmark benchmark = benchmarks.get(j);
            benchmark.run();
            ++j;
        }
        long t1 = System.currentTimeMillis();
        System.out.println();
        System.out.println("Finished.");
        System.out.println("Total Time: " + StringUtil.duration(t1 - t0));
        System.out.println();
        System.out.println();
    }

    public static void main(String[] args) throws Exception {
        CompleteMatrixBenchmark mb = new CompleteMatrixBenchmark();
        CommandLineUtil.parse(mb.getConfig(), args);
        mb.runAll();
        mb.evaluate();
    }

    public void setShuffle(boolean shuffle) {
        this.getConfig().setShuffle(shuffle);
    }

    public void setReverse(boolean reverse) {
        this.getConfig().setReverse(reverse);
    }

    public void evaluate() throws Exception {
        System.out.println("Evaluation");
        System.out.println("==========");
        System.out.println();
        File dir = new File(BenchmarkUtil.getResultDir(this.getConfig()));
        if (!dir.exists()) {
            throw new MatrixException("no results found");
        }
        if (!new File(dir, "properties.csv").exists()) {
            new MatrixSystemProperties().exportToFile(FileFormat.CSV, new File(dir, "properties.csv"), new Object[0]);
        }
        if (!new File(dir, "environment.csv").exists()) {
            new MatrixSystemEnvironment().exportToFile(FileFormat.CSV, new File(dir, "environment.csv"), new Object[0]);
        }
        HashMap<String, ArrayList<Matrix>> statistics = new HashMap<String, ArrayList<Matrix>>();
        List<File> dirs = Arrays.asList(dir.listFiles());
        Collections.sort(dirs);
        for (File f : dirs) {
            if (!f.isDirectory()) continue;
            String matrixName = f.getName();
            List<File> results = Arrays.asList(f.listFiles());
            Collections.sort(results);
            for (File r : results) {
                String benchmarkName = r.getName().replaceAll(".csv", "");
                Matrix data = MatrixFactory.importFromFile(FileFormat.CSV, r, "\t");
                data.setLabel(matrixName);
                ArrayList<Matrix> list = (List)statistics.get(benchmarkName);
                if (list == null) {
                    list = new ArrayList<Matrix>();
                    statistics.put(benchmarkName, list);
                }
                list.add(data);
            }
        }
        for (String benchmarkName : statistics.keySet()) {
            List list = (List)statistics.get(benchmarkName);
            ArrayList<Matrix> means = new ArrayList<Matrix>();
            ArrayList<Matrix> stds = new ArrayList<Matrix>();
            ArrayList<Matrix> mins = new ArrayList<Matrix>();
            ArrayList<Matrix> maxs = new ArrayList<Matrix>();
            for (Matrix m : list) {
                Matrix data = m.deleteRows(Calculation.Ret.NEW, 0L);
                Matrix columnLabels = m.selectRows(Calculation.Ret.NEW, 0L);
                Matrix mean = data.mean(Calculation.Ret.NEW, 0, true);
                mean.setLabel(String.valueOf(m.getLabel()) + "-" + benchmarkName + "-mean");
                mean.getAnnotation().setDimensionMatrix(0, columnLabels);
                means.add(mean);
                Matrix std = data.std(Calculation.Ret.NEW, 0, true);
                std.setLabel(String.valueOf(m.getLabel()) + "-" + benchmarkName + "-std");
                std.getAnnotation().setDimensionMatrix(0, columnLabels);
                stds.add(std);
                Matrix matrix = data.min(Calculation.Ret.NEW, 0);
                matrix.setLabel(String.valueOf(m.getLabel()) + "-" + benchmarkName + "-min");
                matrix.getAnnotation().setDimensionMatrix(0, columnLabels);
                mins.add(matrix);
                Matrix max = data.max(Calculation.Ret.NEW, 0);
                max.setLabel(String.valueOf(m.getLabel()) + "-" + benchmarkName + "-max");
                max.getAnnotation().setDimensionMatrix(0, columnLabels);
                maxs.add(max);
            }
            Matrix allmeans = null;
            try {
                allmeans = MatrixFactory.vertCat(means);
                allmeans.setLabel(String.valueOf(benchmarkName) + "-mean");
                DefaultListMatrix matrixLabels = new DefaultListMatrix();
                for (Matrix m : means) {
                    matrixLabels.add(m.getLabel().split("-")[0]);
                }
                allmeans.getAnnotation().setDimensionMatrix(1, matrixLabels);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!allmeans.getLabel().contains("diff")) {
                try {
                    long jamaRow = allmeans.getRowForLabel(JamaDenseDoubleMatrix2D.class.getSimpleName());
                    if (jamaRow < 0L) {
                        jamaRow = allmeans.getRowForLabel(DefaultDenseDoubleMatrix2D.class.getSimpleName());
                    }
                    Matrix valueCount = Matrix.factory.zeros(1L, allmeans.getColumnCount());
                    int c = 0;
                    while ((long)c < valueCount.getColumnCount()) {
                        int s = this.extractSize(allmeans.getColumnLabel(c));
                        if (allmeans.getLabel().contains("tall")) {
                            valueCount.setAsInt(s * s / 2, 0L, c);
                        } else {
                            valueCount.setAsInt(s * s, 0L, c);
                        }
                        ++c;
                    }
                    valueCount = MatrixFactory.vertCat(valueCount, allmeans.getRowCount());
                    Matrix perCell = allmeans.divide(Calculation.Ret.NEW, false, valueCount).transpose(Calculation.Ret.NEW);
                    perCell.setLabel(String.valueOf(allmeans.getLabel()) + "-percell");
                    int r = 0;
                    while ((long)r < perCell.getRowCount()) {
                        perCell.setRowLabel(r, perCell.getRowLabel(r).split("x")[0]);
                        ++r;
                    }
                    this.export(perCell);
                    Matrix row = allmeans.selectRows(Calculation.Ret.NEW, jamaRow);
                    Matrix matrix = MatrixFactory.vertCat(row, allmeans.getRowCount());
                    Matrix scaled = allmeans.divide(Calculation.Ret.NEW, false, matrix).power(Calculation.Ret.NEW, -1.0).transpose(Calculation.Ret.NEW);
                    scaled.setLabel(String.valueOf(allmeans.getLabel()) + "-scaled");
                    int r2 = 0;
                    while ((long)r2 < scaled.getRowCount()) {
                        scaled.setRowLabel(r2, scaled.getRowLabel(r2).split("x")[0]);
                        ++r2;
                    }
                    this.export(scaled);
                }
                catch (Exception jamaRow) {
                    // empty catch block
                }
            }
            this.export(allmeans.transpose(Calculation.Ret.NEW));
            Matrix allstds = null;
            Matrix stdPercent = null;
            try {
                allstds = MatrixFactory.vertCat(stds);
                stdPercent = allstds.divide(Calculation.Ret.NEW, false, allmeans).times(Calculation.Ret.NEW, false, 100.0);
                allstds.setLabel(String.valueOf(benchmarkName) + "-std");
                stdPercent.setLabel(String.valueOf(benchmarkName) + "-stdpercent");
                DefaultListMatrix stdLabels = new DefaultListMatrix();
                for (Matrix m : stds) {
                    stdLabels.add(m.getLabel().split("-")[0]);
                }
                allstds.getAnnotation().setDimensionMatrix(1, stdLabels);
                stdPercent.getAnnotation().setDimensionMatrix(1, stdLabels);
            }
            catch (Exception e) {
                System.err.println("could not evaluate std results for " + benchmarkName + ": " + e);
            }
            this.export(allstds.transpose(Calculation.Ret.NEW));
            this.export(stdPercent.transpose(Calculation.Ret.NEW));
            Matrix allmins = null;
            try {
                allmins = MatrixFactory.vertCat(mins);
                allmins.setLabel(String.valueOf(benchmarkName) + "-min");
                DefaultListMatrix minLabels = new DefaultListMatrix();
                for (Matrix m : mins) {
                    minLabels.add(m.getLabel().split("-")[0]);
                }
                allmins.getAnnotation().setDimensionMatrix(1, minLabels);
            }
            catch (Exception e) {
                System.err.println("could not evaluate min results for " + benchmarkName + ": " + e);
            }
            this.export(allmins.transpose(Calculation.Ret.NEW));
            Matrix allmaxs = null;
            try {
                allmaxs = MatrixFactory.vertCat(maxs);
                allmaxs.setLabel(String.valueOf(benchmarkName) + "-max");
                DefaultListMatrix maxLabels = new DefaultListMatrix();
                for (Matrix matrix : maxs) {
                    maxLabels.add(matrix.getLabel().split("-")[0]);
                }
                allmaxs.getAnnotation().setDimensionMatrix(1, maxLabels);
            }
            catch (Exception e) {
                System.err.println("could not evaluate max results for " + benchmarkName + ": " + e);
            }
            this.export(allmaxs.transpose(Calculation.Ret.NEW));
            System.out.println(allmeans);
            System.out.println();
        }
    }

    private void export(Matrix matrix) {
        String name = matrix.getLabel();
        int r = 0;
        while ((long)r < matrix.getRowCount()) {
            matrix.setRowLabel(r, String.valueOf(this.extractSize(matrix.getRowLabel(r))));
            ++r;
        }
        Matrix firstPart = MatrixFactory.horCat(MatrixFactory.linkToValue(matrix.getLabel()), matrix.getAnnotation().getDimensionMatrix(0));
        Matrix lastPart = MatrixFactory.horCat(matrix.getAnnotation().getDimensionMatrix(1), matrix);
        Matrix complete = MatrixFactory.vertCat(firstPart, lastPart);
        try {
            complete.exportToFile(FileFormat.CSV, new File(String.valueOf(BenchmarkUtil.getResultDir(this.getConfig())) + name + ".csv"), new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            complete.exportToFile(FileFormat.XLS, new File(String.valueOf(BenchmarkUtil.getResultDir(this.getConfig())) + name + ".xls"), new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Matrix plt = complete.deleteRows(Calculation.Ret.NEW, 0L);
            plt.setColumnLabel(0L, "matrix size");
            int c = 1;
            while ((long)c < plt.getColumnCount()) {
                plt.setColumnLabel(c, matrix.getColumnLabel(c - 1));
                ++c;
            }
            plt.setLabel(matrix.getLabel());
            Object[] params = null;
            params = matrix.getLabel().contains("stdpercent") ? new Object[]{"xy", "logx"} : new Object[]{"xy", "logx", "logy"};
            plt.exportToFile(FileFormat.PLT, new File(String.valueOf(BenchmarkUtil.getResultDir(this.getConfig())) + name + ".plt"), params);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public DoubleMatrix2D createMatrix(long ... size) throws MatrixException {
        return null;
    }

    @Override
    public DoubleMatrix2D createMatrix(Matrix source) throws MatrixException {
        return null;
    }

    private int extractSize(String s) {
        if (s != null && !"null".equals(s)) {
            if (s.contains("x")) {
                return (int)Coordinates.parseString(s)[0];
            }
            return Integer.parseInt(s);
        }
        return 0;
    }
}

