/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.benchmark;

import java.util.LinkedList;
import java.util.List;
import org.ujmp.core.mapmatrix.DefaultMapMatrix;
import org.ujmp.core.util.MathUtil;
import org.ujmp.core.util.StringUtil;
import org.ujmp.core.util.UJMPSettings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BenchmarkConfig
extends DefaultMapMatrix<String, Object> {
    private static final long serialVersionUID = 2267893158983793396L;
    public static final double NOTAVAILABLE = 0.0;
    public static final double ERROR = Double.NaN;

    public BenchmarkConfig() {
        this.put("name", null);
        this.put("numberOfThreads", UJMPSettings.getNumberOfThreads());
        this.put("reverse", false);
        this.put("shuffle", false);
        this.put("gcMemory", true);
        this.put("purgeMemory", true);
        this.put("burnInRuns", 3);
        this.put("runs", 25);
        this.put("minTrialCount", 1);
        this.put("maxTrialCount", 5);
        this.put("maxTime", 10000);
        this.put("maxStd", 10);
        this.put("maxSize", 10000);
        this.put("runTimesScalar", true);
        this.put("runPlusMatrix", true);
        this.put("runTranspose", true);
        this.put("runMtimes", true);
        this.put("runInv", true);
        this.put("runInvSPD", true);
        this.put("runSolveSquare", true);
        this.put("runSolveTall", true);
        this.put("runSVD", true);
        this.put("runEig", true);
        this.put("runChol", false);
        this.put("runLU", false);
        this.put("runQR", false);
        this.put("runDefaultDenseDoubleMatrix2D", true);
        this.put("runArrayDenseDoubleMatrix2D", true);
        this.put("runBlockDenseDoubleMatrix2D", true);
        this.put("runJBlasDenseDoubleMatrix2D", true);
        this.put("runMTJDenseDoubleMatrix2D", true);
        this.put("runOjalgoDenseDoubleMatrix2D", true);
        this.put("runOrbitalDenseDoubleMatrix2D", false);
        this.put("runOwlpackDenseDoubleMatrix2D", false);
        this.put("runJScienceDenseDoubleMatrix2D", false);
        this.put("runJSciDenseDoubleMatrix2D", false);
        this.put("runJMathArrayDenseDoubleMatrix2D", false);
        this.put("runJLinAlgDenseDoubleMatrix2D", false);
        this.put("runParallelColtDenseDoubleMatrix2D", true);
        this.put("runColtDenseDoubleMatrix2D", true);
        this.put("runSSTDenseDoubleMatrix2D", false);
        this.put("runCommonsMathArrayDenseDoubleMatrix2D", true);
        this.put("runCommonsMathBlockDenseDoubleMatrix2D", true);
        this.put("runEJMLDenseDoubleMatrix2D", true);
        this.put("runJamaDenseDoubleMatrix2D", true);
        this.put("runJampackDenseDoubleMatrix2D", false);
        this.put("runJMatricesDenseDoubleMatrix2D", false);
        this.put("runMantissaDenseDoubleMatrix2D", false);
        this.put("runVecMathDenseDoubleMatrix2D", false);
        this.put("useJBlas", true);
        this.put("useBlockMatrixMultiply", true);
        this.put("useOjalgo", true);
        this.put("useEJML", true);
        this.put("useMTJ", true);
        this.put("useParallelColt", true);
        this.put("useCommonsMath", true);
        this.put("defaultBlockSize", 100);
    }

    public List<long[]> getSVDSizes() {
        return this.getSquareSizes();
    }

    public boolean isRunTimesScalar() {
        return MathUtil.getBoolean(this.get("runTimesScalar"));
    }

    public void setRunTimesScalar(boolean runTimesScalar) {
        this.put("runTimesScalar", runTimesScalar);
    }

    public boolean isRunPlusMatrix() {
        return MathUtil.getBoolean(this.get("runPlusMatrix"));
    }

    public void setRunPlusMatrix(boolean runPlusMatrix) {
        this.put("runPlusMatrix", runPlusMatrix);
    }

    public boolean isRunTranspose() {
        return MathUtil.getBoolean(this.get("runTranspose"));
    }

    public void setRunTranspose(boolean runTranspose) {
        this.put("runTranspose", runTranspose);
    }

    public boolean isRunMtimes() {
        return MathUtil.getBoolean(this.get("runMtimes"));
    }

    public void setRunMtimes(boolean runMtimes) {
        this.put("runMtimes", runMtimes);
    }

    public boolean isRunInv() {
        return MathUtil.getBoolean(this.get("runInv"));
    }

    public boolean isRunInvSPD() {
        return MathUtil.getBoolean(this.get("runInvSPD"));
    }

    public void setRunInv(boolean runInv) {
        this.put("runInv", runInv);
    }

    public void setRunInvSPD(boolean runInv) {
        this.put("runInvSPD", runInv);
    }

    public boolean isRunSolveSquare() {
        return MathUtil.getBoolean(this.get("runSolveSquare"));
    }

    public void setRunSolveSquare(boolean runSolveSquare) {
        this.put("runSolveSquare", runSolveSquare);
    }

    public boolean isRunSolveTall() {
        return MathUtil.getBoolean(this.get("runSolveTall"));
    }

    public void setRunSolveTall(boolean runSolveTall) {
        this.put("runSolveTall", runSolveTall);
    }

    public boolean isRunSVD() {
        return MathUtil.getBoolean(this.get("runSVD"));
    }

    public void setRunSVD(boolean runSVD) {
        this.put("runSVD", runSVD);
    }

    public int getNumberOfThreads() {
        return MathUtil.getInt(this.get("numberOfThreads"));
    }

    public void setNumberOfThreads(int numberOfThreads) {
        this.put("numberOfThreads", numberOfThreads);
    }

    public boolean isRunEig() {
        return MathUtil.getBoolean(this.get("runEig"));
    }

    public void setRunEig(boolean runEig) {
        this.put("runEig", runEig);
    }

    public boolean isRunChol() {
        return MathUtil.getBoolean(this.get("runChol"));
    }

    public void setRunChol(boolean runChol) {
        this.put("runChol", runChol);
    }

    public boolean isRunLU() {
        return MathUtil.getBoolean(this.get("runLU"));
    }

    public void setRunLU(boolean runLU) {
        this.put("runLU", runLU);
    }

    public boolean isRunQR() {
        return MathUtil.getBoolean(this.get("runQR"));
    }

    public void setRunQR(boolean runQR) {
        this.put("runQR", runQR);
    }

    public int getBurnInRuns() {
        return MathUtil.getInt(this.get("burnInRuns"));
    }

    public int getMinTrialCount() {
        return MathUtil.getInt(this.get("minTrialCount"));
    }

    public void setMinTrialCount(int minTrialCount) {
        this.put("minTrialCount", minTrialCount);
    }

    public int getMaxTrialCount() {
        return MathUtil.getInt(this.get("maxTrialCount"));
    }

    public void setMaxTrialCount(int maxTrialCount) {
        this.put("maxTrialCount", maxTrialCount);
    }

    public void setBurnInRuns(int burnInRuns) {
        this.put("burnInRuns", burnInRuns);
    }

    public int getRuns() {
        return MathUtil.getInt(this.get("runs"));
    }

    public void setRuns(int runs) {
        this.put("runs", runs);
    }

    public List<long[]> getSquareSizes() {
        LinkedList<long[]> sizes = new LinkedList<long[]>();
        int maxSize = this.getMaxSize();
        sizes.add(new long[]{2L, 2L});
        if (maxSize >= 3) {
            sizes.add(new long[]{3L, 3L});
        }
        if (maxSize >= 4) {
            sizes.add(new long[]{4L, 4L});
        }
        if (maxSize >= 5) {
            sizes.add(new long[]{5L, 5L});
        }
        if (maxSize >= 10) {
            sizes.add(new long[]{10L, 10L});
        }
        if (maxSize >= 20) {
            sizes.add(new long[]{20L, 20L});
        }
        if (maxSize >= 50) {
            sizes.add(new long[]{50L, 50L});
        }
        if (maxSize >= 100) {
            sizes.add(new long[]{100L, 100L});
        }
        if (maxSize >= 200) {
            sizes.add(new long[]{200L, 200L});
        }
        if (maxSize >= 500) {
            sizes.add(new long[]{500L, 500L});
        }
        if (maxSize >= 1000) {
            sizes.add(new long[]{1000L, 1000L});
        }
        if (maxSize >= 2000) {
            sizes.add(new long[]{2000L, 2000L});
        }
        if (maxSize >= 5000) {
            sizes.add(new long[]{5000L, 5000L});
        }
        if (maxSize >= 10000) {
            sizes.add(new long[]{10000L, 10000L});
        }
        return sizes;
    }

    public List<long[]> getTallSizes() {
        LinkedList<long[]> sizes = new LinkedList<long[]>();
        for (long[] s : this.getSquareSizes()) {
            s = (long[])s.clone();
            s[0] = s[0] * 2L;
            sizes.add(s);
        }
        return sizes;
    }

    public List<long[]> getTransposeSizes() {
        return this.getSquareSizes();
    }

    public List<long[]> getTimesSizes() {
        return this.getSquareSizes();
    }

    public List<long[]> getPlusSizes() {
        return this.getSquareSizes();
    }

    public List<long[]> getMtimesSizes() {
        return this.getSquareSizes();
    }

    public List<long[]> getInvSizes() {
        return this.getSquareSizes();
    }

    public List<long[]> getSolveSquareSizes() {
        return this.getSquareSizes();
    }

    public List<long[]> getSolveTallSizes() {
        return this.getTallSizes();
    }

    public List<long[]> getEigSizes() {
        return this.getSquareSizes();
    }

    public List<long[]> getQRSizes() {
        return this.getSquareSizes();
    }

    public List<long[]> getLUSizes() {
        return this.getSquareSizes();
    }

    public List<long[]> getCholSizes() {
        return this.getSquareSizes();
    }

    public boolean isRunDefaultDenseDoubleMatrix2D() {
        return MathUtil.getBoolean(this.get("runDefaultDenseDoubleMatrix2D"));
    }

    public void setRunDefaultDenseDoubleMatrix2D(boolean runDefaultDenseDoubleMatrix2D) {
        this.put("runDefaultDenseDoubleMatrix2D", runDefaultDenseDoubleMatrix2D);
    }

    public boolean isRunArrayDenseDoubleMatrix2D() {
        return MathUtil.getBoolean(this.get("runArrayDenseDoubleMatrix2D"));
    }

    public boolean isRunBlockDenseDoubleMatrix2D() {
        return MathUtil.getBoolean(this.get("runBlockDenseDoubleMatrix2D"));
    }

    public void setRunArrayDenseDoubleMatrix2D(boolean runArrayDenseDoubleMatrix2D) {
        this.put("runArrayDenseDoubleMatrix2D", runArrayDenseDoubleMatrix2D);
    }

    public void setRunBlockDenseDoubleMatrix2D(boolean runBlockDenseDoubleMatrix2D) {
        this.put("runBlockDenseDoubleMatrix2D", runBlockDenseDoubleMatrix2D);
    }

    public boolean isRunMTJDenseDoubleMatrix2D() {
        return MathUtil.getBoolean(this.get("runMTJDenseDoubleMatrix2D"));
    }

    public void setRunMTJDenseDoubleMatrix2D(boolean runMTJDenseDoubleMatrix2D) {
        this.put("runMTJDenseDoubleMatrix2D", runMTJDenseDoubleMatrix2D);
    }

    public boolean isRunOjalgoDenseDoubleMatrix2D() {
        return MathUtil.getBoolean(this.get("runOjalgoDenseDoubleMatrix2D"));
    }

    public void setRunOjalgoDenseDoubleMatrix2D(boolean runOjalgoDenseDoubleMatrix2D) {
        this.put("runOjalgoDenseDoubleMatrix2D", runOjalgoDenseDoubleMatrix2D);
    }

    public boolean isRunOrbitalDenseDoubleMatrix2D() {
        return MathUtil.getBoolean(this.get("runOrbitalDenseDoubleMatrix2D"));
    }

    public void setRunOrbitalDenseDoubleMatrix2D(boolean runOrbitalDenseDoubleMatrix2D) {
        this.put("runOrbitalDenseDoubleMatrix2D", runOrbitalDenseDoubleMatrix2D);
    }

    public boolean isRunOwlpackDenseDoubleMatrix2D() {
        return MathUtil.getBoolean(this.get("runOwlpackDenseDoubleMatrix2D"));
    }

    public void setRunOwlpackDenseDoubleMatrix2D(boolean runOwlpackDenseDoubleMatrix2D) {
        this.put("runOwlpackDenseDoubleMatrix2D", runOwlpackDenseDoubleMatrix2D);
    }

    public boolean isRunJScienceDenseDoubleMatrix2D() {
        return MathUtil.getBoolean(this.get("runJScienceDenseDoubleMatrix2D"));
    }

    public void setRunJScienceDenseDoubleMatrix2D(boolean runJScienceDenseDoubleMatrix2D) {
        this.put("runJScienceDenseDoubleMatrix2D", runJScienceDenseDoubleMatrix2D);
    }

    public boolean isRunJSciDenseDoubleMatrix2D() {
        return MathUtil.getBoolean(this.get("runJSciDenseDoubleMatrix2D"));
    }

    public void setRunJSciDenseDoubleMatrix2D(boolean runJSciDenseDoubleMatrix2D) {
        this.put("runJSciDenseDoubleMatrix2D", runJSciDenseDoubleMatrix2D);
    }

    public boolean isRunJMathArrayDenseDoubleMatrix2D() {
        return MathUtil.getBoolean(this.get("runJMathArrayDenseDoubleMatrix2D"));
    }

    public void setRunJMathArrayDenseDoubleMatrix2D(boolean runJMathArrayDenseDoubleMatrix2D) {
        this.put("runJMathArrayDenseDoubleMatrix2D", runJMathArrayDenseDoubleMatrix2D);
    }

    public boolean isRunJLinAlgDenseDoubleMatrix2D() {
        return MathUtil.getBoolean(this.get("runJLinAlgDenseDoubleMatrix2D"));
    }

    public void setRunJLinAlgDenseDoubleMatrix2D(boolean runJLinAlgDenseDoubleMatrix2D) {
        this.put("runJLinAlgDenseDoubleMatrix2D", runJLinAlgDenseDoubleMatrix2D);
    }

    public boolean isRunParallelColtDenseDoubleMatrix2D() {
        return MathUtil.getBoolean(this.get("runParallelColtDenseDoubleMatrix2D"));
    }

    public void setRunParallelColtDenseDoubleMatrix2D(boolean runParallelColtDenseDoubleMatrix2D) {
        this.put("runParallelColtDenseDoubleMatrix2D", runParallelColtDenseDoubleMatrix2D);
    }

    public boolean isRunColtDenseDoubleMatrix2D() {
        return MathUtil.getBoolean(this.get("runColtDenseDoubleMatrix2D"));
    }

    public void setRunColtDenseDoubleMatrix2D(boolean runColtDenseDoubleMatrix2D) {
        this.put("runColtDenseDoubleMatrix2D", runColtDenseDoubleMatrix2D);
    }

    public boolean isRunSSTDenseDoubleMatrix2D() {
        return MathUtil.getBoolean(this.get("runSSTDenseDoubleMatrix2D"));
    }

    public void setRunSSTDenseDoubleMatrix2D(boolean runSSTDenseDoubleMatrix2D) {
        this.put("runSSTDenseDoubleMatrix2D", runSSTDenseDoubleMatrix2D);
    }

    public boolean isRunCommonsMathArrayDenseDoubleMatrix2D() {
        return MathUtil.getBoolean(this.get("runCommonsMathArrayDenseDoubleMatrix2D"));
    }

    public void setRunCommonsMathArrayDenseDoubleMatrix2D(boolean runCommonsMathArrayDenseDoubleMatrix2D) {
        this.put("runCommonsMathArrayDenseDoubleMatrix2D", runCommonsMathArrayDenseDoubleMatrix2D);
    }

    public boolean isRunCommonsMathBlockDenseDoubleMatrix2D() {
        return MathUtil.getBoolean(this.get("runCommonsMathBlockDenseDoubleMatrix2D"));
    }

    public void setRunCommonsMathBlockDenseDoubleMatrix2D(boolean runCommonsMathBlockDenseDoubleMatrix2D) {
        this.put("runCommonsMathBlockDenseDoubleMatrix2D", runCommonsMathBlockDenseDoubleMatrix2D);
    }

    public boolean isRunEJMLDenseDoubleMatrix2D() {
        return MathUtil.getBoolean(this.get("runEJMLDenseDoubleMatrix2D"));
    }

    public void setRunEJMLDenseDoubleMatrix2D(boolean runEJMLDenseDoubleMatrix2D) {
        this.put("runEJMLDenseDoubleMatrix2D", runEJMLDenseDoubleMatrix2D);
    }

    public boolean isRunJamaDenseDoubleMatrix2D() {
        return MathUtil.getBoolean(this.get("runJamaDenseDoubleMatrix2D"));
    }

    public void setRunJamaDenseDoubleMatrix2D(boolean runJamaDenseDoubleMatrix2D) {
        this.put("runJamaDenseDoubleMatrix2D", runJamaDenseDoubleMatrix2D);
    }

    public boolean isRunJampackDenseDoubleMatrix2D() {
        return MathUtil.getBoolean(this.get("runJampackDenseDoubleMatrix2D"));
    }

    public void setRunJampackDenseDoubleMatrix2D(boolean runJampackDenseDoubleMatrix2D) {
        this.put("runJampackDenseDoubleMatrix2D", runJampackDenseDoubleMatrix2D);
    }

    public boolean isRunJMatricesDenseDoubleMatrix2D() {
        return MathUtil.getBoolean(this.get("runJMatricesDenseDoubleMatrix2D"));
    }

    public void setRunJMatricesDenseDoubleMatrix2D(boolean runJMatricesDenseDoubleMatrix2D) {
        this.put("runJMatricesDenseDoubleMatrix2D", runJMatricesDenseDoubleMatrix2D);
    }

    public boolean isRunMantissaDenseDoubleMatrix2D() {
        return MathUtil.getBoolean(this.get("runMantissaDenseDoubleMatrix2D"));
    }

    public void setRunMantissaDenseDoubleMatrix2D(boolean runMantissaDenseDoubleMatrix2D) {
        this.put("runMantissaDenseDoubleMatrix2D", runMantissaDenseDoubleMatrix2D);
    }

    public boolean isRunVecMathDenseDoubleMatrix2D() {
        return MathUtil.getBoolean(this.get("runVecMathDenseDoubleMatrix2D"));
    }

    public void setRunVecMathDenseDoubleMatrix2D(boolean runVecMathDenseDoubleMatrix2D) {
        this.put("runVecMathDenseDoubleMatrix2D", runVecMathDenseDoubleMatrix2D);
    }

    public int getMaxTime() {
        return MathUtil.getInt(this.get("maxTime"));
    }

    public int getMaxSize() {
        return MathUtil.getInt(this.get("maxSize"));
    }

    public void setMaxTime(int maxTime) {
        this.put("maxTime", maxTime);
    }

    public void setMaxSize(int maxSize) {
        this.put("maxSize", maxSize);
    }

    public double getMaxStd() {
        return MathUtil.getDouble(this.get("maxStd"));
    }

    public void setMaxStd(double maxStd) {
        this.put("maxStd", maxStd);
    }

    public boolean isGCMemory() {
        return MathUtil.getBoolean(this.get("gcMemory"));
    }

    public void setGCMemory(boolean gcMemory) {
        this.put("gcMemory", gcMemory);
    }

    public boolean isPurgeMemory() {
        return MathUtil.getBoolean(this.get("purgeMemory"));
    }

    public void setPurgeMemory(boolean purgeMemory) {
        this.put("purgeMemory", purgeMemory);
    }

    public boolean isShuffle() {
        return MathUtil.getBoolean(this.get("shuffle"));
    }

    public void setShuffle(boolean shuffle) {
        this.put("shuffle", shuffle);
    }

    public boolean isReverse() {
        return MathUtil.getBoolean(this.get("reverse"));
    }

    public void setReverse(boolean reverse) {
        this.put("reverse", reverse);
    }

    public String getName() {
        return StringUtil.getString(this.get("name"));
    }

    public boolean isRunJBlasDenseDoubleMatrix2D() {
        return MathUtil.getBoolean(this.get("runJBlasDenseDoubleMatrix2D"));
    }

    public void setRunJBlasDenseDoubleMatrix2D(boolean runJBlas) {
        this.put("runJBlasDenseDoubleMatrix2D", runJBlas);
    }

    public void setUseJBlas(boolean use) {
        this.put("useJBlas", use);
    }

    public boolean isUseJBlas() {
        return MathUtil.getBoolean(this.get("useJBlas"));
    }

    public void setUseMTJ(boolean use) {
        this.put("useMTJ", use);
    }

    public boolean isUseMTJ() {
        return MathUtil.getBoolean(this.get("useMTJ"));
    }

    public void setUseOjalgo(boolean use) {
        this.put("useOjalgo", use);
    }

    public boolean isUseOjalgo() {
        return MathUtil.getBoolean(this.get("useOjalgo"));
    }

    public void setUseEJML(boolean use) {
        this.put("useEJML", use);
    }

    public boolean isUseEJML() {
        return MathUtil.getBoolean(this.get("useEJML"));
    }

    public boolean isUseBlockMatrixMultiply() {
        return MathUtil.getBoolean(this.get("useBlockMatrixMultiply"));
    }

    public int getDefaultBlockSize() {
        return MathUtil.getInt(this.get("defaultBlockSize"));
    }

    public void setUseBlockMatrixMultiply(boolean use) {
        this.put("useBlockMatrixMultiply", use);
    }

    public void setDefaultBlockSize(int size) {
        this.put("defaultBlockSize", size);
    }

    public void setUseParallelColt(boolean use) {
        this.put("useParallelColt", use);
    }

    public boolean isUseParallelColt() {
        return MathUtil.getBoolean(this.get("useParallelColt"));
    }

    public void setUseCommonsMath(boolean use) {
        this.put("useCommonsMath", use);
    }

    public boolean isUseCommonsMath() {
        return MathUtil.getBoolean(this.get("useCommonsMath"));
    }

    public void setName(String name) {
        this.put("name", name);
    }
}

