/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.calculation.entrywise.creators;

import org.ujmp.core.Matrix;
import org.ujmp.core.MatrixFactory;
import org.ujmp.core.doublematrix.calculation.AbstractDoubleCalculation;
import org.ujmp.core.enums.ValueType;
import org.ujmp.core.exceptions.MatrixException;

public class Ones
extends AbstractDoubleCalculation {
    private static final long serialVersionUID = 2547827499345834225L;

    public Ones(Matrix matrix) {
        super(matrix);
    }

    public double getDouble(long ... coordinates) {
        return 1.0;
    }

    public static Matrix calc(Matrix source) throws MatrixException {
        Matrix ret = Matrix.factory.zeros(source.getSize());
        for (long[] c : source.allCoordinates()) {
            ret.setAsDouble(1.0, c);
        }
        return ret;
    }

    public static Matrix calc(long ... size) throws MatrixException {
        return Ones.calc(ValueType.DOUBLE, size);
    }

    public static Matrix calc(ValueType valueType, long ... size) throws MatrixException {
        Matrix ret = MatrixFactory.zeros(valueType, size);
        for (long[] c : ret.allCoordinates()) {
            ret.setAsDouble(1.0, c);
        }
        return ret;
    }
}

