/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.calculation.general.decomposition;

import org.ujmp.core.Matrix;
import org.ujmp.core.MatrixFactory;
import org.ujmp.core.doublematrix.DenseDoubleMatrix2D;
import org.ujmp.core.util.DecompositionOps;
import org.ujmp.core.util.UJMPSettings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface LU<T> {
    public static final int THRESHOLD = 100;
    public static final LU<Matrix> MATRIX = new LU<Matrix>(){

        public final Matrix[] calc(Matrix source) {
            if (UJMPSettings.getNumberOfThreads() == 1) {
                if (source.getRowCount() >= 100L && source.getColumnCount() >= 100L) {
                    return MATRIXLARGESINGLETHREADED.calc(source);
                }
                return MATRIXSMALLSINGLETHREADED.calc(source);
            }
            if (source.getRowCount() >= 100L && source.getColumnCount() >= 100L) {
                return MATRIXLARGEMULTITHREADED.calc(source);
            }
            return MATRIXSMALLMULTITHREADED.calc(source);
        }

        @Override
        public final Matrix solve(Matrix source, Matrix b) {
            if (UJMPSettings.getNumberOfThreads() == 1) {
                if (source.getRowCount() >= 100L && source.getColumnCount() >= 100L) {
                    return MATRIXLARGESINGLETHREADED.solve(source, b);
                }
                return MATRIXSMALLSINGLETHREADED.solve(source, b);
            }
            if (source.getRowCount() >= 100L && source.getColumnCount() >= 100L) {
                return MATRIXLARGEMULTITHREADED.solve(source, b);
            }
            return MATRIXSMALLMULTITHREADED.solve(source, b);
        }
    };
    public static final LU<Matrix> INSTANCE = MATRIX;
    public static final LU<Matrix> UJMP = new LU<Matrix>(){

        public final Matrix[] calc(Matrix source) {
            LUMatrix lu = new LUMatrix(source);
            return new Matrix[]{lu.getL(), lu.getU(), lu.getP()};
        }

        @Override
        public final Matrix solve(Matrix source, Matrix b) {
            LUMatrix lu = new LUMatrix(source);
            return lu.solve(b);
        }
    };
    public static final LU<Matrix> MATRIXSMALLMULTITHREADED = UJMP;
    public static final LU<Matrix> MATRIXSMALLSINGLETHREADED = UJMP;
    public static final LU<Matrix> MATRIXLARGESINGLETHREADED = new LU<Matrix>(){

        public final Matrix[] calc(Matrix source) {
            LU lu = null;
            if (UJMPSettings.isUseJBlas()) {
                lu = DecompositionOps.LU_JBLAS;
            }
            if (lu == null) {
                lu = UJMP;
            }
            return lu.calc(source);
        }

        @Override
        public final Matrix solve(Matrix source, Matrix b) {
            LU lu = null;
            if (UJMPSettings.isUseJBlas()) {
                lu = DecompositionOps.LU_JBLAS;
            }
            if (lu == null && UJMPSettings.isUseOjalgo()) {
                lu = DecompositionOps.LU_OJALGO;
            }
            if (lu == null) {
                lu = UJMP;
            }
            return lu.solve(source, b);
        }
    };
    public static final LU<Matrix> MATRIXLARGEMULTITHREADED = new LU<Matrix>(){

        public final Matrix[] calc(Matrix source) {
            LU lu = null;
            if (UJMPSettings.isUseJBlas()) {
                lu = DecompositionOps.LU_JBLAS;
            }
            if (lu == null && UJMPSettings.isUseOjalgo()) {
                lu = DecompositionOps.LU_OJALGO;
            }
            if (lu == null) {
                lu = UJMP;
            }
            return lu.calc(source);
        }

        @Override
        public final Matrix solve(Matrix source, Matrix b) {
            LU lu = null;
            if (UJMPSettings.isUseJBlas()) {
                lu = DecompositionOps.LU_JBLAS;
            }
            if (lu == null && UJMPSettings.isUseOjalgo()) {
                lu = DecompositionOps.LU_OJALGO;
            }
            if (lu == null) {
                lu = UJMP;
            }
            return lu.solve(source, b);
        }
    };

    public T[] calc(T var1);

    public T solve(T var1, T var2);

    public static final class LUMatrix {
        private final double[][] LU;
        private final int m;
        private final int n;
        private int pivsign;
        private final int[] piv;

        public LUMatrix(Matrix A) {
            this.LU = A.toDoubleArray();
            this.m = (int)A.getRowCount();
            this.n = (int)A.getColumnCount();
            this.piv = new int[this.m];
            int i = 0;
            while (i < this.m) {
                this.piv[i] = i;
                ++i;
            }
            this.pivsign = 1;
            double[] LUcolj = new double[this.m];
            double[] LUrowi = null;
            int j = 0;
            while (j < this.n) {
                int i2 = 0;
                while (i2 < this.m) {
                    LUcolj[i2] = this.LU[i2][j];
                    ++i2;
                }
                i2 = 0;
                while (i2 < this.m) {
                    LUrowi = this.LU[i2];
                    int kmax = Math.min(i2, j);
                    double s = 0.0;
                    int k = 0;
                    while (k < kmax) {
                        s += LUrowi[k] * LUcolj[k];
                        ++k;
                    }
                    int n = i2++;
                    double d = LUcolj[n] - s;
                    LUcolj[n] = d;
                    LUrowi[j] = d;
                }
                int p = j;
                int i3 = j + 1;
                while (i3 < this.m) {
                    if (Math.abs(LUcolj[i3]) > Math.abs(LUcolj[p])) {
                        p = i3;
                    }
                    ++i3;
                }
                if (p != j) {
                    int k = 0;
                    while (k < this.n) {
                        double t = this.LU[p][k];
                        this.LU[p][k] = this.LU[j][k];
                        this.LU[j][k] = t;
                        ++k;
                    }
                    k = this.piv[p];
                    this.piv[p] = this.piv[j];
                    this.piv[j] = k;
                    this.pivsign = -this.pivsign;
                }
                if (j < this.m && this.LU[j][j] != 0.0) {
                    i3 = j + 1;
                    while (i3 < this.m) {
                        double[] dArray = this.LU[i3];
                        int n = j;
                        dArray[n] = dArray[n] / this.LU[j][j];
                        ++i3;
                    }
                }
                ++j;
            }
        }

        public final boolean isNonsingular() {
            int j = 0;
            while (j < this.n) {
                if (this.LU[j][j] == 0.0) {
                    return false;
                }
                ++j;
            }
            return true;
        }

        public final Matrix getL() {
            int min = Math.min(this.m, this.n);
            double[][] L = new double[this.m][min];
            int i = 0;
            while (i < this.m) {
                int j = 0;
                while (j < min) {
                    if (i > j) {
                        L[i][j] = this.LU[i][j];
                    } else if (i == j) {
                        L[i][j] = 1.0;
                    }
                    ++j;
                }
                ++i;
            }
            return MatrixFactory.linkToArray(L);
        }

        public final Matrix getU() {
            int min = Math.min(this.m, this.n);
            double[][] U = new double[min][this.n];
            int i = 0;
            while (i < min) {
                int j = 0;
                while (j < this.n) {
                    if (i <= j) {
                        U[i][j] = this.LU[i][j];
                    }
                    ++j;
                }
                ++i;
            }
            return MatrixFactory.linkToArray(U);
        }

        public final int[] getPivot() {
            int[] p = new int[this.m];
            int i = 0;
            while (i < this.m) {
                p[i] = this.piv[i];
                ++i;
            }
            return p;
        }

        public final Matrix getP() {
            DenseDoubleMatrix2D p = DenseDoubleMatrix2D.factory.zeros((long)this.m, (long)this.m);
            int i = 0;
            while (i < this.m) {
                p.setDouble(1.0, i, this.piv[i]);
                ++i;
            }
            return p;
        }

        public final double[] getDoublePivot() {
            double[] vals = new double[this.m];
            int i = 0;
            while (i < this.m) {
                vals[i] = this.piv[i];
                ++i;
            }
            return vals;
        }

        public final double det() {
            if (this.m != this.n) {
                throw new IllegalArgumentException("Matrix must be square.");
            }
            double d = this.pivsign;
            int j = 0;
            while (j < this.n) {
                d *= this.LU[j][j];
                ++j;
            }
            return d;
        }

        public final Matrix solve(Matrix B) {
            int j;
            int i;
            if (B.getRowCount() != (long)this.m) {
                throw new IllegalArgumentException("Matrix row dimensions must agree.");
            }
            if (!this.isNonsingular()) {
                throw new RuntimeException("Matrix is singular.");
            }
            int nx = (int)B.getColumnCount();
            double[][] X = new double[this.piv.length][(int)B.getColumnCount()];
            if (B instanceof DenseDoubleMatrix2D) {
                DenseDoubleMatrix2D m = (DenseDoubleMatrix2D)B;
                int c = (int)B.getColumnCount();
                while (--c >= 0) {
                    int r = this.piv.length;
                    while (--r >= 0) {
                        X[r][c] = m.getDouble(this.piv[r], c);
                    }
                }
            } else {
                int c = (int)B.getColumnCount();
                while (--c >= 0) {
                    int r = this.piv.length;
                    while (--r >= 0) {
                        X[r][c] = B.getAsDouble(this.piv[r], c);
                    }
                }
            }
            int k = 0;
            while (k < this.n) {
                i = k + 1;
                while (i < this.n) {
                    j = 0;
                    while (j < nx) {
                        double[] dArray = X[i];
                        int n = j;
                        dArray[n] = dArray[n] - X[k][j] * this.LU[i][k];
                        ++j;
                    }
                    ++i;
                }
                ++k;
            }
            k = this.n - 1;
            while (k >= 0) {
                int j2 = 0;
                while (j2 < nx) {
                    double[] dArray = X[k];
                    int n = j2++;
                    dArray[n] = dArray[n] / this.LU[k][k];
                }
                i = 0;
                while (i < k) {
                    j = 0;
                    while (j < nx) {
                        double[] dArray = X[i];
                        int n = j;
                        dArray[n] = dArray[n] - X[k][j] * this.LU[i][k];
                        ++j;
                    }
                    ++i;
                }
                --k;
            }
            return MatrixFactory.linkToArray(X);
        }
    }
}

