/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.calculation.general.statistical;

import org.ujmp.core.Matrix;
import org.ujmp.core.doublematrix.calculation.AbstractDoubleCalculation;
import org.ujmp.core.exceptions.MatrixException;

public class IndexOfMin
extends AbstractDoubleCalculation {
    private static final long serialVersionUID = -8301078828905448159L;

    public IndexOfMin(int dimension, Matrix matrix) {
        super(dimension, matrix);
    }

    public double getDouble(long ... coordinates) throws MatrixException {
        double min = Double.MAX_VALUE;
        long index = -1L;
        switch (this.getDimension()) {
            case 0: {
                long r = this.getSource().getSize()[0] - 1L;
                while (r != -1L) {
                    long[] lArray = new long[]{r, coordinates[1]};
                    double v = this.getSource().getAsDouble(lArray);
                    if (v < min) {
                        min = v;
                        index = r;
                    }
                    --r;
                }
                return index;
            }
            case 1: {
                long c = this.getSource().getSize()[1] - 1L;
                while (c != -1L) {
                    long[] lArray = new long[]{coordinates[0], c};
                    double v = this.getSource().getAsDouble(lArray);
                    if (v < min) {
                        min = v;
                        index = c;
                    }
                    --c;
                }
                return index;
            }
        }
        return 0.0;
    }

    public long[] getSize() {
        switch (this.getDimension()) {
            case 0: {
                return new long[]{1L, this.getSource().getSize()[1]};
            }
            case 1: {
                return new long[]{this.getSource().getSize()[0], 1L};
            }
        }
        return null;
    }
}

