/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import org.ujmp.core.Matrix;
import org.ujmp.core.MatrixFactory;
import org.ujmp.core.enums.ValueType;

public class ImportMatrixSER {
    public static Matrix fromFile(File file, Object ... parameters) throws FileNotFoundException, IOException, ClassNotFoundException {
        FileInputStream stream = new FileInputStream(file);
        Matrix m = ImportMatrixSER.fromStream(stream, new Object[0]);
        stream.close();
        return m;
    }

    public static Matrix fromStream(InputStream stream, Object ... parameters) throws FileNotFoundException, IOException, ClassNotFoundException {
        ObjectInputStream s = new ObjectInputStream(new BufferedInputStream(stream));
        ValueType valueType = (ValueType)((Object)s.readObject());
        boolean isSparse = s.readBoolean();
        int sizeLength = s.readInt();
        long[] size = new long[sizeLength];
        int i = 0;
        while (i < sizeLength) {
            size[i] = s.readLong();
            ++i;
        }
        Matrix m = null;
        m = isSparse ? MatrixFactory.sparse(valueType, size) : MatrixFactory.dense(valueType, size);
        long[] c = new long[sizeLength];
        while (s.readBoolean()) {
            int i2 = 0;
            while (i2 < sizeLength) {
                c[i2] = s.readLong();
                ++i2;
            }
            switch (valueType) {
                case DOUBLE: {
                    m.setAsDouble(s.readDouble(), c);
                    break;
                }
                case INT: {
                    m.setAsInt(s.readInt(), c);
                    break;
                }
                default: {
                    m.setAsObject(s.readObject(), c);
                }
            }
        }
        s.close();
        return m;
    }
}

