/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.shortmatrix.calculation;

import org.ujmp.core.Coordinates;
import org.ujmp.core.Matrix;
import org.ujmp.core.MatrixFactory;
import org.ujmp.core.calculation.AbstractCalculation;
import org.ujmp.core.enums.ValueType;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.shortmatrix.ShortMatrix;
import org.ujmp.core.shortmatrix.calculation.ShortCalculation;
import org.ujmp.core.shortmatrix.impl.ShortCalculationMatrix;

public abstract class AbstractShortCalculation
extends AbstractCalculation
implements ShortCalculation {
    private static final long serialVersionUID = 7200876039893919030L;

    public AbstractShortCalculation(Matrix ... sources) {
        super(sources);
    }

    public AbstractShortCalculation(int dimension, Matrix ... sources) {
        super(dimension, sources);
    }

    public final ShortMatrix calcLink() throws MatrixException {
        return new ShortCalculationMatrix(this);
    }

    public final ShortMatrix calcNew() throws MatrixException {
        ShortMatrix result = (ShortMatrix)MatrixFactory.zeros(ValueType.SHORT, this.getSize());
        for (long[] c : result.allCoordinates()) {
            result.setAsShort(this.getShort(c), c);
        }
        if (this.getAnnotation() != null) {
            result.setAnnotation(this.getAnnotation().clone());
        }
        return result;
    }

    public final Matrix calcOrig() throws MatrixException {
        if (!Coordinates.equals(this.getSource().getSize(), this.getSize())) {
            throw new MatrixException("Cannot change Matrix size. Use calc(Ret.NEW) or calc(Ret.LINK) instead.");
        }
        for (long[] c : this.getSource().allCoordinates()) {
            this.getSource().setAsShort(this.getShort(c), c);
        }
        this.getSource().notifyGUIObject();
        return this.getSource();
    }

    public void setShort(short value, long ... coordinates) throws MatrixException {
    }

    public final ValueType getValueType() {
        return ValueType.SHORT;
    }
}

