/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.gui.statusbar;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.TimerTask;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.ujmp.core.interfaces.GUIObject;
import org.ujmp.gui.MatrixGUIObject;
import org.ujmp.gui.statusbar.MatrixStatisticsBar;
import org.ujmp.gui.statusbar.MemoryUsage;
import org.ujmp.gui.util.TaskQueue;

public class StatusBar
extends JPanel {
    private static final long serialVersionUID = -92341245296146976L;
    private final JLabel taskStatus = new JLabel();
    private JLabel objectStatus = null;
    private GUIObject object = null;
    private final JProgressBar jProgressBar = new JProgressBar();

    public StatusBar(GUIObject o) {
        this.object = o;
        this.objectStatus = o instanceof MatrixGUIObject ? new MatrixStatisticsBar((MatrixGUIObject)o) : new JLabel();
        this.setPreferredSize(new Dimension(1000, 30));
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setLayout(new GridBagLayout());
        this.taskStatus.setPreferredSize(new Dimension(200, 30));
        this.taskStatus.setMinimumSize(new Dimension(200, 30));
        this.add((Component)this.objectStatus, new GridBagConstraints(0, 0, 1, 1, 0.2, 1.0, 13, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)this.taskStatus, new GridBagConstraints(2, 0, 1, 1, 0.0, 1.0, 13, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)new MemoryUsage(), new GridBagConstraints(3, 0, 1, 1, 0.0, 1.0, 13, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.jProgressBar.setStringPainted(false);
        this.jProgressBar.setMinimum(0);
        this.jProgressBar.setMaximum(1000);
        this.jProgressBar.setValue(1000);
        this.jProgressBar.setVisible(false);
        this.objectStatus.setBorder(BorderFactory.createEtchedBorder());
        this.taskStatus.setBorder(BorderFactory.createEtchedBorder());
        this.jProgressBar.setBorder(BorderFactory.createEtchedBorder());
        this.add((Component)this.jProgressBar, new GridBagConstraints(1, 0, 1, 1, 0.8, 1.0, 13, 1, new Insets(2, 2, 2, 2), 0, 0));
    }

    public void start() {
        this.stop();
    }

    public void stop() {
    }

    public void setTaskString(String s) {
        this.taskStatus.setText(s);
    }

    public void setObjectString(String s) {
        this.objectStatus.setText(s);
    }

    public void setProgress(Double progress) {
        if (progress == null) {
            this.jProgressBar.setValue(0);
            this.jProgressBar.setIndeterminate(true);
            this.jProgressBar.setVisible(true);
        } else if (progress == 1.0) {
            this.jProgressBar.setValue(1000);
            this.jProgressBar.setVisible(false);
        } else {
            int value = (int)(progress * (double)this.jProgressBar.getMaximum());
            this.jProgressBar.setIndeterminate(false);
            this.jProgressBar.setValue(value);
            this.jProgressBar.setVisible(true);
        }
    }

    public GUIObject getObject() {
        return this.object;
    }

    class UpdateTask
    extends TimerTask {
        private StatusBar statusBar = null;

        public UpdateTask(StatusBar statusBar2) {
            this.statusBar = statusBar2;
        }

        public void run() {
            this.statusBar.setTaskString(TaskQueue.getStatus());
            this.statusBar.setObjectString("" + StatusBar.this.getObject());
            this.statusBar.setProgress(TaskQueue.getProgress());
        }
    }
}

